/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.AbstractTemplateStatusInput;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class TemplateStatusFileInput
extends AbstractTemplateStatusInput {
    protected final Template template;
    protected final File file;

    public TemplateStatusFileInput(File file) {
        TemplateStatus newTemplateStatus;
        this.file = file;
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        try {
            newTemplateStatus = xmlImport.getTemplateStatusFromTemplateFile(file);
            this.template = xmlImport.getTemplateFromFile(file);
        }
        catch (VersionException e) {
            throw new RuntimeException(e);
        }
        catch (XMLFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String newTemplateName = this.template.getName();
        this.init(newTemplateStatus, newTemplateName);
    }

    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void doSave(IProgressMonitor monitor) throws DataSourceException {
        ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
        try {
            xmlExport.writeTemplateAndStatusToFile(this.template, this.templateStatus, this.file);
        }
        catch (IOException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException((Throwable)e);
        }
    }
}

