/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processediting.AbstractTemplateStatusInput;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TemplateStatusFormPage
extends FormPage
implements SelectionListener,
ModifyListener {
    private final AbstractTemplateStatusInput templateStatusInput;
    protected TemplateStatus templateStatus;
    private TemplateStatus orgiginalStatus;
    private Composite generalContainer;
    private Combo buildTimeStateCombo;
    private Button derivableButton;
    private Text derivableComment;
    private Button topLevelButton;
    private Combo subProcessUsageCombo;
    protected Text sarText;
    private XLevelSection topLevelSection;
    private XLevelSection supPLevelSection;
    private IManagedForm managedForm;
    private boolean dirty;

    public TemplateStatusFormPage(FormEditor editor, String id, String title, AbstractTemplateStatusInput templateStatusInput) {
        super(editor, id, title);
        this.templateStatusInput = templateStatusInput;
        this.templateStatus = templateStatusInput.getTemplateStatus();
        this.orgiginalStatus = ProcessModelTools.cloneTemplateStatus((TemplateStatus)this.templateStatus, (ProcessModelFactory)Activator.getAMService().getProcessModelFactory());
    }

    protected void createFormContent(IManagedForm myManagedForm) {
        this.managedForm = myManagedForm;
        super.createFormContent(this.managedForm);
        FormToolkit toolkit = this.managedForm.getToolkit();
        ScrolledForm form = this.managedForm.getForm();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        Composite parent = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        this.generalContainer = toolkit.createComposite(parent, 0);
        GridLayout generalLayout = new GridLayout(4, false);
        this.generalContainer.setLayout((Layout)generalLayout);
        TableWrapData tableData = new TableWrapData(2, 16, 1, 2);
        this.generalContainer.setLayoutData((Object)tableData);
        Label topLabel = toolkit.createLabel(this.generalContainer, "The template status of template " + this.templateStatusInput.getTemplateName());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = 4;
        topLabel.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(this.generalContainer, "Current build time state");
        gridData = new GridData(0, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.buildTimeStateCombo = new Combo(this.generalContainer, 12);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 2;
        this.buildTimeStateCombo.setLayoutData((Object)gridData);
        ProcessConstants.TemplateBuildtimeState[] templateBuildtimeStateArray = ProcessConstants.TemplateBuildtimeState.values();
        int n = templateBuildtimeStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.TemplateBuildtimeState buildTimeState = templateBuildtimeStateArray[n2];
            this.buildTimeStateCombo.add(buildTimeState.name());
            ++n2;
        }
        this.buildTimeStateCombo.select(this.buildTimeStateCombo.indexOf(this.templateStatus.getBuildtimeState().name()));
        this.buildTimeStateCombo.addSelectionListener((SelectionListener)this);
        this.derivableButton = toolkit.createButton(this.generalContainer, "Allow derivation of new templates of this version.", 32);
        this.derivableButton.setSelection(this.templateStatus.isDerivable());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.derivableButton.setLayoutData((Object)gridData);
        this.derivableButton.addSelectionListener((SelectionListener)this);
        label = toolkit.createLabel(this.generalContainer, "Comment:");
        gridData = new GridData(0, 128, false, false);
        gridData.horizontalIndent = 18;
        label.setLayoutData((Object)gridData);
        this.derivableComment = toolkit.createText(this.generalContainer, this.templateStatus.getDerivableComment(), 576);
        gridData = new GridData(4, 1, true, false);
        gridData.heightHint = 30;
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 3;
        this.derivableComment.setLayoutData((Object)gridData);
        this.derivableComment.addModifyListener((ModifyListener)this);
        this.topLevelButton = toolkit.createButton(this.generalContainer, "Allow top-level process usage for this template.", 32);
        this.topLevelButton.setSelection(this.templateStatus.isTopLevelUsable());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.topLevelButton.setLayoutData((Object)gridData);
        this.topLevelButton.addSelectionListener((SelectionListener)this);
        label = toolkit.createLabel(this.generalContainer, "Specify the usage as sub-process");
        gridData = new GridData(0, 0x1000000, false, false);
        gridData.horizontalIndent = 18;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.subProcessUsageCombo = new Combo(this.generalContainer, 12);
        gridData = new GridData(0, 128, true, false);
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 2;
        this.subProcessUsageCombo.setLayoutData((Object)gridData);
        templateBuildtimeStateArray = ProcessConstants.TemplateUsage.values();
        n = templateBuildtimeStateArray.length;
        n2 = 0;
        while (n2 < n) {
            ProcessConstants.TemplateBuildtimeState templateUsage = templateBuildtimeStateArray[n2];
            this.subProcessUsageCombo.add(templateUsage.name());
            ++n2;
        }
        this.subProcessUsageCombo.select(this.subProcessUsageCombo.indexOf(this.templateStatus.getUsageAsSubprocess().name()));
        this.subProcessUsageCombo.addSelectionListener((SelectionListener)this);
        toolkit.createLabel(this.generalContainer, "Starter Rule");
        this.sarText = toolkit.createText(this.generalContainer, this.templateStatus.getStarterRule(), 2);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        this.sarText.setLayoutData((Object)gridData);
        this.sarText.addModifyListener((ModifyListener)this);
        final StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
        if (providers.length > 0) {
            final Button sarButton = toolkit.createButton(this.generalContainer, "...", 8);
            gridData = new GridData(131072, 0x1000000, false, false);
            sarButton.setLayoutData((Object)gridData);
            sarButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OrgModelManager orgModelManager = Activator.getAMService().getOrgModelManager();
                    StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(sarButton.getShell(), orgModelManager);
                    dialogue.open(TemplateStatusFormPage.this.sarText.getText());
                    TemplateStatusFormPage.this.sarText.setText(dialogue.getStaffAssignmentRule());
                    TemplateStatusFormPage.this.widgetSelected(e);
                }
            });
        }
        this.topLevelSection = new XLevelSection(parent, toolkit, false);
        tableData = new TableWrapData(256, 16);
        this.topLevelSection.section.setLayoutData((Object)tableData);
        this.supPLevelSection = new XLevelSection(parent, toolkit, true);
        tableData = new TableWrapData(256, 16);
        this.supPLevelSection.section.setLayoutData((Object)tableData);
        toolkit.paintBordersFor(this.generalContainer);
        form.layout();
        this.updateVisuals();
    }

    public void doSave(IProgressMonitor monitor) {
        boolean error = false;
        try {
            this.templateStatusInput.doSave(monitor);
        }
        catch (DataSourceException e) {
            monitor.setCanceled(true);
            String message = "Could not save the template status. Error while writing to the file.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            error = true;
        }
        catch (LockException e) {
            monitor.setCanceled(true);
            String message = "Could not save the template status. Error while locking TemplateManger to save template status.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            error = true;
        }
        catch (InvalidTemplateStateException e) {
            monitor.setCanceled(true);
            String message = "Could not save the template status / New template status rejected!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            error = true;
        }
        this.templateStatus = this.templateStatusInput.getTemplateStatus();
        if (!error) {
            this.orgiginalStatus = ProcessModelTools.cloneTemplateStatus((TemplateStatus)this.templateStatus, (ProcessModelFactory)Activator.getAMService().getProcessModelFactory());
        }
        this.checkDirty();
        this.updateVisuals();
    }

    private void updateVisuals() {
        this.showHideStatusWidgets();
        boolean released = this.templateStatus.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED;
        this.derivableButton.setEnabled(released);
        this.derivableComment.setEnabled(released);
        this.topLevelSection.setEnabled(released);
        this.supPLevelSection.setEnabled(released);
        if (released) {
            this.buildTimeStateCombo.setToolTipText("The template has been released already, this can't be undone.");
            this.buildTimeStateCombo.setEnabled(false);
        }
    }

    private void showHideStatusWidgets() {
        boolean subProcess = this.subProcessUsageCombo.getSelectionIndex() != -1 && ProcessConstants.TemplateUsage.values()[this.subProcessUsageCombo.getSelectionIndex()] != ProcessConstants.TemplateUsage.NO_SUBPROCESS;
        this.supPLevelSection.section.setVisible(subProcess);
        this.topLevelSection.section.setVisible(this.topLevelButton.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateTemplateStatus();
        this.checkDirty();
        this.updateVisuals();
    }

    public void modifyText(ModifyEvent e) {
        this.updateTemplateStatus();
        this.checkDirty();
        this.updateVisuals();
    }

    private void updateTemplateStatus() {
        block7: {
            block6: {
                String buildTimeString = this.buildTimeStateCombo.getItem(this.buildTimeStateCombo.getSelectionIndex());
                ProcessConstants.TemplateBuildtimeState buildtimeState = ProcessConstants.TemplateBuildtimeState.valueOf((String)buildTimeString);
                if (buildtimeState == ProcessConstants.TemplateBuildtimeState.RELEASED && this.orgiginalStatus.getBuildtimeState() != ProcessConstants.TemplateBuildtimeState.RELEASED) {
                    try {
                        this.templateStatus.release();
                    }
                    catch (InvalidTemplateStateException invalidTemplateStateException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)"Unreachable code - form element was assumed to be disabled.");
                    }
                }
            }
            if (this.templateStatus.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED) {
                try {
                    this.templateStatus.setDerivable(this.derivableButton.getSelection(), this.derivableComment.getText());
                }
                catch (InvalidTemplateStateException invalidTemplateStateException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)"Unreachable code - form element was assumed to be disabled.");
                }
            }
        }
        this.templateStatus.setTopLevelUsage(this.topLevelButton.getSelection());
        String usageString = this.subProcessUsageCombo.getItem(this.subProcessUsageCombo.getSelectionIndex());
        this.templateStatus.setSubprocessUsage(ProcessConstants.TemplateUsage.valueOf((String)usageString));
        this.templateStatus.setStarterRule(this.sarText.getText());
        this.topLevelSection.updateTemplateStatus();
        this.supPLevelSection.updateTemplateStatus();
    }

    private void checkDirty() {
        TemplateStatus ns = this.templateStatus;
        TemplateStatus os = this.orgiginalStatus;
        boolean oldDirty = this.dirty;
        this.dirty = ns.getBuildtimeState() != os.getBuildtimeState() || ns.isDerivable() != os.isDerivable() || !ns.getDerivableComment().equals(os.getDerivableComment()) || ns.isTopLevelUsable() != os.isTopLevelUsable() || ns.getUsageAsSubprocess() != os.getUsageAsSubprocess() || !ns.getStarterRule().equals(os.getStarterRule()) || ns.isOutdated(false) != os.isOutdated(false) || !ns.getOutdatedComment(false).equals(os.getOutdatedComment(false)) || ns.isOutdated(true) != os.isOutdated(true) || !ns.getOutdatedComment(true).equals(os.getOutdatedComment(true)) || ns.isInstantiable(false) != os.isInstantiable(false) || !ns.getInstantiableComment(false).equals(os.getInstantiableComment(false)) || ns.isInstantiable(true) != os.isInstantiable(true) || !ns.getInstantiableComment(true).equals(os.getInstantiableComment(true)) || ns.areInstancesMigratableTo(false) != os.areInstancesMigratableTo(false) || !ns.getInstancesMigratableToComment(false).equals(os.getInstancesMigratableToComment(false)) || ns.areInstancesMigratableTo(true) != os.areInstancesMigratableTo(true) || !ns.getInstancesMigratableToComment(true).equals(os.getInstancesMigratableToComment(true)) || ns.areInstancesChangeable(false) != os.areInstancesChangeable(false) || !ns.getInstancesChangeableComment(false).equals(os.getInstancesChangeableComment(false)) || ns.areInstancesChangeable(true) != os.areInstancesChangeable(true) || !ns.getInstancesChangeableComment(true).equals(os.getInstancesChangeableComment(true));
        if (oldDirty != this.dirty) {
            this.getEditor().editorDirtyStateChanged();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected class XLevelSection {
        protected final Section section;
        private final Button outdatedButton;
        private final Text outdatedComment;
        private final Button instantiableButton;
        private final Text instantiableComment;
        private final Button migratableButton;
        private final Text migratableComment;
        private final Button changeableButton;
        private final Text changeableComment;
        private final boolean subprocessScope;

        public XLevelSection(Composite parent, FormToolkit toolkit, boolean subprocessScope) {
            this.subprocessScope = subprocessScope;
            this.section = toolkit.createSection(parent, -1);
            if (subprocessScope) {
                this.section.setText("Sub-Process Scope");
                this.section.setDescription("The following values settle the usage of the template when it is used as a sub-process");
            } else {
                this.section.setText("Top-Level Process Scope");
                this.section.setDescription("The following values settle the usage of the template when it is used as a top-level process");
            }
            Composite client = toolkit.createComposite((Composite)this.section);
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 2;
            client.setLayout((Layout)layout);
            this.outdatedButton = toolkit.createButton(client, "Template outdated", 32);
            TableWrapData layoutData = new TableWrapData();
            layoutData.colspan = 2;
            this.outdatedButton.setLayoutData((Object)layoutData);
            this.outdatedButton.setSelection(TemplateStatusFormPage.this.templateStatus.isOutdated(subprocessScope));
            this.outdatedButton.addSelectionListener((SelectionListener)TemplateStatusFormPage.this);
            Label label = toolkit.createLabel(client, "Comment:");
            layoutData = new TableWrapData(2, 16);
            layoutData.indent = 18;
            label.setLayoutData((Object)layoutData);
            this.outdatedComment = toolkit.createText(client, TemplateStatusFormPage.this.templateStatus.getOutdatedComment(subprocessScope), 576);
            layoutData = new TableWrapData(256, 16);
            layoutData.heightHint = 30;
            layoutData.indent = 5;
            this.outdatedComment.setLayoutData((Object)layoutData);
            this.outdatedComment.addModifyListener((ModifyListener)TemplateStatusFormPage.this);
            this.instantiableButton = toolkit.createButton(client, "Template instantiable", 32);
            layoutData = new TableWrapData();
            layoutData.colspan = 2;
            this.instantiableButton.setLayoutData((Object)layoutData);
            this.instantiableButton.setSelection(TemplateStatusFormPage.this.templateStatus.isInstantiable(subprocessScope));
            this.instantiableButton.addSelectionListener((SelectionListener)TemplateStatusFormPage.this);
            label = toolkit.createLabel(client, "Comment:");
            layoutData = new TableWrapData(2, 16);
            layoutData.indent = 18;
            label.setLayoutData((Object)layoutData);
            this.instantiableComment = toolkit.createText(client, TemplateStatusFormPage.this.templateStatus.getInstantiableComment(subprocessScope), 576);
            layoutData = new TableWrapData(256, 16);
            layoutData.heightHint = 30;
            layoutData.indent = 5;
            this.instantiableComment.setLayoutData((Object)layoutData);
            this.instantiableComment.addModifyListener((ModifyListener)TemplateStatusFormPage.this);
            this.migratableButton = toolkit.createButton(client, "Allow migration of instances to this template", 32);
            layoutData = new TableWrapData();
            layoutData.colspan = 2;
            this.migratableButton.setLayoutData((Object)layoutData);
            this.migratableButton.setSelection(TemplateStatusFormPage.this.templateStatus.areInstancesMigratableTo(subprocessScope));
            this.migratableButton.addSelectionListener((SelectionListener)TemplateStatusFormPage.this);
            this.migratableButton.setToolTipText("Specifies if running instances of an old template version are migratable to this template.");
            label = toolkit.createLabel(client, "Comment:");
            layoutData = new TableWrapData(2, 16);
            layoutData.indent = 18;
            label.setLayoutData((Object)layoutData);
            this.migratableComment = toolkit.createText(client, TemplateStatusFormPage.this.templateStatus.getInstancesMigratableToComment(subprocessScope), 576);
            layoutData = new TableWrapData(256, 16);
            layoutData.heightHint = 30;
            layoutData.indent = 5;
            this.migratableComment.setLayoutData((Object)layoutData);
            this.migratableComment.addModifyListener((ModifyListener)TemplateStatusFormPage.this);
            this.changeableButton = toolkit.createButton(client, "Running instances changeable", 32);
            layoutData = new TableWrapData();
            layoutData.colspan = 2;
            this.changeableButton.setLayoutData((Object)layoutData);
            this.changeableButton.setSelection(TemplateStatusFormPage.this.templateStatus.areInstancesChangeable(subprocessScope));
            this.changeableButton.addSelectionListener((SelectionListener)TemplateStatusFormPage.this);
            this.changeableButton.setToolTipText("Specifies if running instances of this template allow instance specific changes.");
            label = toolkit.createLabel(client, "Comment:");
            layoutData = new TableWrapData(2, 16);
            layoutData.indent = 18;
            label.setLayoutData((Object)layoutData);
            this.changeableComment = toolkit.createText(client, TemplateStatusFormPage.this.templateStatus.getInstancesChangeableComment(subprocessScope), 576);
            layoutData = new TableWrapData(256, 16);
            layoutData.heightHint = 30;
            layoutData.indent = 5;
            this.changeableComment.setLayoutData((Object)layoutData);
            this.changeableComment.addModifyListener((ModifyListener)TemplateStatusFormPage.this);
            toolkit.paintBordersFor(client);
            this.section.setClient((Control)client);
        }

        protected void updateTemplateStatus() {
            block3: {
                if (TemplateStatusFormPage.this.templateStatus.getBuildtimeState() != ProcessConstants.TemplateBuildtimeState.RELEASED) {
                    return;
                }
                try {
                    TemplateStatusFormPage.this.templateStatus.setOutdated(this.outdatedButton.getSelection(), this.subprocessScope, this.outdatedComment.getText());
                    TemplateStatusFormPage.this.templateStatus.setInstantiable(this.instantiableButton.getSelection(), this.subprocessScope, this.instantiableComment.getText());
                    TemplateStatusFormPage.this.templateStatus.setInstancesMigratableTo(this.migratableButton.getSelection(), this.subprocessScope, this.migratableComment.getText());
                    TemplateStatusFormPage.this.templateStatus.setInstancesChangeable(this.changeableButton.getSelection(), this.subprocessScope, this.changeableComment.getText());
                }
                catch (InvalidTemplateStateException invalidTemplateStateException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"Unreachable code, should have returned immediately!");
                }
            }
        }

        protected void setEnabled(boolean enabled) {
            this.section.setEnabled(enabled);
            this.outdatedButton.setEnabled(enabled);
            this.instantiableButton.setEnabled(enabled);
            this.migratableButton.setEnabled(enabled);
            this.changeableButton.setEnabled(enabled);
        }
    }
}

