/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processediting.AbstractTemplateStatusInput;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;

public class TemplateStatusProcessManagerInput
extends AbstractTemplateStatusInput {
    private final ProcessManager processManager;
    private final UUID templateID;

    public TemplateStatusProcessManagerInput(ProcessManager processManager, UUID templateID, String templateName) {
        this.processManager = processManager;
        this.templateID = templateID;
        SessionToken session = Activator.getService().getSessionToken();
        TemplateManager templateManager = processManager.getTemplateManager();
        TemplateStatus status = templateManager.getTemplateStatus(session, templateID);
        this.init(status, templateName);
    }

    @Override
    public void doSave(IProgressMonitor monitor) throws LockException, InvalidTemplateStateException {
        SessionToken session = Activator.getService().getSessionToken();
        this.processManager.getTemplateManager().getAndLockTemplateStatus(session, this.templateID);
        try {
            this.processManager.getTemplateManager().setTemplateStatus(session, this.templateStatus);
        }
        finally {
            this.processManager.getTemplateManager().unlockTemplateStatus(session, this.templateID);
        }
    }

    public boolean exists() {
        return false;
    }
}

