/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.AbstractProcessEditAction;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import org.eclipse.jface.action.IAction;

public abstract class AbstractControlFlowEdgeEditingAction
extends AbstractProcessEditAction {
    protected AbstractControlFlowEdgeEditingAction() {
    }

    protected AbstractControlFlowEdgeEditingAction(String enabledImage, String disabledImage) {
        super(enabledImage, disabledImage);
    }

    @Override
    protected Object selectionChanged(IAction action, Object selection, Template template, ChangeableInstance instance) {
        Node succ;
        Node pred;
        if (selection instanceof DataEdgeEditPart) {
            return null;
        }
        EdgeEditPart eep = (EdgeEditPart)selection;
        int predID = eep.getSourceNodeID();
        int succID = eep.getDestNodeID();
        if (instance != null) {
            pred = instance.getTemplate().getNode(predID);
            succ = instance.getTemplate().getNode(succID);
        } else {
            pred = template.getNode(predID);
            succ = template.getNode(succID);
        }
        if (this.isPossible(template, instance, pred, succ)) {
            action.setEnabled(true);
            return selection;
        }
        return null;
    }

    protected abstract boolean isPossible(Template var1, ChangeableInstance var2, Node var3, Node var4);

    @Override
    protected final String performOperation(Object selection, ChangeableTemplate template, ChangeableInstance instance, SessionToken session) {
        Node succ;
        Node pred;
        EdgeEditPart eep = (EdgeEditPart)selection;
        int predID = eep.getSourceNodeID();
        int succID = eep.getDestNodeID();
        if (instance != null) {
            pred = instance.getTemplate().getNode(predID);
            succ = instance.getTemplate().getNode(succID);
        } else {
            pred = template.getNode(predID);
            succ = template.getNode(succID);
        }
        return this.performOperation(session, template, instance, pred, succ);
    }

    protected abstract String performOperation(SessionToken var1, ChangeableTemplate var2, ChangeableInstance var3, Node var4, Node var5);
}

