/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.AbstractProcessEditAction;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import org.eclipse.jface.action.IAction;

public abstract class AbstractExistingBlockEditAction
extends AbstractProcessEditAction {
    protected AbstractExistingBlockEditAction() {
    }

    protected AbstractExistingBlockEditAction(String enabledImage, String disabledImage) {
        super(enabledImage, disabledImage);
    }

    @Override
    protected final Object selectionChanged(IAction action, Object selection, Template template, ChangeableInstance instance) {
        if (selection instanceof DataElementEditPart) {
            return null;
        }
        Node splitOrJoin = (Node)((DefaultNodeEditPart)selection).getModel();
        Node[] splitJoin = this.getSplitJoin(template, (Instance)instance, splitOrJoin);
        if (splitJoin == null) {
            return null;
        }
        Node split = splitJoin[0];
        Node join = splitJoin[1];
        action.setEnabled(this.isPossible(template, instance, split, join));
        return selection;
    }

    protected abstract boolean isPossible(Template var1, ChangeableInstance var2, Node var3, Node var4);

    @Override
    protected final String performOperation(Object selection, ChangeableTemplate template, ChangeableInstance instance, SessionToken session) {
        Node splitOrJoin = (Node)((DefaultNodeEditPart)selection).getModel();
        Node[] splitJoin = this.getSplitJoin((Template)template, (Instance)instance, splitOrJoin);
        if (splitJoin == null) {
            return null;
        }
        Node split = splitJoin[0];
        Node join = splitJoin[1];
        return this.performOperation(session, template, instance, split, join);
    }

    protected abstract String performOperation(SessionToken var1, ChangeableTemplate var2, ChangeableInstance var3, Node var4, Node var5);

    protected final Node[] getSplitJoin(Template template, Instance instance, Node node) {
        Node split;
        Node join;
        Template myTemplate = template;
        if (instance != null) {
            myTemplate = instance.getTemplate();
        }
        ProcessConstants.NodeType type = myTemplate.getNodeType(node.getID());
        switch (type) {
            case NT_AND_JOIN: 
            case NT_XOR_JOIN: 
            case NT_ENDLOOP: {
                join = node;
                split = myTemplate.getNode(myTemplate.getNodeCorrespondingBlockNodeID(join.getID()));
                break;
            }
            case NT_AND_SPLIT: 
            case NT_XOR_SPLIT: 
            case NT_STARTLOOP: {
                split = node;
                join = myTemplate.getNode(myTemplate.getNodeCorrespondingBlockNodeID(split.getID()));
                break;
            }
            default: {
                return null;
            }
        }
        return new Node[]{split, join};
    }
}

