/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.icons.ChangeOperationImageRegistry;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractProcessEditAction
implements IObjectActionDelegate {
    protected final UpdateManager updateManager;
    protected Logger logger = LoggerTools.getLogger((Object)this);
    protected Editor editor;
    protected Object selectedForRun;
    private final ImageDescriptor enabledImage;
    private final ImageDescriptor disabledImage;

    protected AbstractProcessEditAction(String enabledImage, String disabledImage) {
        this.enabledImage = this.getSharedImage(enabledImage);
        this.disabledImage = this.getSharedImage(disabledImage);
        this.updateManager = Activator.getService().getUpdateManager();
    }

    protected AbstractProcessEditAction() {
        this(null, null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.editor = this.validEditorAndContent(targetPart) ? (Editor)targetPart : null;
    }

    protected boolean validEditorAndContent(IWorkbenchPart targetPart) {
        if (targetPart instanceof Editor) {
            Editor newEditor = (Editor)targetPart;
            Instance instance = newEditor.getInstance();
            Template template = newEditor.getTemplate();
            if (instance instanceof ChangeableInstance || instance == null && template instanceof ChangeableTemplate) {
                return true;
            }
        }
        return false;
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        this.selectedForRun = null;
        if (this.editor == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection s = (StructuredSelection)selection;
        if (s.size() > 1) {
            return;
        }
        Object selectedElement = s.getFirstElement();
        Template template = this.editor.getTemplate();
        ChangeableInstance instance = (ChangeableInstance)this.editor.getInstance();
        this.selectedForRun = this.selectionChanged(action, selectedElement, template, instance);
        if (!action.isEnabled()) {
            if (this.enabledImage != null) {
                action.setImageDescriptor(this.enabledImage);
            }
            this.selectedForRun = null;
        } else if (this.disabledImage != null) {
            action.setImageDescriptor(this.disabledImage);
        }
    }

    protected abstract Object selectionChanged(IAction var1, Object var2, Template var3, ChangeableInstance var4);

    public void run(IAction action) {
        if (this.selectedForRun != null) {
            ChangeableTemplate template = null;
            if (this.editor.getInstance() == null && this.editor.getTemplate() instanceof ChangeableTemplate) {
                template = (ChangeableTemplate)this.editor.getTemplate();
            }
            ChangeableInstance instance = null;
            if (this.editor.getInstance() instanceof ChangeableInstance) {
                instance = (ChangeableInstance)this.editor.getInstance();
            }
            if (this.isAdhoc(this.editor)) {
                StartTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)this.updateManager);
            } else {
                StartTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)this.updateManager);
            }
            SessionToken session = this.getSessionToken();
            String transactionLabel = this.performOperation(this.selectedForRun, template, instance, session);
            if (this.isAdhoc(this.editor)) {
                EndTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)this.updateManager, (String)transactionLabel);
            } else {
                EndTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)this.updateManager, (String)transactionLabel);
            }
        }
    }

    protected ImageDescriptor getSharedImage(String key) {
        if (key != null) {
            return ChangeOperationImageRegistry.getImageDescriptor((String)key);
        }
        return null;
    }

    protected abstract String performOperation(Object var1, ChangeableTemplate var2, ChangeableInstance var3, SessionToken var4);

    protected boolean isAdhoc(Editor editor) {
        return editor.getInstance() instanceof ChangeableInstance;
    }

    protected SessionToken getSessionToken() {
        return Activator.getService().getSessionToken();
    }
}

