/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.EmbeddedTemplateInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.TransientTemplateInput;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowSubProcessAction
implements IObjectActionDelegate {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    Node selectedNode;
    IWorkbenchPart activePart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public void run(IAction action) {
        Template template;
        TemplateManager templateManager = Activator.getService().getProcessManager().getTemplateManager();
        SessionToken session = Activator.getService().getSessionToken();
        ExecutableBusinessProcess ebp = this.selectedNode.getExecutableBusinessProcess();
        TemplateInput templateInput = null;
        if (ebp instanceof VariableParallelismEBP) {
            ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
        }
        if (ebp instanceof ReferencedProcess) {
            UUID templateID = ((ReferencedProcess)ebp).getTemplateID();
            try {
                template = templateManager.getTemplate(session, templateID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String msg = "Cannot open the subprocess with ID '%s' because it was not found on the server.";
                String message = String.format(msg, templateID);
                this.logger.log(Level.WARNING, message);
                MessageDialog d = new MessageDialog(null, "Template not found", null, message, 1, new String[]{"Ok"}, 0);
                d.open();
                return;
            }
            templateInput = new TransientTemplateInput(template);
        } else if (this.activePart instanceof Editor && ebp instanceof EmbeddedProcess) {
            int[] nodeIDPath;
            Editor editor = (Editor)this.activePart;
            if (editor.getEditorInput() instanceof EmbeddedTemplateInput) {
                EmbeddedTemplateInput parentEmbedded = (EmbeddedTemplateInput)editor.getEditorInput();
                int[] parentNodeIDPath = parentEmbedded.getNodeIDPath();
                nodeIDPath = new int[parentNodeIDPath.length + 1];
                int i = 0;
                while (i < parentNodeIDPath.length) {
                    nodeIDPath[i] = parentNodeIDPath[i];
                    ++i;
                }
                nodeIDPath[nodeIDPath.length - 1] = this.selectedNode.getID();
            } else {
                nodeIDPath = new int[]{this.selectedNode.getID()};
            }
            templateInput = new EmbeddedTemplateInput(editor, nodeIDPath);
        } else if (ebp instanceof EmbeddedProcess) {
            template = ((EmbeddedProcess)ebp).getTemplate();
            templateInput = new TransientTemplateInput(template);
        }
        if (templateInput != null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorRegistry editorRegistry = window.getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor("file.template");
            try {
                page.openEditor((IEditorInput)templateInput, editorDescriptor.getId());
            }
            catch (PartInitException ex) {
                String msg = "The editor could not be opened!";
                this.logger.log(Level.SEVERE, msg, ex);
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.activePart != null && selection != null && !selection.isEmpty() && (selection instanceof StructuredSelection || selection instanceof Selection.SelectionList)) {
            Object element = null;
            element = selection instanceof StructuredSelection ? ((StructuredSelection)selection).getFirstElement() : ((Selection.SelectionList)selection).getFirstElement();
            if (element instanceof DefaultNodeEditPart && !(element instanceof DataElementEditPart)) {
                this.selectedNode = (Node)((DefaultNodeEditPart)element).getModel();
                if (!(this.selectedNode.getExecutableBusinessProcess() instanceof LightWeightProcess) && !(this.selectedNode.getExecutableBusinessProcess() instanceof VariableParallelismEBP)) {
                    action.setEnabled(false);
                    this.selectedNode = null;
                    return;
                }
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
                this.selectedNode = null;
            }
        } else {
            action.setEnabled(false);
            this.selectedNode = null;
        }
    }
}

