/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.icons.ChangeOperationImageRegistry;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeOperationAction
extends Action {
    protected final Logger logger;
    protected ToolItem item;
    protected ToolItem hintItem;
    private Node startNode;
    private Node endNode;
    private List<IProcessEditPart> primPreSelList;
    private List<IProcessEditPart> primPostSelList;
    private ChangePrimitives model;
    private Edge edge;
    private DataEdgeEditPart dataEdge;
    private DataElement startDataElement;
    private DataElement endDataElement;
    private UpdateManager updateManager;
    protected String enabledImage;
    protected String disabledImage;
    protected SelectionListener pushDownListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.detail == 0) {
                ChangeOperationAction.this.run();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    protected SelectionListener hintPushDownListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int cfr_ignored_0 = e.detail;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };

    public ChangeOperationAction(String enabledImage, String disabledImage) {
        this.setEnabled(false);
        this.enabledImage = enabledImage;
        this.disabledImage = disabledImage;
        this.logger = LoggerTools.getLogger((Object)((Object)this));
    }

    protected Image getSharedImage(String key) {
        if (key != null) {
            return ChangeOperationImageRegistry.getImage((String)key);
        }
        return ChangeOperationImageRegistry.getMissingImage();
    }

    protected void setStartElement(Object start) {
        this.startNode = null;
        this.startDataElement = null;
        this.edge = null;
        this.dataEdge = null;
        if (start instanceof Node) {
            this.startNode = (Node)start;
        } else if (start instanceof DataElement) {
            this.startDataElement = (DataElement)start;
        } else if (start instanceof Edge) {
            this.edge = (Edge)start;
        } else if (start instanceof DataEdgeEditPart) {
            this.dataEdge = (DataEdgeEditPart)start;
        }
    }

    protected void setEndElement(Object end) {
        this.endNode = null;
        this.endDataElement = null;
        if (end instanceof Node) {
            this.endNode = (Node)end;
        } else if (end instanceof DataElement) {
            this.endDataElement = (DataElement)end;
        }
    }

    protected void setModel(ChangePrimitives model) {
        this.model = model;
    }

    protected GraphicalViewer getViewer() {
        GraphicalViewer viewer = null;
        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (ed instanceof Editor) {
            viewer = (GraphicalViewer)((Editor)ed).getAdapter(GraphicalViewer.class);
        }
        return viewer;
    }

    protected Node getEndNode() {
        return this.endNode;
    }

    protected Node getStartNode() {
        return this.startNode;
    }

    protected ChangePrimitives getModel() {
        return this.model;
    }

    protected Edge getEdge() {
        return this.edge;
    }

    protected DataEdgeEditPart getDataEdgeEditPart() {
        return this.dataEdge;
    }

    protected DataElement getStartDataElement() {
        return this.startDataElement;
    }

    protected DataElement getEndDataElement() {
        return this.endDataElement;
    }

    protected void clear(boolean modelChanged) {
        if (modelChanged) {
            this.model = null;
            this.updateManager = null;
        }
        this.startDataElement = null;
        this.endDataElement = null;
        this.edge = null;
        this.dataEdge = null;
        this.startNode = null;
        this.endNode = null;
    }

    public void update(ChangePrimitives graph, List<IProcessEditPart> primPreSelList, List<IProcessEditPart> primPostSelList, UpdateManager updateManager, CheckReport checkReport) {
        this.clear(graph != this.getModel());
        this.setModel(graph);
        this.primPreSelList = primPreSelList;
        this.primPostSelList = primPostSelList;
        this.setEnabled(false);
        this.setUpdateManager(updateManager);
        this.update(checkReport);
    }

    public void disable() {
        this.clear(true);
        this.setEnabled(false);
    }

    protected void update(CheckReport checkReport) {
        boolean enable = true;
        if (this.primPreSelList.size() > 1 && this.primPostSelList.size() > 1) {
            String message = "No valid elements selected for this operation. Only one of primary pre and primary post selection may have more than a single element.";
            checkReport.addReportEntry("ChangeOperationAction", CheckReport.ResultType.FAILURE, message, new URI[0]);
            enable = false;
        } else if (this.primPreSelList.size() > 1) {
            this.setEndElement(this.primPostSelList.size() == 0 ? null : this.primPostSelList.get(0).getModel());
            for (IProcessEditPart preEditPart : this.primPreSelList) {
                this.setStartElement(preEditPart instanceof DataEdgeEditPart ? preEditPart : preEditPart.getModel());
                enable = this.isPossible(checkReport);
                if (enable) {
                    continue;
                }
                break;
            }
        } else if (this.primPostSelList.size() > 1) {
            this.setStartElement(this.primPreSelList.size() == 0 ? null : this.primPreSelList.get(0).getModel());
            for (IProcessEditPart postEditPart : this.primPostSelList) {
                this.setEndElement(postEditPart instanceof DataEdgeEditPart ? postEditPart : postEditPart.getModel());
                enable = this.isPossible(checkReport);
                if (enable) {
                    continue;
                }
                break;
            }
        } else {
            this.setStartElement(this.primPreSelList.size() == 0 ? null : (this.primPreSelList.get(0) instanceof DataEdgeEditPart ? this.primPreSelList.get(0) : this.primPreSelList.get(0).getModel()));
            this.setEndElement(this.primPostSelList.size() == 0 ? null : (this.primPostSelList.get(0) instanceof DataEdgeEditPart ? this.primPostSelList.get(0) : this.primPostSelList.get(0).getModel()));
            enable = this.isPossible(checkReport);
        }
        this.setEnabled(enable);
        this.updateToolTips(checkReport);
    }

    protected abstract boolean isPossible(CheckReport var1);

    public void createToolItem(ToolBar toolBar) {
        this.item = new ToolItem(toolBar, 8);
        this.item.setText(this.getText());
        this.item.setEnabled(this.isEnabled());
        this.item.setImage(this.getSharedImage(this.enabledImage));
        this.item.setDisabledImage(this.getSharedImage(this.disabledImage));
        this.item.setToolTipText(this.getToolTipText());
        this.item.addSelectionListener(this.pushDownListener);
        this.addPropertyChangeListener(new PropertyChangeListener(this.item));
    }

    public void createHintToolItem(ToolBar hintToolBar) {
        this.hintItem = new ToolItem(hintToolBar, 8);
        if (this.isEnabled()) {
            this.hintItem.setImage(this.getSharedImage("info"));
            this.hintItem.setToolTipText(this.getChangeOperationDescription());
        } else {
            this.hintItem.setImage(this.getSharedImage("warning"));
            this.hintItem.setToolTipText(this.item.getToolTipText());
        }
        this.hintItem.addSelectionListener(this.hintPushDownListener);
    }

    public abstract String getChangeOperationDescription();

    public void run() {
        if (this.isEnabled()) {
            SessionToken session = Activator.getService().getSessionToken();
            this.startChangeTransaction();
            LinkedList<IProcessEditPart> tempPrimPreSelList = new LinkedList<IProcessEditPart>(this.primPreSelList);
            LinkedList<IProcessEditPart> tempPrimPostSelList = new LinkedList<IProcessEditPart>(this.primPostSelList);
            if (tempPrimPreSelList.size() > 1) {
                this.setEndElement(tempPrimPostSelList.size() == 0 ? null : tempPrimPostSelList.get(0).getModel());
                for (IProcessEditPart preEditPart : tempPrimPreSelList) {
                    this.setStartElement(preEditPart instanceof DataEdgeEditPart ? preEditPart : preEditPart.getModel());
                    this.runChangeOp(session);
                }
            } else if (tempPrimPostSelList.size() > 1) {
                this.setStartElement(tempPrimPreSelList.size() == 0 ? null : tempPrimPreSelList.get(0).getModel());
                for (IProcessEditPart postEditPart : tempPrimPostSelList) {
                    this.setEndElement(postEditPart instanceof DataEdgeEditPart ? postEditPart : postEditPart.getModel());
                    this.runChangeOp(session);
                }
            } else {
                this.setStartElement(tempPrimPreSelList.size() == 0 ? null : (tempPrimPreSelList.get(0) instanceof DataEdgeEditPart ? tempPrimPreSelList.get(0) : tempPrimPreSelList.get(0).getModel()));
                this.setEndElement(tempPrimPostSelList.size() == 0 ? null : (tempPrimPostSelList.get(0) instanceof DataEdgeEditPart ? tempPrimPostSelList.get(0) : tempPrimPostSelList.get(0).getModel()));
                this.runChangeOp(session);
            }
            this.endChangeTransaction();
            this.updateViewer();
            this.updateSelection();
        }
    }

    protected void updateSelection() {
    }

    protected void updateViewer() {
        Editor editor;
        UISettings uiSettings;
        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (ed instanceof Editor && (uiSettings = (editor = (Editor)ed).getUISettings()).scrollToChanges()) {
            final GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            if (this.item != null) {
                this.item.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ChangeOperationAction.this.showChanges(viewer, uiSettings);
                    }
                });
            }
        }
    }

    protected void showChanges(final GraphicalViewer viewer, UISettings uiSettings) {
        if (this.getStartNode() == null && this.getEndNode() == null && this.getDataEdgeEditPart() == null && this.getEdge() == null && this.getStartDataElement() == null && this.getEndDataElement() == null) {
            this.logger.severe("Programming error: cannot update focus: there is no element.");
            return;
        }
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditPart part;
                if (ChangeOperationAction.this.getEndNode() != null && (part = (EditPart)viewer.getEditPartRegistry().get(ChangeOperationAction.this.getEndNode())) != null) {
                    viewer.reveal(part);
                }
                if (ChangeOperationAction.this.getStartNode() != null && (part = (EditPart)viewer.getEditPartRegistry().get(ChangeOperationAction.this.getStartNode())) != null) {
                    viewer.reveal(part);
                }
                if (ChangeOperationAction.this.getEdge() != null && (part = (EditPart)viewer.getEditPartRegistry().get(ChangeOperationAction.this.getEdge())) != null) {
                    viewer.reveal(part);
                }
                if (ChangeOperationAction.this.getStartDataElement() != null && (part = (EditPart)viewer.getEditPartRegistry().get(ChangeOperationAction.this.getStartDataElement())) != null) {
                    viewer.reveal(part);
                }
                if (ChangeOperationAction.this.getEndDataElement() != null && (part = (EditPart)viewer.getEditPartRegistry().get(ChangeOperationAction.this.getEndDataElement())) != null) {
                    viewer.reveal(part);
                }
                if (ChangeOperationAction.this.getDataEdgeEditPart() != null) {
                    viewer.reveal((EditPart)ChangeOperationAction.this.getDataEdgeEditPart());
                }
            }
        });
    }

    public abstract void runChangeOp(SessionToken var1);

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    protected void startChangeTransaction() {
        if (this.getModel() instanceof ChangeableInstance) {
            StartTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.getModel()), (UpdateManager)this.getUpdateManager());
        } else {
            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.getModel()), (UpdateManager)this.getUpdateManager());
        }
    }

    protected void endChangeTransaction() {
        if (this.getModel() instanceof ChangeableInstance) {
            EndTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.getModel()), (UpdateManager)this.getUpdateManager(), (String)this.getTransactionLabel());
        } else {
            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.getModel()), (UpdateManager)this.getUpdateManager(), (String)this.getTransactionLabel());
        }
    }

    protected String getTransactionLabel() {
        return this.getText();
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    protected void clearSelection() {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager sm = editor.getSelectionManager();
        sm.getActiveGroup().resetAllSelections();
    }

    protected void clearFocus() {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager sm = editor.getSelectionManager();
        sm.editPartClicked(null, false);
    }

    protected void refreshFocus() {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager sm = editor.getSelectionManager();
        IProcessEditPart part = sm.getActiveEditPart();
        sm.editPartClicked(part, false);
    }

    protected void updateToolTips(CheckReport checkReport) {
        if (this.item != null) {
            if (!this.isEnabled()) {
                CheckReport.ReportEntry entry;
                String text = "";
                if (checkReport != null && (entry = checkReport.getLastAddedReportEntry()) != null) {
                    text = entry.getMessage();
                }
                this.item.setToolTipText(text);
            } else {
                this.item.setToolTipText(this.getText());
            }
        }
        if (this.hintItem != null) {
            if (this.item.isEnabled()) {
                this.hintItem.setImage(this.getSharedImage("info"));
                this.hintItem.setToolTipText(this.getChangeOperationDescription());
            } else {
                this.hintItem.setImage(this.getSharedImage("warning"));
                this.hintItem.setToolTipText(this.item.getToolTipText());
            }
        }
    }

    protected List<IProcessEditPart> getPrimPreSelList() {
        return this.primPreSelList;
    }

    protected List<IProcessEditPart> getPrimPostSelList() {
        return this.primPostSelList;
    }

    protected boolean checkElementTypeEquality(CheckReport checkReport, List<IProcessEditPart> selList) {
        Class<?> tempClass = null;
        for (IProcessEditPart editPart : selList) {
            if (tempClass == null) {
                tempClass = editPart.getModel().getClass();
                continue;
            }
            if (tempClass == editPart.getModel().getClass()) continue;
            String message = "All elements in a selection must be of the same type, but they are different.";
            checkReport.addReportEntry("ChangeOperationAction", CheckReport.ResultType.FAILURE, message, new URI[]{checkReport.getBase()});
            return false;
        }
        return true;
    }

    static class PropertyChangeListener
    implements IPropertyChangeListener {
        private final ToolItem item;

        public PropertyChangeListener(ToolItem item) {
            this.item = item;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.item.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }
}

