/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteBorderNodes;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;

public class DeleteBorderNodesAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/DeleteBorderNodes";
    private int pred;
    private int succ;

    public DeleteBorderNodesAction() {
        super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
        this.setText("Delete Border Nodes");
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null) {
            if (this.getStartNode() != null && this.getEndNode() != null && this.getEdge() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return DeleteBorderNodes.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
                }
                return DeleteBorderNodes.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            String message = "Not enough/no correct elements selected for this operation. A single split node as start and a single join node as end element have to be selected.";
            checkReport.addReportEntry("Delete Border Nodes", CheckReport.ResultType.FAILURE, message, new URI[0]);
        } else {
            String message = "Model does not exists";
            checkReport.addReportEntry("Delete Border Nodes", CheckReport.ResultType.FAILURE, message, new URI[0]);
        }
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            Node startNode = this.getStartNode();
            Node endNode = this.getEndNode();
            Object template = null;
            template = this.getModel() instanceof ChangeableInstance ? ((ChangeableInstance)this.getModel()).getTemplate() : (ChangeableTemplate)this.getModel();
            this.pred = template.getPredByEdgeType(startNode.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL})[0];
            this.succ = template.getSuccByEdgeType(endNode.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL})[0];
            if (this.getModel() instanceof ChangeableInstance) {
                DeleteBorderNodes.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)startNode, (Node)endNode, (UpdateManager)this.getUpdateManager());
            } else {
                DeleteBorderNodes.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)startNode, (Node)endNode, (UpdateManager)this.getUpdateManager());
            }
        }
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        this.clearSelection();
    }

    @Override
    protected void showChanges(GraphicalViewer viewer, UISettings uiSettings) {
        Object template = null;
        template = this.getModel() instanceof ChangeableInstance ? ((ChangeableInstance)this.getModel()).getTemplate() : (ChangeableTemplate)this.getModel();
        EditPart part = (EditPart)viewer.getEditPartRegistry().get(template.getNode(this.pred));
        if (part != null) {
            viewer.reveal(part);
        }
        if ((part = (EditPart)viewer.getEditPartRegistry().get(template.getNode(this.succ))) != null) {
            viewer.reveal(part);
        }
    }

    @Override
    public String getChangeOperationDescription() {
        return "";
    }
}

