/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteConstraintEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public class DeleteConstraintEdgeAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/DeleteConstraintEdge";

    public DeleteConstraintEdgeAction() {
        super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
        this.setText("Delete Constraint Edge");
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null) {
            if (this.getStartNode() != null && this.getEndNode() != null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return DeleteConstraintEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
                }
                return DeleteConstraintEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            if (this.getEdge() instanceof ConstraintEdge) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return DeleteConstraintEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (ConstraintEdge)((ConstraintEdge)this.getEdge()), (CheckReport)checkReport);
                }
                return DeleteConstraintEdge.isPossible((ChangeableTemplate)((ChangeableTemplate)this.getModel()), (ConstraintEdge)((ConstraintEdge)this.getEdge()), (CheckReport)checkReport);
            }
            String message = "Edge null: Not enough/no correct elements selected for this operation. A single time lag has to be selected.";
            checkReport.addReportEntry("Delete Time Lag", CheckReport.ResultType.FAILURE, message, new URI[0]);
        } else {
            String message = "Model null: Not enough/no correct elements selected for this operation. A single time lag have to be selected.";
            checkReport.addReportEntry("Delete Time Lag", CheckReport.ResultType.FAILURE, message, new URI[0]);
        }
        return false;
    }

    @Override
    public String getChangeOperationDescription() {
        return "Remove the selected time lag.";
    }

    @Override
    public void runChangeOp(SessionToken session) {
        int startNodeId = -1;
        int endNodeId = -1;
        UpdateManager updateManager = this.getUpdateManager();
        if (this.getStartNode() != null && this.getEndNode() != null && this.getEdge() == null) {
            if (this.getModel() instanceof ChangeableInstance) {
                DeleteConstraintEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)updateManager);
            } else {
                DeleteConstraintEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)updateManager);
            }
        }
        if (this.getEdge() instanceof ConstraintEdge) {
            if (this.getModel() instanceof ChangeableInstance) {
                ChangeableInstance instance = (ChangeableInstance)this.getModel();
                Template template = instance.getTemplate();
                StructuredConstraintEdge edge = this.getStructuredConstraintEdge(template);
                startNodeId = edge.getSourceNodeID();
                endNodeId = edge.getDestinationNodeID();
                if (startNodeId >= 0 && endNodeId >= 0) {
                    DeleteConstraintEdge.performOperation((SessionToken)session, (ChangeableInstance)instance, (Node)template.getNode(startNodeId), (Node)template.getNode(endNodeId), (UpdateManager)updateManager);
                }
            } else {
                ChangeableTemplate template = (ChangeableTemplate)this.getModel();
                StructuredConstraintEdge edge = this.getStructuredConstraintEdge((Template)template);
                startNodeId = edge.getSourceNodeID();
                endNodeId = edge.getDestinationNodeID();
                if (startNodeId >= 0 && endNodeId >= 0) {
                    DeleteConstraintEdge.performOperation((SessionToken)session, (ChangeableTemplate)template, (Node)template.getNode(startNodeId), (Node)template.getNode(endNodeId), (UpdateManager)updateManager);
                }
            }
        }
    }

    private StructuredConstraintEdge getStructuredConstraintEdge(Template template) {
        for (StructuredConstraintEdge edge : template.getConstraintEdgeStructure()) {
            if (edge.getConstraintEdge() != this.getEdge()) continue;
            return edge;
        }
        return null;
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        this.clearFocus();
        this.refreshFocus();
    }
}

