/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import org.eclipse.gef.GraphicalViewer;

public class DeleteNodeAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/DeleteNode";

    @Override
    protected void showChanges(GraphicalViewer viewer, UISettings uiSettings) {
    }

    public DeleteNodeAction() {
        super("ChangeOp_deleteNode_active.gif", "ChangeOp_deleteNode_passive.gif");
        this.setText("Delete Node");
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null) {
            if (this.getStartNode() != null && this.getEndNode() == null && this.getEdge() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return DeleteNode.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (CheckReport)checkReport);
                }
                return DeleteNode.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (CheckReport)checkReport);
            }
            if (this.getStartNode() == null && this.getEndNode() != null && this.getEdge() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return DeleteNode.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getEndNode(), (CheckReport)checkReport);
                }
                return DeleteNode.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            String message = "Not enough/no correct elements selected for this operation. A single node must be selected.";
            checkReport.addReportEntry("Delete Node", CheckReport.ResultType.FAILURE, message, new URI[0]);
        } else {
            String message = "Model does not exists";
            checkReport.addReportEntry("Delete Node", CheckReport.ResultType.FAILURE, message, new URI[0]);
        }
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            Node startNode = this.getStartNode();
            Node endNode = this.getEndNode();
            if (startNode != null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    if (((ChangeableInstance)this.getModel()).getTemplate().getNode(startNode.getID()) == null) {
                        return;
                    }
                    DeleteNode.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)startNode, (UpdateManager)this.getUpdateManager());
                } else {
                    if (((ChangeableTemplate)this.getModel()).getNode(startNode.getID()) == null) {
                        return;
                    }
                    DeleteNode.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)startNode, (UpdateManager)this.getUpdateManager());
                }
            } else if (this.getModel() instanceof ChangeableInstance) {
                if (((ChangeableInstance)this.getModel()).getTemplate().getNode(endNode.getID()) == null) {
                    return;
                }
                DeleteNode.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)endNode, (UpdateManager)this.getUpdateManager());
            } else {
                if (((ChangeableTemplate)this.getModel()).getNode(endNode.getID()) == null) {
                    return;
                }
                DeleteNode.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)endNode, (UpdateManager)this.getUpdateManager());
            }
        }
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        this.clearSelection();
        this.clearFocus();
    }

    @Override
    public String getChangeOperationDescription() {
        return "";
    }
}

