/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.InsertEmptyBlock;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public abstract class InsertBlockAction
extends ChangeOperationAction {
    public InsertBlockAction(String enabledImage, String disableImage) {
        super(enabledImage, disableImage);
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null) {
            if (this.getStartNode() != null && this.getEndNode() != null && this.getEdge() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return InsertEmptyBlock.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
                }
                return InsertEmptyBlock.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            String message = "Not enough/no correct elements selected for this operation. Two direct following nodes have to be selected.";
            checkReport.addReportEntry("Insert Block.", CheckReport.ResultType.FAILURE, message, new URI[0]);
        } else {
            String message = "Model does not exists";
            checkReport.addReportEntry("Insert Block. Type: " + this.getBlockType().toString(), CheckReport.ResultType.FAILURE, message, new URI[0]);
        }
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            if (this.getBlockType() != null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    InsertEmptyBlock.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (ProcessConstants.BlockType)this.getBlockType(), (UpdateManager)this.getUpdateManager());
                } else {
                    InsertEmptyBlock.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (ProcessConstants.BlockType)this.getBlockType(), (UpdateManager)this.getUpdateManager());
                }
            } else {
                this.logger.severe("Tried to perform InsertBlock operation but no BlockType specified");
            }
        }
    }

    protected abstract ProcessConstants.BlockType getBlockType();

    @Override
    public String getChangeOperationDescription() {
        return "";
    }
}

