/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.PlatformUI;

public abstract class InsertDataAccessAction
extends ChangeOperationAction {
    public InsertDataAccessAction(String activeImage, String passiveImage) {
        super(activeImage, passiveImage);
    }

    abstract ActivityConstants.AccessType getAccessType();

    abstract DataElement getDataElement();

    abstract Node getNode();

    abstract Node getOtherNode();

    @Override
    protected void update(CheckReport checkReport) {
        boolean enable = true;
        if (this.getPrimPreSelList().size() > 1 && this.getPrimPostSelList().size() > 1) {
            String message = "No valid elements selected for this operation. Only one of primary pre and primary post selection may have more than a single element.";
            checkReport.addReportEntry("ChangeOperationAction", CheckReport.ResultType.FAILURE, message, new URI[0]);
            enable = false;
        } else if (this.getPrimPreSelList().size() > 1) {
            this.setEndElement(this.getPrimPostSelList().size() == 0 ? null : this.getPrimPostSelList().get(0).getModel());
            enable = this.checkElementTypeEquality(checkReport, this.getPrimPreSelList());
            if (enable) {
                if (this.getEndNode() != null && this.getPrimPreSelList().get(0).getModel() instanceof DataElement) {
                    DataElement[] dataElements = new DataElement[this.getPrimPreSelList().size()];
                    int i = 0;
                    for (IProcessEditPart preEditPart : this.getPrimPreSelList()) {
                        dataElements[i] = (DataElement)preEditPart.getModel();
                        ++i;
                    }
                    enable = this.getModel() instanceof ChangeableInstance ? InsertDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getNode(), (DataElement[])dataElements, (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport) : InsertDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getNode(), (DataElement[])dataElements, (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport);
                } else {
                    for (IProcessEditPart preEditPart : this.getPrimPreSelList()) {
                        this.setStartElement(preEditPart.getModel());
                        enable = this.isPossible(checkReport);
                        if (enable) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (this.getPrimPostSelList().size() > 1) {
            this.setStartElement(this.getPrimPreSelList().size() == 0 ? null : this.getPrimPreSelList().get(0).getModel());
            enable = this.checkElementTypeEquality(checkReport, this.getPrimPostSelList());
            if (enable) {
                if (this.getStartNode() != null && this.getPrimPostSelList().get(0).getModel() instanceof DataElement) {
                    DataElement[] dataElements = new DataElement[this.getPrimPostSelList().size()];
                    int i = 0;
                    for (IProcessEditPart preEditPart : this.getPrimPostSelList()) {
                        dataElements[i] = (DataElement)preEditPart.getModel();
                        ++i;
                    }
                    enable = this.getModel() instanceof ChangeableInstance ? InsertDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getNode(), (DataElement[])dataElements, (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport) : InsertDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getNode(), (DataElement[])dataElements, (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport);
                } else {
                    for (IProcessEditPart preEditPart : this.getPrimPostSelList()) {
                        this.setEndElement(preEditPart.getModel());
                        enable = this.isPossible(checkReport);
                        if (enable) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else {
            this.setStartElement(this.getPrimPreSelList().size() == 0 ? null : this.getPrimPreSelList().get(0).getModel());
            this.setEndElement(this.getPrimPostSelList().size() == 0 ? null : this.getPrimPostSelList().get(0).getModel());
            enable = this.isPossible(checkReport);
        }
        this.setEnabled(enable);
        this.updateToolTips(checkReport);
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getOtherNode() == null && this.getEdge() == null) {
            if (this.getModel() instanceof ChangeableInstance) {
                return InsertDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getNode(), (DataElement)this.getDataElement(), (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport);
            }
            return InsertDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getNode(), (DataElement)this.getDataElement(), (ActivityConstants.AccessType)this.getAccessType(), (CheckReport)checkReport);
        }
        String message = null;
        message = this.getAccessType() == ActivityConstants.AccessType.WRITE || this.getAccessType() == ActivityConstants.AccessType.SYSTEM_WRITE ? "Not enough/no correct elements selected for this operation. A single data element as 'post' and a single node as 'pre' must be selected." : "Not enough/no correct elements selected for this operation. A single data element as 'pre' and a single node as 'post' must be selected.";
        checkReport.addReportEntry("Insert Data Edge. Type: " + this.getAccessType().toString(), CheckReport.ResultType.FAILURE, message, new URI[]{checkReport.getBase()});
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            if (this.getModel() instanceof ChangeableInstance) {
                InsertDataEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getNode(), (DataElement)this.getDataElement(), (ActivityConstants.AccessType)this.getAccessType(), (UpdateManager)this.getUpdateManager());
            } else {
                InsertDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getNode(), (DataElement)this.getDataElement(), (ActivityConstants.AccessType)this.getAccessType(), (UpdateManager)this.getUpdateManager());
            }
        }
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        this.refreshFocus();
    }

    @Override
    public void refreshFocus() {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager sm = editor.getSelectionManager();
        EditPart part = (EditPart)this.getViewer().getEditPartRegistry().get(this.getNode());
        if (part != null && !part.equals(sm.getActiveEditPart())) {
            sm.editPartClicked((IProcessEditPart)part, false);
        }
    }

    @Override
    protected void showChanges(GraphicalViewer viewer, UISettings uiSettings) {
        EditPart dataElement;
        EditPart node = (EditPart)viewer.getEditPartRegistry().get(this.getNode());
        if (node != null) {
            viewer.reveal(node);
        }
        if ((dataElement = (EditPart)viewer.getEditPartRegistry().get(this.getDataElement())) != null && uiSettings.isDataElementsVisible()) {
            viewer.reveal(dataElement);
        }
    }

    @Override
    public String getChangeOperationDescription() {
        return "InsertDataAccessAction";
    }

    public static class ReadDataElementAction
    extends InsertDataAccessAction {
        public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/ReadDataElement";

        public ReadDataElementAction() {
            super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
            this.setText("Read Data Element");
        }

        @Override
        ActivityConstants.AccessType getAccessType() {
            return ActivityConstants.AccessType.READ;
        }

        @Override
        DataElement getDataElement() {
            return this.getStartDataElement();
        }

        @Override
        Node getNode() {
            return this.getEndNode();
        }

        @Override
        Node getOtherNode() {
            return this.getStartNode();
        }
    }

    public static class SystemReadDataElementAction
    extends InsertDataAccessAction {
        public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/SystemReadDataElement";

        public SystemReadDataElementAction() {
            super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
            this.setText("System Read Data Element");
        }

        @Override
        ActivityConstants.AccessType getAccessType() {
            return ActivityConstants.AccessType.SYSTEM_READ;
        }

        @Override
        DataElement getDataElement() {
            return this.getStartDataElement();
        }

        @Override
        Node getNode() {
            return this.getEndNode();
        }

        @Override
        Node getOtherNode() {
            return this.getStartNode();
        }
    }

    public static class SystemWriteDataElementAction
    extends InsertDataAccessAction {
        public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/SystemWriteDataElement";

        public SystemWriteDataElementAction() {
            super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
            this.setText("System Write Data Element");
        }

        @Override
        ActivityConstants.AccessType getAccessType() {
            return ActivityConstants.AccessType.SYSTEM_WRITE;
        }

        @Override
        DataElement getDataElement() {
            return this.getEndDataElement();
        }

        @Override
        Node getNode() {
            return this.getStartNode();
        }

        @Override
        Node getOtherNode() {
            return this.getEndNode();
        }
    }

    public static class WriteDataElementAction
    extends InsertDataAccessAction {
        public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/WriteDataElement";

        public WriteDataElementAction() {
            super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
            this.setText("Write Data Element");
        }

        @Override
        ActivityConstants.AccessType getAccessType() {
            return ActivityConstants.AccessType.WRITE;
        }

        @Override
        DataElement getDataElement() {
            return this.getEndDataElement();
        }

        @Override
        Node getNode() {
            return this.getStartNode();
        }

        @Override
        Node getOtherNode() {
            return this.getEndNode();
        }
    }
}

