/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.InsertNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public class InsertNodeAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/InsertNode";

    public String getDescription() {
        return "Select a start and an end node which are direct successor, or select a single edge.";
    }

    public InsertNodeAction() {
        super("ChangeOp_insertNode_active.gif", "ChangeOp_insertNode_passive.gif");
        this.setText("Insert Node");
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + this.getModel() + "," + this.getStartNode() + "," + this.getEndNode();
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null) {
            if (this.getStartNode() != null && this.getEndNode() != null && this.getEdge() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    return InsertNode.isPossible((Instance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
                }
                return InsertNode.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            String message = "Not enough/no correct elements selected for this operation. A single node as start element and a single node as end element have to be selected.";
            checkReport.addReportEntry("Insert Node", CheckReport.ResultType.FAILURE, message, new URI[0]);
        } else {
            String message = "Model does not exist.";
            checkReport.addReportEntry("Insert Node", CheckReport.ResultType.FAILURE, message, new URI[0]);
        }
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.getStartNode() != null && this.getEndNode() != null && this.getEdge() == null) {
            if (this.getModel() instanceof ChangeableInstance) {
                InsertNode.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)this.getUpdateManager());
            } else {
                InsertNode.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)this.getUpdateManager());
            }
        } else if (this.getStartNode() == null && this.getEndNode() == null) {
            this.getEdge();
        }
    }

    @Override
    public String getChangeOperationDescription() {
        return "";
    }
}

