/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.MoveNodes;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MoveNodesAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/MoveNodes";
    Node firstNode = null;
    Node lastNode = null;
    ToolItem selectItem;
    protected ToolItem selectHintItem;
    CheckReport checkReport;

    public MoveNodesAction() {
        super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
        this.setText("Move Nodes");
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getModel() != null && this.getFirstNode() != null && this.getLastNode() != null && this.getStartNode() != null && this.getEndNode() != null && this.getStartDataElement() == null && this.getEndDataElement() == null && this.getEdge() == null) {
            this.checkReport = checkReport;
            if (this.getModel() instanceof ChangeableInstance) {
                return MoveNodes.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getFirstNode(), (Node)this.getLastNode(), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
            }
            return MoveNodes.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getFirstNode(), (Node)this.getLastNode(), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport);
        }
        String message = "Not enough/no correct elements selected for this operation. The method 'Select nodes to move' must be called first and a single node as start element and a single node as end element are needed.";
        checkReport.addReportEntry("Move Nodes", CheckReport.ResultType.FAILURE, message, new URI[0]);
        this.checkReport = checkReport;
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.getModel() instanceof ChangeableInstance) {
            MoveNodes.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getFirstNode(), (Node)this.getLastNode(), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)this.getUpdateManager());
        } else {
            MoveNodes.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getFirstNode(), (Node)this.getLastNode(), (Node)this.getStartNode(), (Node)this.getEndNode(), (UpdateManager)this.getUpdateManager());
        }
        this.firstNode = null;
        this.lastNode = null;
        this.update(this.checkReport);
    }

    @Override
    public void createToolItem(ToolBar toolBar) {
        this.selectItem = new ToolItem(toolBar, 8);
        this.selectItem.setText("Select Nodes to move");
        this.selectItem.setEnabled(this.isEnabled());
        this.selectItem.setImage(this.getSharedImage(this.enabledImage));
        this.selectItem.setDisabledImage(this.getSharedImage(this.disabledImage));
        this.selectItem.setToolTipText(this.getToolTipText());
        this.selectItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MoveNodesAction.this.firstNode = MoveNodesAction.this.getStartNode();
                MoveNodesAction.this.lastNode = MoveNodesAction.this.getEndNode() != null ? MoveNodesAction.this.getEndNode() : MoveNodesAction.this.getStartNode();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.item = new ToolItem(toolBar, 8);
        this.item.setText(this.getText());
        this.item.setEnabled(this.isEnabled());
        this.item.setImage(this.getSharedImage(this.enabledImage));
        this.item.setDisabledImage(this.getSharedImage(this.disabledImage));
        this.item.setToolTipText(this.getToolTipText());
        this.item.addSelectionListener(this.pushDownListener);
        this.addPropertyChangeListener(new ChangeOperationAction.PropertyChangeListener(this.item));
    }

    @Override
    public void createHintToolItem(ToolBar hintToolBar) {
        this.createSelectHintToolItem(hintToolBar);
        super.createHintToolItem(hintToolBar);
    }

    public void createSelectHintToolItem(ToolBar hintToolBar) {
        this.selectHintItem = new ToolItem(hintToolBar, 8);
        if (this.isEnabled()) {
            this.selectHintItem.setImage(this.getSharedImage("info"));
            this.selectHintItem.setToolTipText(this.getValidMoveBlockDescription());
        } else {
            this.selectHintItem.setImage(this.getSharedImage("warning"));
            this.selectHintItem.setToolTipText(this.selectItem.getToolTipText());
        }
        this.selectHintItem.addSelectionListener(this.hintPushDownListener);
    }

    @Override
    protected void update(CheckReport checkReport) {
        this.setStartElement(this.getPrimPreSelList().size() == 0 ? null : this.getPrimPreSelList().get(0).getModel());
        this.setEndElement(this.getPrimPostSelList().size() == 0 ? null : this.getPrimPostSelList().get(0).getModel());
        if (this.getPrimPreSelList().size() <= 1 && this.getPrimPostSelList().size() <= 1 & this.getModel() != null && this.getStartNode() != null && this.getStartDataElement() == null && this.getEndDataElement() == null && this.getEdge() == null) {
            if (this.getEndNode() == null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    this.selectItem.setEnabled(MoveNodes.isValidMoveBlock((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getStartNode(), (CheckReport)checkReport));
                } else {
                    this.selectItem.setEnabled(MoveNodes.isValidMoveBlock((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getStartNode(), (CheckReport)checkReport));
                }
            } else if (this.getModel() instanceof ChangeableInstance) {
                this.selectItem.setEnabled(MoveNodes.isValidMoveBlock((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport));
            } else {
                this.selectItem.setEnabled(MoveNodes.isValidMoveBlock((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (Node)this.getEndNode(), (CheckReport)checkReport));
            }
        } else {
            String message = "Not enough/no correct elements selected for this operation. A single node as start element and a single node as end element is needed.";
            checkReport.addReportEntry("Move Nodes", CheckReport.ResultType.FAILURE, message, new URI[0]);
            this.selectItem.setEnabled(false);
        }
        this.updateSelectToolTips(checkReport);
        super.update(checkReport);
    }

    protected Node getFirstNode() {
        return this.firstNode;
    }

    protected Node getLastNode() {
        return this.lastNode;
    }

    @Override
    protected void clear(boolean modelChanged) {
        if (modelChanged) {
            this.firstNode = null;
            this.lastNode = null;
        }
        super.clear(modelChanged);
    }

    @Override
    public String getChangeOperationDescription() {
        return "";
    }

    protected String getValidMoveBlockDescription() {
        return "";
    }

    protected void updateSelectToolTips(CheckReport checkReport) {
        if (this.selectItem != null) {
            if (!this.selectItem.isEnabled()) {
                CheckReport.ReportEntry entry;
                String text = "";
                if (checkReport != null && (entry = checkReport.getLastAddedReportEntry()) != null) {
                    text = entry.getMessage();
                }
                this.selectItem.setToolTipText(text);
            } else {
                this.selectItem.setToolTipText(null);
            }
        }
        if (this.selectHintItem != null) {
            if (this.selectItem.isEnabled()) {
                this.selectHintItem.setImage(this.getSharedImage("info"));
                this.selectHintItem.setToolTipText(this.getChangeOperationDescription());
            } else {
                this.selectHintItem.setImage(this.getSharedImage("warning"));
                this.selectHintItem.setToolTipText(this.selectItem.getToolTipText());
            }
        }
    }
}

