/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.PlatformUI;

public class RemoveDataAccessAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/RemoveDataAccess";

    public RemoveDataAccessAction() {
        super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
        this.setText("Remove Data Access");
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        if (this.getEndNode() == null && this.getEdge() == null && this.getStartNode() != null && this.getEndDataElement() != null) {
            if (this.getModel() instanceof ChangeableInstance) {
                return DeleteDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (DataElement)this.getEndDataElement(), (ActivityConstants.AccessType)this.getWriteAccess(), (CheckReport)checkReport);
            }
            return DeleteDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (DataElement)this.getEndDataElement(), (ActivityConstants.AccessType)this.getWriteAccess(), (CheckReport)checkReport);
        }
        String message = "Not enough/no correct elements selected for this operation. A single node and a single data element have to be selected.";
        checkReport.addReportEntry("Delete Data Edge. Type: " + this.getWriteAccess(), CheckReport.ResultType.FAILURE, message, new URI[0]);
        if (this.getEndNode() != null && this.getEdge() == null && this.getStartNode() == null && this.getStartDataElement() != null) {
            if (this.getModel() instanceof ChangeableInstance) {
                return DeleteDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getEndNode(), (DataElement)this.getStartDataElement(), (ActivityConstants.AccessType)this.getReadAccess(), (CheckReport)checkReport);
            }
            return DeleteDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (Node)this.getEndNode(), (DataElement)this.getStartDataElement(), (ActivityConstants.AccessType)this.getReadAccess(), (CheckReport)checkReport);
        }
        message = "Not enough/no correct elements selected for this operation. A single data element and a single node have to be selected.";
        checkReport.addReportEntry("Delete Data Edge. Type: " + this.getReadAccess(), CheckReport.ResultType.FAILURE, message, new URI[0]);
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            if (this.getEndNode() == null && this.getEdge() == null && this.getStartNode() != null && this.getEndDataElement() != null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    DeleteDataEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getStartNode(), (DataElement)this.getEndDataElement(), (ActivityConstants.AccessType)this.getWriteAccess(), (UpdateManager)this.getUpdateManager());
                } else {
                    DeleteDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getStartNode(), (DataElement)this.getEndDataElement(), (ActivityConstants.AccessType)this.getWriteAccess(), (UpdateManager)this.getUpdateManager());
                }
            }
            if (this.getEndNode() != null && this.getEdge() == null && this.getStartNode() == null && this.getStartDataElement() != null) {
                if (this.getModel() instanceof ChangeableInstance) {
                    DeleteDataEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (Node)this.getEndNode(), (DataElement)this.getStartDataElement(), (ActivityConstants.AccessType)this.getReadAccess(), (UpdateManager)this.getUpdateManager());
                } else {
                    DeleteDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (Node)this.getEndNode(), (DataElement)this.getStartDataElement(), (ActivityConstants.AccessType)this.getReadAccess(), (UpdateManager)this.getUpdateManager());
                }
            }
        }
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        this.refreshFocus();
    }

    @Override
    public void refreshFocus() {
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager sm = editor.getSelectionManager();
        Object part = null;
        if (this.getStartNode() != null) {
            part = (EditPart)this.getViewer().getEditPartRegistry().get(this.getStartNode());
        } else if (this.getEndNode() != null) {
            part = (EditPart)this.getViewer().getEditPartRegistry().get(this.getEndNode());
        }
        if (!part.equals(sm.getActiveEditPart())) {
            sm.editPartClicked((IProcessEditPart)part, false);
        }
    }

    @Override
    protected void showChanges(GraphicalViewer viewer, UISettings uiSettings) {
        EditPart editPart;
        if (this.getStartNode() != null && this.getEndDataElement() != null) {
            editPart = (EditPart)viewer.getEditPartRegistry().get(this.getStartNode());
            if (editPart != null) {
                viewer.reveal(editPart);
            }
            if (uiSettings.isDataElementsVisible() && (editPart = (EditPart)viewer.getEditPartRegistry().get(this.getEndDataElement())) != null) {
                viewer.reveal(editPart);
            }
        }
        if (this.getEndNode() != null && this.getStartDataElement() != null) {
            editPart = (EditPart)viewer.getEditPartRegistry().get(this.getEndNode());
            if (editPart != null) {
                viewer.reveal(editPart);
            }
            if (uiSettings.isDataElementsVisible() && (editPart = (EditPart)viewer.getEditPartRegistry().get(this.getStartDataElement())) != null) {
                viewer.reveal(editPart);
            }
        }
    }

    @Override
    public String getChangeOperationDescription() {
        String description = "";
        this.getStartNode();
        return description;
    }

    ActivityConstants.AccessType getReadAccess() {
        return ActivityConstants.AccessType.READ;
    }

    ActivityConstants.AccessType getWriteAccess() {
        return ActivityConstants.AccessType.WRITE;
    }

    public static class RemoveSystemDataAccessAction
    extends RemoveDataAccessAction {
        public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/RemoveSystemDataAccess";

        public RemoveSystemDataAccessAction() {
            this.setText("Remove System Data Access");
        }

        @Override
        ActivityConstants.AccessType getReadAccess() {
            return ActivityConstants.AccessType.SYSTEM_READ;
        }

        @Override
        ActivityConstants.AccessType getWriteAccess() {
            return ActivityConstants.AccessType.SYSTEM_WRITE;
        }
    }
}

