/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.actions.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public class ToggleDataEdgeOptionalAttributeAction
extends ChangeOperationAction {
    public static final String ID = String.valueOf(ChangeOperationsView.ID) + "/ToggleDataEdgeOptionalAttribute";

    @Override
    public String getChangeOperationDescription() {
        return "Select a node as start element and a data element as end element or vice versa.";
    }

    public ToggleDataEdgeOptionalAttributeAction() {
        super("ChangeOp_placeHolder_active.gif", "ChangeOp_placeHolder_passive.gif");
        this.setText("Toggle Data Edge Optional Attribute");
    }

    @Override
    protected void update(CheckReport checkReport) {
        if (this.checkElementTypeEquality(checkReport, this.getPrimPreSelList()) && this.checkElementTypeEquality(checkReport, this.getPrimPostSelList())) {
            super.update(checkReport);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected boolean isPossible(CheckReport checkReport) {
        ChangeableTemplate template;
        ActivityConstants.AccessType accessType = null;
        int nodeID = -1;
        int dataElementID = -1;
        Object object = template = this.getModel() instanceof ChangeableInstance ? ((ChangeableInstance)this.getModel()).getTemplate() : (ChangeableTemplate)this.getModel();
        if (this.getStartNode() != null && this.getEndDataElement() != null) {
            nodeID = this.getStartNode().getID();
            if (template.getDataEdge(nodeID, dataElementID = this.getEndDataElement().getID(), ActivityConstants.AccessType.SYSTEM_WRITE) != null) {
                String message = "An edge between the given node and the given data element is of type SYSTEM_WRITE. The optional attribute can't be changed.";
                checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, new URI[]{checkReport.getBase()});
                return false;
            }
            accessType = ActivityConstants.AccessType.WRITE;
        } else if (this.getStartDataElement() != null && this.getEndNode() != null) {
            nodeID = this.getEndNode().getID();
            if (template.getDataEdge(nodeID, dataElementID = this.getStartDataElement().getID(), ActivityConstants.AccessType.SYSTEM_READ) != null) {
                String message = "An edge between the given node and the given data element is of type SYSTEM_READ. The optional attribute can't be changed.";
                checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, new URI[]{checkReport.getBase()});
                return false;
            }
            accessType = ActivityConstants.AccessType.READ;
        } else if (this.getDataEdgeEditPart() != null && this.getEndDataElement() == null && this.getEndNode() == null) {
            DataEdgeEditPart dataEdgeEditPart = this.getDataEdgeEditPart();
            DataEdge dataEdge = (DataEdge)dataEdgeEditPart.getModel();
            accessType = dataEdge.getType();
            if (accessType == ActivityConstants.AccessType.READ || accessType == ActivityConstants.AccessType.SYSTEM_READ) {
                nodeID = dataEdgeEditPart.getDestNodeID();
                dataElementID = dataEdgeEditPart.getSourceNodeID();
            } else {
                nodeID = dataEdgeEditPart.getSourceNodeID();
                dataElementID = dataEdgeEditPart.getDestNodeID();
            }
        }
        if (accessType != null) {
            if (this.getModel() instanceof ChangeableInstance) {
                return UpdateDataEdge.isPossible((ChangeableInstance)((ChangeableInstance)this.getModel()), (int)nodeID, (int)dataElementID, (ActivityConstants.AccessType)accessType, (CheckReport)checkReport, (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
            }
            return UpdateDataEdge.isPossible((Template)((ChangeableTemplate)this.getModel()), (int)nodeID, (int)dataElementID, (ActivityConstants.AccessType)accessType, (CheckReport)checkReport, (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
        }
        String message = null;
        message = accessType == ActivityConstants.AccessType.WRITE ? "Not enough/no correct elements selected for this operation. A single data element as 'post' and a single node as 'pre' must be selected." : "Not enough/no correct elements selected for this operation. A single data element as 'pre' and a single node as 'post' must be selected.";
        checkReport.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, new URI[]{checkReport.getBase()});
        return false;
    }

    @Override
    public void runChangeOp(SessionToken session) {
        if (this.isEnabled()) {
            DataEdge dataEdge;
            ActivityConstants.AccessType accessType = null;
            int nodeID = -1;
            int dataElementID = -1;
            if (this.getDataEdgeEditPart() != null) {
                DataEdgeEditPart dataEdgeEditPart = this.getDataEdgeEditPart();
                dataEdge = (DataEdge)dataEdgeEditPart.getModel();
                accessType = dataEdge.getType();
                if (accessType == ActivityConstants.AccessType.READ || accessType == ActivityConstants.AccessType.SYSTEM_READ) {
                    nodeID = dataEdgeEditPart.getDestNodeID();
                    dataElementID = dataEdgeEditPart.getSourceNodeID();
                } else {
                    nodeID = dataEdgeEditPart.getSourceNodeID();
                    dataElementID = dataEdgeEditPart.getDestNodeID();
                }
            } else if (this.getStartNode() != null) {
                accessType = ActivityConstants.AccessType.WRITE;
                nodeID = this.getStartNode().getID();
                dataElementID = this.getEndDataElement().getID();
            } else {
                accessType = ActivityConstants.AccessType.READ;
                nodeID = this.getEndNode().getID();
                dataElementID = this.getStartDataElement().getID();
            }
            if (this.getModel() instanceof ChangeableInstance) {
                boolean optional = ((ChangeableInstance)this.getModel()).getTemplate().getDataEdge(nodeID, dataElementID, accessType).isOptional();
                dataEdge = Activator.getService().getProcessModelFactory().createDataEdge(accessType, !optional, null);
                UpdateDataEdge.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)this.getModel()), (int)nodeID, (int)dataElementID, (ActivityConstants.AccessType)accessType, (DataEdge)dataEdge, (UpdateManager)this.getUpdateManager(), (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
            } else {
                boolean optional = ((ChangeableTemplate)this.getModel()).getDataEdge(nodeID, dataElementID, accessType).isOptional();
                dataEdge = Activator.getService().getProcessModelFactory().createDataEdge(accessType, !optional, null);
                UpdateDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)this.getModel()), (int)nodeID, (int)dataElementID, (ActivityConstants.AccessType)accessType, (DataEdge)dataEdge, (UpdateManager)this.getUpdateManager(), (ProcessConstants.DataEdgeProperty[])new ProcessConstants.DataEdgeProperty[]{ProcessConstants.DataEdgeProperty.OPTIONAL});
            }
        }
    }
}

