/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.dnd;

import de.aristaflow.adept2.core.changeoperations.RemoveExecutableBusinessProcess;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractEBPTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    protected AbstractEBPTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected AbstractEBPTransferDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected void updateTargetRequest() {
    }

    protected Request createTargetRequest() {
        return super.createTargetRequest();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    protected void handleDragOver() {
        EditPart editpart = this.getViewer().findObjectAt(this.getDropLocation());
        this.getCurrentEvent().detail = this.isValidDragOverTarget(editpart) ? 1 : 0;
        super.handleDragOver();
    }

    protected boolean isValidDragOverTarget(EditPart editpart) {
        boolean valid = false;
        if (editpart instanceof DefaultNodeEditPart && !(editpart instanceof DataElementEditPart) || editpart instanceof BlockEditPart) {
            ProcessConstants.NodeState state;
            Node node = null;
            Template template = ((DefaultNodeEditPart)editpart).getTemplate();
            if (editpart.getModel() == null || !(editpart.getModel() instanceof Node)) {
                throw new RuntimeException("Programming error: DefaultNodeEditPart/BlockEditPart does not have a (correct) model");
            }
            node = (Node)editpart.getModel();
            Instance instance = ((DefaultNodeEditPart)editpart).getInstance();
            if (instance != null && (state = instance.getNodeState(node.getID())) != ProcessConstants.NodeState.NS_NOT_ACTIVATED && state != ProcessConstants.NodeState.NS_ACTIVATED) {
                return false;
            }
            if (!(template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_NORMAL) || template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP))) {
                return false;
            }
            valid = true;
        } else if (editpart instanceof EdgeEditPart && !(editpart instanceof DataEdgeEditPart)) {
            EdgeEditPart edgePart = (EdgeEditPart)editpart;
            Edge edge = (Edge)edgePart.getModel();
            if (edge.getType() == ProcessConstants.EdgeType.ET_LOOP || edge.getType() == ProcessConstants.EdgeType.ET_SYNC) {
                valid = false;
            } else {
                ProcessConstants.NodeState state;
                DefaultNodeEditPart nodePart = (DefaultNodeEditPart)edgePart.getTarget();
                Node destNode = (Node)nodePart.getModel();
                Instance instance = nodePart.getInstance();
                valid = instance != null ? (state = instance.getNodeState(destNode.getID())) == ProcessConstants.NodeState.NS_NOT_ACTIVATED || state == ProcessConstants.NodeState.NS_ACTIVATED : true;
            }
        }
        return valid;
    }

    protected boolean isValidDropTarget(EditPart editpart, ExecutableBusinessProcess ebp, TemplateStatus status) {
        boolean valid = false;
        if (editpart instanceof DefaultNodeEditPart && !(editpart instanceof DataElementEditPart) || editpart instanceof BlockEditPart) {
            Template template = ((DefaultNodeEditPart)editpart).getTemplate();
            Instance instance = ((DefaultNodeEditPart)editpart).getInstance();
            Node node = null;
            if (!(template instanceof ChangeableTemplate) && !(instance instanceof ChangeableInstance)) {
                return false;
            }
            if (editpart.getModel() == null || !(editpart.getModel() instanceof Node)) {
                throw new RuntimeException("Programming error: DefaultNodeEditPart/BlockEditPart does not have a (correct) model");
            }
            node = (Node)editpart.getModel();
            if (instance != null && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                return false;
            }
            valid = this.isNodeValidDropTarget(ebp, node, template, status);
            if (valid && node.getExecutableBusinessProcess() != null) {
                MessageBox mb = new MessageBox(new Shell(), 200);
                mb.setMessage("The node already has an activity/sub-process of type (\"" + node.getExecutableBusinessProcess().getType() + "\"). Do you want to replace it?");
                mb.setText("Confirm activity/sub-process replacement");
                if (mb.open() == 64) {
                    if (instance != null && instance instanceof ChangeableInstance && RemoveExecutableBusinessProcess.isPossible((ChangeableInstance)((ChangeableInstance)instance), (Node)node)) {
                        valid = true;
                    } else if (instance == null && template instanceof ChangeableTemplate && RemoveExecutableBusinessProcess.isPossible((Template)template, (Node)node)) {
                        valid = true;
                    } else {
                        mb = new MessageBox(new Shell(), 1);
                        mb.setMessage("Replacement of activity/EBP failed.");
                        mb.open();
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            }
        } else {
            if (editpart instanceof EdgeEditPart && !(editpart instanceof DataEdgeEditPart)) {
                Edge edge = (Edge)((EdgeEditPart)editpart).getModel();
                if (edge.getType() == ProcessConstants.EdgeType.ET_LOOP || edge.getType() == ProcessConstants.EdgeType.ET_SYNC) {
                    return false;
                }
                Instance instance = ((EdgeEditPart)editpart).getInstance();
                valid = true;
                int succ = ((EdgeEditPart)editpart).getDestNodeID();
                if (instance != null && instance.getNodeState(succ) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                    return false;
                }
            }
            if (ebp instanceof DecisionActivity) {
                MessageBox mb = new MessageBox(new Shell(), 1);
                mb.setText("It is not allowed to drop a decision activity here!");
                mb.setMessage("Dropping decision activities on edges is not allowed.");
                mb.open();
                valid = false;
            }
            if (ebp instanceof LightWeightProcess) {
                valid = this.isNodeValidDropTarget(ebp, null, null, status);
            }
        }
        return valid;
    }

    protected abstract boolean isNodeValidDropTarget(ExecutableBusinessProcess var1, Node var2, Template var3, TemplateStatus var4);
}

