/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.dnd;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ConvertActivityTemplateToActivity;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLImport;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.dnd.AbstractEBPTransferDropTargetListener;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PnPWizard;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.wizard.OverviewWizardDialogue;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.UUID;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ActivityTransferDropTargetListener
extends AbstractEBPTransferDropTargetListener {
    public ActivityTransferDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public ActivityTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TextTransfer.getInstance());
    }

    protected void handleDrop() {
        ActivityTemplate activityTemplate;
        EditPart editPart;
        SessionToken session;
        block5: {
            session = Activator.getAMService().getSessionToken();
            editPart = this.getViewer().findObjectAt(this.getDropLocation());
            activityTemplate = null;
            try {
                if (this.getCurrentEvent().data instanceof UUID) {
                    UUID atID = (UUID)this.getCurrentEvent().data;
                    activityTemplate = Activator.getAMService().getActivityRepository().getActivityTemplate(session, atID);
                    break block5;
                }
                if (this.getCurrentEvent().data instanceof String) {
                    ActivityModelXMLImport xmlImport = new ActivityModelXMLImport(Activator.getAMService().getActivityModelFactory());
                    activityTemplate = xmlImport.activityTemplateFromXMLString((String)this.getCurrentEvent().data);
                    break block5;
                }
                String msg = "Activity Template drag & drop could not be performed! The dropped data of type %s cannot be resolved to an Activity Template.";
                msg = String.format(msg, this.getCurrentEvent().data.getClass().getName());
                LoggerTools.getLogger((Object)((Object)this)).severe(msg);
                return;
            }
            catch (Exception ex) {
                String msg = "Drag & drop of the Activity Template could not be successfully completed!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                return;
            }
        }
        Activity ebp = ConvertActivityTemplateToActivity.performConversion((ProcessModelFactory)Activator.getAMService().getProcessModelFactory(), (SessionToken)session, (ActivityTemplate)activityTemplate, (String)"instanceName");
        if (!this.isValidDropTarget(editPart, (ExecutableBusinessProcess)ebp, null)) {
            return;
        }
        Node node = null;
        node = editPart instanceof DefaultNodeEditPart || editPart instanceof BlockEditPart ? (Node)editPart.getModel() : Activator.getAMService().getProcessModelFactory().createNode(Integer.MIN_VALUE, "", "", "", null, false, null, null, null, null, null, null);
        PnPWizard wizard = new PnPWizard(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)editPart), activityTemplate, node);
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        OverviewWizardDialogue dialog = new OverviewWizardDialogue(parentShell, (IWizard)wizard);
        dialog.create();
        dialog.open();
        super.handleDrop();
    }

    @Override
    protected boolean isNodeValidDropTarget(ExecutableBusinessProcess ebp, Node node, Template template, TemplateStatus status) {
        boolean valid = true;
        if (!template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_NORMAL)) {
            if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP)) {
                if (!(ebp instanceof DecisionActivity)) {
                    MessageBox mb = new MessageBox(new Shell(), 1);
                    mb.setText("This node requires a decision activity!");
                    mb.setMessage("On OR-SPLIT/LOOP-END nodes only decision activities are valid.");
                    mb.open();
                    valid = false;
                } else {
                    valid = true;
                }
            } else {
                MessageBox mb = new MessageBox(new Shell(), 1);
                mb.setText("It is not allowed to drop an activity here!");
                mb.setMessage("Dropping activities on structure-nodes (null-nodes) is not allowed.");
                mb.open();
                valid = false;
            }
        }
        return valid;
    }
}

