/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.dnd;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.dnd.AbstractEBPTransferDropTargetListener;
import de.aristaflow.adept2.ui.processediting.dnd.UUIDTransfer;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PnPWizard;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.wizard.OverviewWizardDialogue;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SubProcessTransferDropTargetListener
extends AbstractEBPTransferDropTargetListener {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));

    public SubProcessTransferDropTargetListener(EditPartViewer viewer, TransferType type) {
        super(viewer);
        ArgChecks.checkForNull((Object)((Object)type), (String)"type");
        switch (type) {
            case TEMPLATE_REFERENCE: {
                this.setTransfer((Transfer)UUIDTransfer.getInstance());
                break;
            }
            case TEMPLATE_RESOURCE: {
                this.setTransfer((Transfer)LocalSelectionTransfer.getInstance());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleDrop() {
        EditPart editPart = this.getViewer().findObjectAt(this.getDropLocation());
        SessionToken session = Activator.getService().getSessionToken();
        ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
        pmf.setCreateChangeable(true);
        this.getCurrentEvent().detail = 0;
        Template template = null;
        TemplateStatus status = null;
        if (this.getCurrentEvent().data instanceof UUID) {
            TemplateManager templateManager = Activator.getService().getProcessManager().getTemplateManager();
            template = templateManager.getTemplate(session, (UUID)this.getCurrentEvent().data);
            status = templateManager.getTemplateStatus(session, (UUID)this.getCurrentEvent().data);
            template = pmf.cloneTemplate(template);
        } else {
            if (!(this.getCurrentEvent().data instanceof IStructuredSelection)) throw new IllegalArgumentException("Transfer type is not supported");
            IStructuredSelection selection = (IStructuredSelection)this.getCurrentEvent().data;
            IFile file = (IFile)selection.getFirstElement();
            if (file.getFileExtension().equals("instance")) {
                MessageBox mb = new MessageBox(new Shell(), 1);
                mb.setMessage("Instances can't be used as sub-processes.");
                mb.open();
                this.getCurrentEvent().detail = 0;
                return;
            }
            if (file.getFileExtension().equals("template")) {
                try {
                    ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
                    InputStream inputStream = file.getContents();
                    template = xmlImport.getTemplateFromStream(inputStream);
                    inputStream = file.getContents();
                    status = xmlImport.getTemplateStatusFromStream(inputStream);
                }
                catch (VersionException ex) {
                    String msg = "The template has an outdated version.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    return;
                }
                catch (XMLFormatException ex) {
                    String msg = "The format of the xml file is not correct.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    return;
                }
                catch (IOException ex) {
                    String msg = "Error while trying to read the input stream.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    return;
                }
                catch (CoreException e1) {
                    String msg = "Error while trying to convert the selection into an input stream.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)e1);
                    return;
                }
            } else {
                String msg = "This file type cannot be dropped on a node!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, null);
                return;
            }
        }
        assert (template != null);
        ExecutionControlProperties executionControlProperties = new ExecutionControlProperties(true, false, false);
        boolean fork = false;
        ReferencedProcess ebp = pmf.createReferencedProcess(template.getID(), fork, null, null, executionControlProperties, template.getParameters(ActivityConstants.AccessType.READ), template.getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)template, template.getUserAttributes());
        if (!this.isValidDropTarget(editPart, (ExecutableBusinessProcess)ebp, status)) {
            this.getCurrentEvent().detail = 0;
            return;
        }
        Node node = null;
        node = editPart instanceof DefaultNodeEditPart || editPart instanceof BlockEditPart ? (Node)editPart.getModel() : pmf.createNode(Integer.MIN_VALUE, "", "", "", null, false, null, null, null, null, null, null);
        PnPWizard wizard = new PnPWizard(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)editPart), template, status, node);
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        OverviewWizardDialogue dialog = new OverviewWizardDialogue(parentShell, (IWizard)wizard);
        dialog.create();
        dialog.open();
        super.handleDrop();
    }

    @Override
    protected boolean isNodeValidDropTarget(ExecutableBusinessProcess ebp, Node node, Template template, TemplateStatus status) {
        MessageBox mb;
        boolean valid = true;
        if (template != null && node != null && !template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_NORMAL)) {
            mb = new MessageBox(new Shell(), 1);
            mb.setText("Dropping not allowed!");
            mb.setMessage("Dropping lightweight-processes on structure-nodes (null-nodes) is not allowed!");
            mb.open();
            valid = false;
        }
        if (status != null && status.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.NO_SUBPROCESS) && !status.isTopLevelUsable()) {
            mb = new MessageBox(new Shell(), 1);
            mb.setText("Dropping not allowed!");
            mb.setMessage("This template is not allowed to be used as sub process!\nThe sub process usage could be changed in the template status.");
            mb.open();
            valid = false;
        }
        return valid;
    }

    public static enum TransferType {
        TEMPLATE_REFERENCE,
        TEMPLATE_RESOURCE;

    }
}

