/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.dnd;

import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class UUIDTransfer
extends ByteArrayTransfer {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private static final String ACTIVITYTYPE = "Activity";
    private static final int ACTIVITYTYPEID = UUIDTransfer.registerType((String)"Activity");
    private static UUIDTransfer _instance = new UUIDTransfer();

    public static UUIDTransfer getInstance() {
        return _instance;
    }

    protected int[] getTypeIds() {
        return new int[]{ACTIVITYTYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{ACTIVITYTYPE};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof UUID) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        assert (object != null);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream writeOut = new ObjectOutputStream(out);
            writeOut.writeObject(object);
            writeOut.close();
            byte[] buffer = out.toByteArray();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "EBPTransfer:javaToNative", e);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            UUID myData = null;
            try {
                ObjectInputStream readIn;
                block6: {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    readIn = new ObjectInputStream(in);
                    try {
                        myData = (UUID)readIn.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)"UUID class not found!");
                    }
                }
                readIn.close();
            }
            catch (IOException ex) {
                this.logger.log(Level.SEVERE, "EBPTransfer:nativeToJava", ex);
                return null;
            }
            return myData;
        }
        return null;
    }
}

