/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AssignExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.RemoveExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;

public class EmbeddedTemplateInput
extends TemplateInput {
    private Template template;
    private Editor parentEditor;
    private int[] nodeIDPath;

    public EmbeddedTemplateInput(Editor parentEditor, int[] nodeIDPath) {
        ArgChecks.checkForNull((Object)((Object)parentEditor), (String)"parentEditor");
        ArgChecks.checkForNull((Object)nodeIDPath, (String)"nodeIDPath");
        this.parentEditor = parentEditor;
        this.nodeIDPath = nodeIDPath;
        Node node = parentEditor.getTemplate().getNode(this.getParentNodeID());
        if (node == null) {
            throw new IllegalArgumentException("node does not exist");
        }
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        if (ebp == null) {
            throw new IllegalArgumentException("node does not have an EBP");
        }
        if (ebp instanceof VariableParallelismEBP) {
            ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
        }
        if (!(ebp instanceof EmbeddedProcess)) {
            throw new IllegalArgumentException("EBP is not an embedded process");
        }
        Template embeddedTemplate = ((EmbeddedProcess)ebp).getTemplate();
        if (embeddedTemplate instanceof ChangeableTemplate) {
            ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
            pmf.setCreateChangeable(true);
            this.template = ProcessModelTools.cloneTemplate((Template)embeddedTemplate, (ProcessModelFactory)pmf);
        } else {
            this.template = embeddedTemplate;
        }
    }

    public Editor getParentEditor() {
        return this.parentEditor;
    }

    public int[] getNodeIDPath() {
        return (int[])this.nodeIDPath.clone();
    }

    private int getParentNodeID() {
        return this.nodeIDPath[this.nodeIDPath.length - 1];
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < this.nodeIDPath.length) {
            name.append(">");
            ++i;
        }
        name.append(" ").append(this.template.getName());
        return name.toString();
    }

    public String getToolTipText() {
        IEditorInput parentEditorInput = this.parentEditor.getEditorInput();
        if (parentEditorInput instanceof EmbeddedTemplateInput) {
            return String.valueOf(parentEditorInput.getToolTipText()) + " > " + this.template.getName();
        }
        return String.valueOf(parentEditorInput.getName()) + " > " + this.template.getName();
    }

    @Override
    public TemplateInput.Holder load() {
        return new TemplateInput.Holder(this.template, null);
    }

    @Override
    public boolean isSaveAllowed() {
        return this.template instanceof ChangeableTemplate;
    }

    @Override
    public TemplateInput.Holder doSave(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) {
        ChangeableTemplate parentTemplate = (ChangeableTemplate)this.parentEditor.getTemplate();
        Node parentNode = parentTemplate.getNode(this.getParentNodeID());
        ExecutableBusinessProcess oldEbp = parentNode.getExecutableBusinessProcess();
        VariableParallelismEBP oldVarPar = null;
        if (oldEbp instanceof VariableParallelismEBP) {
            oldVarPar = (VariableParallelismEBP)oldEbp;
            oldEbp = oldVarPar.getLightWeightProcess();
        }
        EmbeddedProcess oldEmbeddedProcess = (EmbeddedProcess)oldEbp;
        UpdateManager updateManager = Activator.getService().getUpdateManager();
        StartTransaction.performOperation((ChangeableTemplate)parentTemplate, (UpdateManager)updateManager);
        ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
        EmbeddedProcess ebp = pmf.createEmbeddedProcess(template, parentTemplate.getID(), oldEmbeddedProcess.getTemplateID(), oldEmbeddedProcess.getConfiguration(), oldEmbeddedProcess.getTestConfiguration(), oldEmbeddedProcess.getExecutionControlProperties(), (PluginDataContainer)oldEmbeddedProcess, oldEmbeddedProcess.getUserAttributes());
        SessionToken session = Activator.getService().getSessionToken();
        HashMap paramsWithoutExistingDataElements = new HashMap();
        HashMap paramsWithExistingDataElements = new HashMap();
        HashSet<ProcessModelParameter> indexedInputParameters = new HashSet<ProcessModelParameter>();
        HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
        HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            HashMap<ProcessModelParameter, ProcessConstants.DataMappingType> without = new HashMap<ProcessModelParameter, ProcessConstants.DataMappingType>();
            paramsWithoutExistingDataElements.put(accessType, without);
            HashMap<ProcessModelParameter, Integer> with = new HashMap<ProcessModelParameter, Integer>();
            paramsWithExistingDataElements.put(accessType, with);
            for (ProcessModelParameter param : template.getParameters(accessType)) {
                ProcessModelParameter oldParam = oldEmbeddedProcess.getParameter(param.getName(), accessType);
                if (oldParam != null && param.getDataType() == oldParam.getDataType() && (param.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || param.getUDTName().equals(oldParam.getUDTName())) && param.getIdentifierID().equals(oldParam.getIdentifierID())) {
                    int connectorID = parentNode.getConnector(param.getName(), accessType);
                    DataElement dataElement = parentTemplate.getDataElement(this.getParentNodeID(), connectorID);
                    if (dataElement != null) {
                        if (oldVarPar != null) {
                            ProcessModelParameter varParameter = oldVarPar.getParameter(param.getName(), accessType);
                            boolean isIndexed = false;
                            isIndexed = oldVarPar.getIndexedInputParameters().contains(varParameter);
                            if (varParameter.isOptional() != param.isOptional() || varParameter.isVirtual() != param.isVirtual() || varParameter.isFailure() != param.isFailure()) {
                                varParameter = pmf.createProcessModelParameter(param.getName(), param.getDescription(), accessType == ActivityConstants.AccessType.WRITE || isIndexed ? varParameter.getDataType() : param.getDataType(), accessType == ActivityConstants.AccessType.WRITE || isIndexed ? varParameter.getUDTName() : param.getUDTName(), param.getIdentifierID(), isIndexed ? false : param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                            }
                            if (accessType == ActivityConstants.AccessType.READ) {
                                inputParameters.add(varParameter);
                            } else {
                                outputParameters.add(varParameter);
                            }
                            if (isIndexed) {
                                indexedInputParameters.add(varParameter);
                            }
                            with.put(varParameter, dataElement.getID());
                            continue;
                        }
                        with.put(param, dataElement.getID());
                        continue;
                    }
                    ProcessConstants.DataMappingType type = Arrays.asList(new int[][]{parentTemplate.getDisabledConnectors(this.getParentNodeID(), accessType)}).contains(connectorID) ? ProcessConstants.DataMappingType.DISABLE : ProcessConstants.DataMappingType.CONNECT_LATER;
                    if (oldVarPar != null) {
                        ProcessModelParameter varParameter = oldVarPar.getParameter(param.getName(), accessType);
                        if (varParameter.isOptional() != param.isOptional() || varParameter.isVirtual() != param.isVirtual() || varParameter.isFailure() != param.isFailure()) {
                            varParameter = pmf.createProcessModelParameter(param.getName(), param.getDescription(), accessType == ActivityConstants.AccessType.READ ? param.getDataType() : ProcessConstants.AdeptDataType.USERDEFINED, accessType == ActivityConstants.AccessType.READ ? param.getUDTName() : varParameter.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                        }
                        if (accessType == ActivityConstants.AccessType.READ) {
                            inputParameters.add(varParameter);
                        } else {
                            outputParameters.add(varParameter);
                        }
                        without.put(varParameter, type);
                        continue;
                    }
                    without.put(param, type);
                    continue;
                }
                if (oldVarPar != null) {
                    ProcessModelParameter varParameter = oldVarPar.getParameter(param.getName(), accessType);
                    if (varParameter == null) {
                        varParameter = pmf.cloneProcessModelParameter(param);
                    } else if (varParameter.isOptional() != param.isOptional() || varParameter.isVirtual() != param.isVirtual() || varParameter.isFailure() != param.isFailure()) {
                        varParameter = pmf.createProcessModelParameter(param.getName(), param.getDescription(), accessType == ActivityConstants.AccessType.READ ? param.getDataType() : ProcessConstants.AdeptDataType.USERDEFINED, accessType == ActivityConstants.AccessType.READ ? param.getUDTName() : varParameter.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                    }
                    if (accessType == ActivityConstants.AccessType.READ) {
                        inputParameters.add(varParameter);
                    } else {
                        String udtName = param.getUDTName() == null ? "" : "," + param.getUDTName();
                        varParameter = pmf.createProcessModelParameter(param.getName(), param.getDescription(), ProcessConstants.AdeptDataType.USERDEFINED, "java.util.List<" + param.getDataType().name() + udtName + ">", param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                        outputParameters.add(varParameter);
                    }
                    without.put(varParameter, ProcessConstants.DataMappingType.CONNECT_LATER);
                    continue;
                }
                without.put(param, ProcessConstants.DataMappingType.CONNECT_LATER);
            }
            ++n2;
        }
        RemoveExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableTemplate)parentTemplate, (Node)parentNode, (UpdateManager)updateManager);
        if (oldVarPar != null) {
            ebp = pmf.createVariableParallelismEBP((LightWeightProcess)ebp, indexedInputParameters, oldVarPar.getConfiguration(), oldVarPar.getTestConfiguration(), oldVarPar.getExecutionControlProperties(), inputParameters, outputParameters, (PluginDataContainer)oldVarPar, oldVarPar.getUserAttributes());
        }
        AssignExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableTemplate)parentTemplate, (Node)parentNode, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, (UpdateManager)updateManager);
        String transactionLabel = String.format("Changing embedded process at node %s.", parentNode.getName());
        EndTransaction.performOperation((ChangeableTemplate)parentTemplate, (UpdateManager)updateManager, (String)transactionLabel);
        this.template = template;
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EmbeddedTemplateInput)) {
            return false;
        }
        EmbeddedTemplateInput otherInput = (EmbeddedTemplateInput)obj;
        return this.parentEditor.getTemplate().getID().equals(otherInput.parentEditor.getTemplate().getID()) && Arrays.equals(this.nodeIDPath, otherInput.nodeIDPath) && this.template.getID().equals(otherInput.template.getID());
    }

    public int hashCode() {
        return this.parentEditor.getTemplate().getID().hashCode() ^ Arrays.hashCode(this.nodeIDPath) ^ this.template.getID().hashCode();
    }
}

