/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileInstanceInputFactory;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceInput;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class FileInstanceInput
extends InstanceInput
implements IPersistableElement {
    private File file;

    public FileInstanceInput(File file) {
        ArgChecks.checkForNull((Object)file, (String)"file");
        this.file = file;
    }

    File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getToolTipText() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InstanceInput.Holder load() throws Exception {
        return FileInstanceInput.loadFileAsInstance(this.file);
    }

    @Override
    public boolean isSaveAllowed() {
        return true;
    }

    @Override
    public InstanceInput.Holder doSave(Instance instance, IProgressMonitor monitor) throws Exception {
        FileInstanceInput.saveInstanceToFile(this.file, instance, monitor);
        return null;
    }

    @Override
    public IPersistableElement getPersistable() {
        return this;
    }

    public String getFactoryId() {
        return FileInstanceInputFactory.ID;
    }

    public void saveState(IMemento memento) {
        FileInstanceInputFactory.saveState(memento, this);
    }

    private static InstanceInput.Holder loadFileAsInstance(File file) throws Exception {
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        factory.setCreateChangeable(true);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        Instance instance = xmlImport.getInstanceFromFile(file);
        return new InstanceInput.Holder(instance);
    }

    public static void saveInstanceToFile(File file, Instance instance, IProgressMonitor monitor) throws Exception {
        ProcessModelXMLExport export = new ProcessModelXMLExport();
        export.writeInstanceToFile(instance, file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInstanceInput)) {
            return false;
        }
        FileInstanceInput otherInput = (FileInstanceInput)obj;
        return this.file.equals(otherInput.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

