/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileTemplateInputFactory;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FileTemplateInput
extends TemplateInput
implements IPersistableElement {
    protected static final Logger logger = LoggerTools.getLogger(FileTemplateInput.class);
    private static String initialPath;
    private static final String[] extensions;
    private File file;

    static {
        extensions = new String[]{"*.template", "*.*"};
    }

    public FileTemplateInput(File file) {
        ArgChecks.checkForNull((Object)file, (String)"file");
        this.file = file;
    }

    File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getToolTipText() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public TemplateInput.Holder load() throws Exception {
        return FileTemplateInput.loadFileAsTemplate(this.file);
    }

    @Override
    public boolean isSaveAllowed() {
        return true;
    }

    @Override
    public TemplateInput.Holder doSave(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        ArgChecks.checkForNull((Object)template, (String)"template");
        if (!(template instanceof ChangeableTemplate)) {
            String message = String.format("Saving a template which is not changeable. Updating the ID is not possible.", new Object[0]);
            logger.severe(message);
            throw new RuntimeException(message);
        }
        ((ChangeableTemplate)template).updateID(UUIDTools.createPositiveUUID());
        FileTemplateInput.saveTemplateToFile(this.file, template, templateStatus, monitor);
        return null;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public FileTemplateInput doSaveAs(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        if (initialPath == null) {
            initialPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        return FileTemplateInput.saveTemplateToNewFile(template, monitor);
    }

    @Override
    public IPersistableElement getPersistable() {
        return this;
    }

    public String getFactoryId() {
        return FileTemplateInputFactory.ID;
    }

    public void saveState(IMemento memento) {
        FileTemplateInputFactory.saveState(memento, this);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFile.class) && this.file != null) {
            IPath path = Path.fromOSString((String)this.file.getAbsolutePath());
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        }
        return null;
    }

    private static TemplateInput.Holder loadFileAsTemplate(File file) throws Exception {
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        factory.setCreateChangeable(true);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        Template template = xmlImport.getTemplateFromFile(file);
        TemplateStatus templateStatus = xmlImport.getTemplateStatusFromTemplateFile(file);
        return new TemplateInput.Holder(template, templateStatus);
    }

    private static void saveTemplateToFile(File file, Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        if (template instanceof ChangeableTemplate) {
            ((ChangeableTemplate)template).updateID(UUIDTools.createPositiveUUID());
        } else {
            String message = String.format("Saving a template which is not changeable. Not updating the ID.", new Object[0]);
            logger.info(message);
        }
        ProcessModelXMLExport export = new ProcessModelXMLExport();
        if (templateStatus == null) {
            export.writeTemplateToFile(template, file);
        } else {
            export.writeTemplateAndStatusToFile(template, templateStatus, file);
        }
    }

    public static FileTemplateInput saveTemplateToNewFile(Template template, IProgressMonitor monitor) throws Exception {
        MessageDialog confirm;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 8192);
        dialog.setText("Save As");
        if (initialPath != null) {
            dialog.setFilterPath(initialPath);
        }
        dialog.setFilterExtensions(extensions);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (file.exists() && (confirm = new MessageDialog(null, "Confirm file overwrite", null, "The file " + file + " already exists. Overwrite the file?", 3, new String[]{"Overwrite", "Cancel"}, 0)).open() != 0) {
            return null;
        }
        FileTemplateInput.saveTemplateToFile(file, template, null, monitor);
        return new FileTemplateInput(file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileTemplateInput)) {
            return false;
        }
        FileTemplateInput otherInput = (FileTemplateInput)obj;
        return this.file.equals(otherInput.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

