/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceInput;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;

public class IFileInstanceInput
extends InstanceInput {
    protected IFileEditorInput fileEditorInput;

    public IFileInstanceInput(IFile file) {
        ArgChecks.checkForNull((Object)file, (String)"file");
        this.fileEditorInput = new FileEditorInput(file);
    }

    public IFileInstanceInput(IFileEditorInput fileEditorInput) {
        ArgChecks.checkForNull((Object)fileEditorInput, (String)"fileEditorInput");
        this.fileEditorInput = fileEditorInput;
    }

    public String getName() {
        return this.fileEditorInput.getName();
    }

    public String getToolTipText() {
        return this.fileEditorInput.getToolTipText();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.fileEditorInput.getImageDescriptor();
    }

    @Override
    public boolean exists() {
        return this.fileEditorInput.exists();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.fileEditorInput.getAdapter(adapter);
    }

    @Override
    public IPersistableElement getPersistable() {
        return this.fileEditorInput.getPersistable();
    }

    @Override
    public InstanceInput.Holder load() throws Exception {
        return this.parseIFileAsInstance(this.fileEditorInput.getFile());
    }

    private InstanceInput.Holder parseIFileAsInstance(IFile file) throws CoreException, VersionException, XMLFormatException, IOException {
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        factory.setCreateChangeable(true);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        if (!file.isSynchronized(0)) {
            try {
                file.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        Instance instance = xmlImport.getInstanceFromStream(file.getContents(true));
        return new InstanceInput.Holder(instance);
    }

    static void saveInstanceToIFile(final IFile file, final Instance instance, IProgressMonitor monitor) throws Exception {
        ArgChecks.checkForNull((Object)instance, (String)"instance");
        file.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ProcessModelXMLExport export = new ProcessModelXMLExport();
                    InputStream input = export.getInputStreamForInstance(instance);
                    if (file.exists()) {
                        file.setContents(input, true, true, monitor);
                    } else {
                        file.create(input, true, monitor);
                    }
                    input.close();
                }
                catch (IOException e) {
                    Status status = new Status(4, Editor.ID, 0, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                catch (XMLFormatException e) {
                    Status status = new Status(4, Editor.ID, 0, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }, monitor);
    }

    public IFile getFile() {
        return this.fileEditorInput.getFile();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IFileInstanceInput) {
            IFileInstanceInput otherInput = (IFileInstanceInput)obj;
            return this.fileEditorInput.equals(otherInput.fileEditorInput);
        }
        if (obj instanceof IFileEditorInput) {
            IFileEditorInput otherInput = (IFileEditorInput)obj;
            return this.fileEditorInput.equals(otherInput);
        }
        return false;
    }

    public int hashCode() {
        return this.fileEditorInput.hashCode();
    }
}

