/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class IFileTemplateInput
extends TemplateInput {
    protected IFileEditorInput fileEditorInput;

    public IFileTemplateInput(IFile file) {
        ArgChecks.checkForNull((Object)file, (String)"file");
        this.fileEditorInput = new FileEditorInput(file);
    }

    public IFileTemplateInput(IFileEditorInput fileEditorInput) {
        ArgChecks.checkForNull((Object)fileEditorInput, (String)"fileEditorInput");
        this.fileEditorInput = fileEditorInput;
    }

    public String getName() {
        return this.fileEditorInput.getName();
    }

    public String getToolTipText() {
        return this.fileEditorInput.getToolTipText();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.fileEditorInput.getImageDescriptor();
    }

    @Override
    public boolean exists() {
        return this.fileEditorInput.exists();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.fileEditorInput.getAdapter(adapter);
    }

    @Override
    public IPersistableElement getPersistable() {
        return this.fileEditorInput.getPersistable();
    }

    @Override
    public TemplateInput.Holder load() throws Exception {
        return this.loadIFileAsTemplate(this.fileEditorInput.getFile());
    }

    @Override
    public boolean isSaveAllowed() {
        return true;
    }

    @Override
    public TemplateInput.Holder doSave(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        IFileTemplateInput.saveTemplateToIFile(this.getFile(), template, templateStatus, monitor);
        return null;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public TemplateInput doSaveAs(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setOriginalFile(this.getFile());
        dialog.create();
        if (dialog.open() == 1) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return null;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile saveAsFile = workspace.getRoot().getFile(filePath);
        IFileTemplateInput.saveTemplateToIFile(saveAsFile, template, templateStatus, monitor);
        return new IFileTemplateInput(saveAsFile);
    }

    private TemplateInput.Holder loadIFileAsTemplate(IFile file) throws CoreException, VersionException, XMLFormatException, IOException {
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        factory.setCreateChangeable(true);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        if (!file.isSynchronized(0)) {
            try {
                file.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        TemplateStatus templateStatus = xmlImport.getTemplateStatusFromStream(file.getContents(true));
        Template template = xmlImport.getTemplateFromStream(file.getContents(true));
        return new TemplateInput.Holder(template, templateStatus);
    }

    private static void saveTemplateToIFile(final IFile file, final Template template, final TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        ArgChecks.checkForNull((Object)template, (String)"template");
        file.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ProcessModelXMLExport export = new ProcessModelXMLExport();
                    InputStream input = null;
                    if (!(template instanceof ChangeableTemplate)) {
                        String message = String.format("Saving a template which is not changeable. Updating the ID is not possible.", new Object[0]);
                        LoggerTools.getLogger((Object)this).severe(message);
                        throw new RuntimeException(message);
                    }
                    ((ChangeableTemplate)template).updateID(UUIDTools.createPositiveUUID());
                    input = templateStatus == null ? export.getInputStreamForTemplate(template) : export.getInputStreamForTemplateAndStatus(template, templateStatus);
                    if (file.exists()) {
                        file.setContents(input, true, true, monitor);
                    } else {
                        file.create(input, true, monitor);
                    }
                    input.close();
                }
                catch (IOException e) {
                    Status status = new Status(4, Editor.ID, 0, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                catch (XMLFormatException e) {
                    Status status = new Status(4, Editor.ID, 0, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }, monitor);
    }

    public IFile getFile() {
        return this.fileEditorInput.getFile();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IFileTemplateInput) {
            IFileTemplateInput otherInput = (IFileTemplateInput)obj;
            return this.fileEditorInput.equals(otherInput.fileEditorInput);
        }
        if (obj instanceof IFileEditorInput) {
            IFileEditorInput otherInput = (IFileEditorInput)obj;
            return this.fileEditorInput.equals(otherInput);
        }
        return false;
    }

    public int hashCode() {
        return this.fileEditorInput.hashCode();
    }
}

