/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.editorinputs;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.model.processmodel.ChangeReport;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.SilentException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;

public class InstanceChangingInput
extends InstanceInput {
    private UUID instanceID;
    private boolean lockedForChanges;
    private ChangeableInstance cachedInstance;
    private final String instanceName;
    private SessionToken session;
    private final InstanceManager instanceManager;
    private final InstanceChanging instanceChanging;

    public InstanceChangingInput(UUID instanceID, InstanceManager instanceManager, InstanceChanging instanceChanging) {
        ArgChecks.checkForNull((Object)instanceID, (String)"instanceID");
        ArgChecks.checkForNull((Object)instanceManager, (String)"instanceManager");
        ArgChecks.checkForNull((Object)instanceChanging, (String)"instanceChanging");
        this.instanceManager = instanceManager;
        this.instanceChanging = instanceChanging;
        this.session = Activator.getService().getSessionToken();
        this.instanceName = instanceManager.getInstanceReference(this.session, instanceID).getName();
        this.instanceID = instanceID;
    }

    public InstanceChangingInput(UUID instanceID) {
        this(instanceID, Activator.getService().getProcessManager().getInstanceManager(), Activator.getFullService().getInstanceChanging());
    }

    public String getName() {
        if (this.cachedInstance != null) {
            return "Modifying " + this.cachedInstance.getName();
        }
        return "Modifying " + this.instanceName;
    }

    public String getToolTipText() {
        return this.getName();
    }

    @Override
    public InstanceInput.Holder load() throws Exception {
        return this.prepareForChanging(this.instanceID);
    }

    @Override
    public boolean isSaveAllowed() {
        return true;
    }

    @Override
    public InstanceInput.Holder doSave(Instance instance, IProgressMonitor monitor) throws Exception {
        return this.commitChanges((ChangeableInstance)instance);
    }

    @Override
    public void dispose() throws Exception {
        this.abortChanges();
    }

    public InstanceInput.Holder prepareForChanging(UUID instanceID) throws InvalidInstanceStateException {
        if (this.session == null) {
            this.session = Activator.getService().getSessionToken();
        }
        ChangeableInstance instance = this.instanceChanging.getInstanceForChanging(this.session, instanceID);
        this.lockedForChanges = true;
        this.cachedInstance = instance;
        return new InstanceInput.Holder((Instance)instance);
    }

    private InstanceInput.Holder commitChanges(ChangeableInstance instance) throws Exception {
        if (!instance.getID().equals(this.instanceID)) {
            throw new IllegalArgumentException("can't commit changes for an instance with a different instance ID!");
        }
        if (this.lockedForChanges) {
            ChangeReport changeReport = this.instanceChanging.changeInstance(this.session, instance);
            UUID newInstanceID = changeReport.newInstanceID;
            if (newInstanceID == null) {
                String msg = "The instance changes could not be uploaded, because the instance contains errors:";
                new CheckReportDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (CheckReport)changeReport, msg, 8, CheckReport.ResultType.WARNING).open();
                throw new SilentException();
            }
            String msg = "The instance changes were commited successfully!";
            new CheckReportDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (CheckReport)changeReport, msg, 2, CheckReport.ResultType.INFO).open();
            this.instanceID = newInstanceID;
            this.cachedInstance = changeReport.newInstance;
            return new InstanceInput.Holder((Instance)instance);
        }
        return null;
    }

    private void abortChanges() {
        if (this.lockedForChanges) {
            this.instanceChanging.abortInstanceChanging(this.session, this.instanceID);
            this.lockedForChanges = false;
            this.session = null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InstanceChangingInput)) {
            return false;
        }
        InstanceChangingInput otherInput = (InstanceChangingInput)obj;
        return this.instanceID.equals(otherInput.instanceID);
    }

    public int hashCode() {
        return this.instanceID.hashCode();
    }
}

