/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.model;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MappingData {
    private ProcessModelParameter parameter;
    private DataElement dataElement = null;
    private DataElement[] dataElements;
    private Set<DataElement> compliantConnectedDataElements = new HashSet<DataElement>();
    private Set<DataElement> compliantUnConnectedDataElements = new HashSet<DataElement>();
    private String[] dataElementNames;
    private Map<String, DataElement> nameIDToDataElement = new HashMap<String, DataElement>();
    private Map<Integer, String> dataElementIDToName = new HashMap<Integer, String>();
    private String status = "info_tsk.gif";
    private ProcessConstants.DataMappingType dataMappingType = ProcessConstants.DataMappingType.NEW_DATAELEMENT;
    private boolean changed = false;

    public MappingData() {
    }

    public MappingData(Template template, int nodeID, ProcessModelParameter parameter, ActivityConstants.AccessType type) {
        this.setParameter(parameter);
        this.initialise(template, type, nodeID);
    }

    public MappingData(Template template, int nodeID, ProcessModelParameter parameter, ActivityConstants.AccessType type, DataElement dataElement, ProcessConstants.DataMappingType mappingType, String status) {
        this.setParameter(parameter);
        this.initialise(template, type, nodeID);
        this.setDataElement(dataElement);
        this.setDataMappingType(mappingType);
        this.setStatus(status);
    }

    public MappingData(ProcessModelParameter parameter, DataElement dataElement, DataElement[] dataElements, ProcessConstants.DataMappingType mappingType, String status) {
        this.setParameter(parameter);
        this.setDataElement(dataElement);
        this.setDataElements(dataElements);
        this.setDataMappingType(mappingType);
        this.setStatus(status);
    }

    private void initialise(Template template, ActivityConstants.AccessType type, int nodeID) {
        String name;
        LinkedList<String> dataElementNameList = new LinkedList<String>();
        this.compliantConnectedDataElements = ChangeOperationTools.getCompliantConnectedDataElementsForParameter((ProcessModelParameter)this.parameter, (Template)template, (int)nodeID, (ActivityConstants.AccessType)type);
        this.compliantUnConnectedDataElements = ChangeOperationTools.getCompliantUnConnectedDataElementsForParameter((ProcessModelParameter)this.parameter, (Template)template, (int)nodeID, (ActivityConstants.AccessType)type);
        this.dataElements = new DataElement[this.compliantConnectedDataElements.size() + this.compliantUnConnectedDataElements.size()];
        int counter = 0;
        DataElement[] compliantArray = this.compliantConnectedDataElements.toArray(new DataElement[0]);
        int i = 0;
        while (i < compliantArray.length) {
            this.dataElements[counter] = compliantArray[i];
            name = "* " + compliantArray[i].getName() + "  (ID: " + compliantArray[i].getID() + ")";
            dataElementNameList.add(name);
            this.nameIDToDataElement.put(name, this.dataElements[counter]);
            this.dataElementIDToName.put(this.dataElements[counter].getID(), name);
            ++counter;
            ++i;
        }
        compliantArray = this.compliantUnConnectedDataElements.toArray(new DataElement[0]);
        i = 0;
        while (i < compliantArray.length) {
            this.dataElements[counter] = compliantArray[i];
            name = String.valueOf(compliantArray[i].getName()) + "  (ID: " + compliantArray[i].getID() + ")";
            dataElementNameList.add(name);
            this.nameIDToDataElement.put(name, this.dataElements[counter]);
            this.dataElementIDToName.put(this.dataElements[counter].getID(), name);
            ++counter;
            ++i;
        }
        dataElementNameList.add("<CONNECT LATER>");
        this.nameIDToDataElement.put("<CONNECT LATER>", null);
        if (this.parameter.isOptional() || type == ActivityConstants.AccessType.WRITE) {
            dataElementNameList.add("<DISABLE>");
            this.nameIDToDataElement.put("<DISABLE>", null);
        }
        dataElementNameList.add("<NEW DATAELEMENT>");
        this.nameIDToDataElement.put("<NEW DATAELEMENT>", null);
        Collections.sort(dataElementNameList);
        this.dataElementNames = dataElementNameList.toArray(new String[0]);
    }

    public void setParameter(ProcessModelParameter parameter) {
        this.parameter = parameter;
    }

    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public void setDataElements(DataElement[] dataElements) {
        this.dataElements = dataElements != null ? (DataElement[])dataElements.clone() : new DataElement[0];
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDataMappingType(ProcessConstants.DataMappingType type) {
        this.dataMappingType = type;
    }

    public DataElement getDataElement() {
        return this.dataElement;
    }

    public DataElement getDataElementForName(String name) {
        return this.nameIDToDataElement.get(name);
    }

    public String getDataElementName() {
        String stringValue = "";
        switch (this.dataMappingType) {
            case DATAELEMENT: {
                stringValue = this.dataElementIDToName.get(this.dataElement.getID());
                break;
            }
            case NEW_DATAELEMENT: {
                stringValue = "<NEW DATAELEMENT>";
                break;
            }
            case DISABLE: {
                stringValue = "<DISABLE>";
                break;
            }
            case CONNECT_LATER: {
                stringValue = "<CONNECT LATER>";
                break;
            }
            default: {
                throw new RuntimeException("DataMappingType not supported");
            }
        }
        return stringValue;
    }

    public DataElement[] getDataElements() {
        return (DataElement[])this.dataElements.clone();
    }

    public String[] getDataElementNames() {
        if (this.dataElementNames != null) {
            return (String[])this.dataElementNames.clone();
        }
        return new String[0];
    }

    public ProcessModelParameter getParameter() {
        return this.parameter;
    }

    public String getParameterName() {
        if (this.parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
            String udt = this.parameter.getUDTName();
            if (udt.equals("")) {
                return String.valueOf(this.parameter.getName()) + "  (UDT: <type not specified>)";
            }
            return String.valueOf(this.parameter.getName()) + "  (UDT:" + udt + ")";
        }
        return String.valueOf(this.parameter.getName()) + "  (" + this.parameter.getDataType().toString() + ")";
    }

    public String getStatus() {
        return this.status;
    }

    public ProcessConstants.DataMappingType getDataMappingType() {
        return this.dataMappingType;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChangeStatus(boolean changed) {
        this.changed = changed;
    }

    public Set<DataElement> getCompliantConnectedDataElements() {
        return this.compliantConnectedDataElements;
    }

    public Set<DataElement> getCompliantUnConnectedDataElements() {
        return this.compliantUnConnectedDataElements;
    }
}

