/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.model;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.model.MappingChangeEffectListener;
import de.aristaflow.adept2.ui.processediting.model.MappingData;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangeListener;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangedEvent;
import de.aristaflow.adept2.ui.processediting.model.MappingDataProperty;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ParameterMappingEntry;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class MappingDataList {
    private Template template;
    private Node node;
    protected ActivityConstants.AccessType type;
    protected List<MappingData> mappingDataList = new ArrayList<MappingData>();
    private Set<MappingDataListChangeListener> changeListeners = new HashSet<MappingDataListChangeListener>();
    private Set<MappingChangeEffectListener> changeEffectListeners = new HashSet<MappingChangeEffectListener>();
    protected static final Comparator<MappingData> mappingDataComparator = new Comparator<MappingData>(){

        @Override
        public int compare(MappingData md1, MappingData md2) {
            String one = md1.getParameterName();
            String two = md2.getParameterName();
            return one.compareTo(two);
        }
    };

    public MappingDataList(ChangeableTemplate template, ActivityConstants.AccessType type, Node node, Map<ProcessModelParameter, DataElement> mappingWithExistentDataElements, Map<ProcessModelParameter, ProcessConstants.DataMappingType> mappingWithoutExistentDataElements) {
        this.template = template;
        this.node = node;
        this.type = type;
        this.initData(mappingWithExistentDataElements, mappingWithoutExistentDataElements);
    }

    public MappingDataList(EBPPnPWizardData data, ActivityConstants.AccessType type) {
        this.template = data.getNodeData().getProcessTemplate();
        this.node = data.getNodeData().getNode();
        this.type = type;
        this.initData(data);
    }

    private void initData(Map<ProcessModelParameter, DataElement> mappingWithExistentDataElements, Map<ProcessModelParameter, ProcessConstants.DataMappingType> mappingWithoutExistentDataElements) {
        MappingData mData;
        String status;
        for (Map.Entry<ProcessModelParameter, DataElement> entry : mappingWithExistentDataElements.entrySet()) {
            DataElement data = entry.getValue();
            status = null;
            mData = new MappingData(this.template, this.node.getID(), entry.getKey(), this.type, data, ProcessConstants.DataMappingType.DATAELEMENT, status);
            this.mappingDataList.add(mData);
        }
        for (Map.Entry<ProcessModelParameter, DataElement> entry : mappingWithoutExistentDataElements.entrySet()) {
            ProcessConstants.DataMappingType mappingType = (ProcessConstants.DataMappingType)entry.getValue();
            status = null;
            switch (mappingType) {
                case NEW_DATAELEMENT: 
                case DISABLE: {
                    status = "info_tsk.gif";
                    break;
                }
                case CONNECT_LATER: {
                    status = "warning_tsk.gif";
                }
            }
            mData = new MappingData(this.template, this.node.getID(), entry.getKey(), this.type, null, mappingType, status);
            this.mappingDataList.add(mData);
        }
        Collections.sort(this.mappingDataList, mappingDataComparator);
    }

    private void initData(final EBPPnPWizardData wizardData) {
        for (Map.Entry<ProcessModelParameter, ParameterMappingEntry> entry : wizardData.getParameterMapping(this.type).entrySet()) {
            this.addMappingData(entry.getKey(), entry.getValue().element, entry.getValue().type);
        }
        Collections.sort(this.mappingDataList, mappingDataComparator);
        PnPWizardChangeListener changeListener = new PnPWizardChangeListener(){

            @Override
            public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType changeType, Object affectedObject) {
                switch (changeType) {
                    case READ_PARAMETER_ADDED: 
                    case WRITE_PARAMETER_ADDED: {
                        ProcessModelParameter param = (ProcessModelParameter)affectedObject;
                        if ((changeType != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED || MappingDataList.this.type != ActivityConstants.AccessType.READ) && (changeType != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_ADDED || MappingDataList.this.type != ActivityConstants.AccessType.WRITE)) break;
                        ParameterMappingEntry mapData = wizardData.getParameterMapping(MappingDataList.this.type).get(param);
                        MappingData mData = MappingDataList.this.addMappingData(param, mapData.element, mapData.type);
                        MappingDataList.this.mappingDataChanged(mData, MappingDataListChangedEvent.ChangeType.ADDED, MappingDataProperty.values());
                        break;
                    }
                    case READ_PARAMETER_REMOVED: 
                    case WRITE_PARAMETER_REMOVED: {
                        if ((changeType != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_REMOVED || MappingDataList.this.type != ActivityConstants.AccessType.READ) && (changeType != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_REMOVED || MappingDataList.this.type != ActivityConstants.AccessType.WRITE)) break;
                        MappingData mData = MappingDataList.this.removeMappingDataFor(((ProcessModelParameter)affectedObject).getName());
                        MappingDataList.this.mappingDataChanged(mData, MappingDataListChangedEvent.ChangeType.REMOVED, new MappingDataProperty[0]);
                        break;
                    }
                    case READ_PARAMETER_MAPPING_CHANGED: 
                    case WRITE_PARAMETER_MAPPING_CHANGED: {
                        if ((changeType != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_MAPPING_CHANGED || MappingDataList.this.type != ActivityConstants.AccessType.READ) && (changeType != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_MAPPING_CHANGED || MappingDataList.this.type != ActivityConstants.AccessType.WRITE)) break;
                        MappingData mData = MappingDataList.this.findMappingDataFor(((ProcessModelParameter)affectedObject).getName());
                        ParameterMappingEntry mapData = wizardData.getParameterMapping(MappingDataList.this.type).get(affectedObject);
                        mData.setDataMappingType(mapData.type);
                        mData.setDataElement(mapData.element);
                        MappingDataList.this.mappingDataChanged(mData, MappingDataListChangedEvent.ChangeType.MODIFIED, MappingDataProperty.DATA_ELEMENT, MappingDataProperty.DATA_MAPPING_TYPE);
                        break;
                    }
                    case READ_PARAMETER_CHANGED: 
                    case WRITE_PARAMETER_CHANGED: {
                        if ((changeType != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED || MappingDataList.this.type != ActivityConstants.AccessType.READ) && (changeType != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_CHANGED || MappingDataList.this.type != ActivityConstants.AccessType.WRITE)) break;
                        ProcessModelParameter[] params = (ProcessModelParameter[])affectedObject;
                        MappingData mData = MappingDataList.this.removeMappingDataFor(params[0].getName());
                        MappingDataList.this.mappingDataChanged(mData, MappingDataListChangedEvent.ChangeType.REMOVED, new MappingDataProperty[0]);
                        ParameterMappingEntry mapData = wizardData.getParameterMapping(MappingDataList.this.type).get(params[1]);
                        mData = MappingDataList.this.addMappingData(params[1], mapData.element, mapData.type);
                        MappingDataList.this.mappingDataChanged(mData, MappingDataListChangedEvent.ChangeType.ADDED, MappingDataProperty.values());
                    }
                }
            }
        };
        wizardData.addChangeListener(changeListener);
    }

    protected MappingData addMappingData(ProcessModelParameter param, DataElement data, ProcessConstants.DataMappingType mappingType) {
        String status;
        switch (mappingType) {
            case NEW_DATAELEMENT: 
            case DISABLE: {
                status = "info_tsk.gif";
                break;
            }
            case CONNECT_LATER: {
                status = "warning_tsk.gif";
                break;
            }
            default: {
                status = null;
            }
        }
        MappingData mData = new MappingData(this.template, this.node.getID(), param, this.type, data, mappingType, status);
        this.mappingDataList.add(mData);
        return mData;
    }

    protected MappingData removeMappingDataFor(String paramName) {
        ListIterator<MappingData> listIterator = this.mappingDataList.listIterator();
        while (listIterator.hasNext()) {
            MappingData mData = listIterator.next();
            if (!mData.getParameter().getName().equals(paramName)) continue;
            listIterator.remove();
            return mData;
        }
        return null;
    }

    protected MappingData findMappingDataFor(String paramName) {
        ListIterator<MappingData> listIterator = this.mappingDataList.listIterator();
        while (listIterator.hasNext()) {
            MappingData mData = listIterator.next();
            if (!mData.getParameter().getName().equals(paramName)) continue;
            return mData;
        }
        return null;
    }

    public String calculateStatus(MappingData mData, DataElement newDataElement, ProcessConstants.DataMappingType newType) {
        String status = null;
        ProcessConstants.DataMappingType oldType = mData.getDataMappingType();
        switch (oldType) {
            case NEW_DATAELEMENT: 
            case DISABLE: 
            case CONNECT_LATER: {
                switch (newType) {
                    case DATAELEMENT: {
                        status = this.calculateStatusForSystemValueToDataElementChange(mData, newDataElement);
                        break;
                    }
                    case CONNECT_LATER: {
                        status = "warning_tsk.gif";
                        break;
                    }
                    case NEW_DATAELEMENT: 
                    case DISABLE: {
                        status = "info_tsk.gif";
                    }
                }
                break;
            }
            case DATAELEMENT: {
                switch (newType) {
                    case NEW_DATAELEMENT: 
                    case DISABLE: 
                    case CONNECT_LATER: {
                        status = this.calculateStatusForDataElementToSystemValueChange(mData, newType);
                        break;
                    }
                    case DATAELEMENT: {
                        status = this.calculateStatusForDataElementToSystemValueChange(mData, newType);
                        status = this.calculateStatusForSystemValueToDataElementChange(mData, newDataElement);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data mapping type not supported");
            }
        }
        return status;
    }

    private String calculateStatusForDataElementToSystemValueChange(MappingData mData, ProcessConstants.DataMappingType newType) {
        String status = null;
        LinkedList<MappingData> sameData = new LinkedList<MappingData>();
        for (MappingData otherMData : this.getMappingDataList()) {
            if (otherMData.equals(mData) || otherMData.getDataMappingType() != ProcessConstants.DataMappingType.DATAELEMENT || otherMData.getDataElement().getID() != mData.getDataElement().getID()) continue;
            sameData.add(otherMData);
        }
        if (sameData.size() == 1) {
            String sameDataState = this.fireChangeEffectEvent((MappingData)sameData.get(0), ((MappingData)sameData.get(0)).getDataElement());
            ((MappingData)sameData.get(0)).setStatus(sameDataState);
            this.mappingDataChanged((MappingData)sameData.get(0), MappingDataProperty.STATUS);
        } else if (sameData.size() == 0) {
            this.fireChangeEffectEvent(mData, null);
        }
        switch (newType) {
            case CONNECT_LATER: {
                status = "warning_tsk.gif";
                break;
            }
            case NEW_DATAELEMENT: 
            case DISABLE: {
                status = "info_tsk.gif";
            }
        }
        return status;
    }

    private String calculateStatusForSystemValueToDataElementChange(MappingData mData, DataElement newDataElement) {
        String status = null;
        for (MappingData otherMData : this.getMappingDataList()) {
            if (otherMData.equals(mData) || otherMData.getDataMappingType() != ProcessConstants.DataMappingType.DATAELEMENT || otherMData.getDataElement().getID() != newDataElement.getID()) continue;
            status = "error_tsk.gif";
            otherMData.setStatus(status);
            this.mappingDataChanged(otherMData, MappingDataProperty.STATUS);
        }
        if (status == null) {
            status = this.fireChangeEffectEvent(mData, newDataElement);
        }
        return status;
    }

    public String checkEffectsOfDataMappingChange(MappingData mData, DataElement newDataElement) {
        String status = null;
        if (newDataElement == null) {
            LinkedList<MappingData> sameData = new LinkedList<MappingData>();
            for (MappingData otherMData : this.getMappingDataList()) {
                if (otherMData.getDataMappingType() != ProcessConstants.DataMappingType.DATAELEMENT || otherMData.getDataElement().getID() != mData.getDataElement().getID()) continue;
                sameData.add(otherMData);
            }
            if (sameData.size() == 1) {
                ((MappingData)sameData.get(0)).setStatus(null);
                this.mappingDataChanged((MappingData)sameData.get(0), MappingDataProperty.STATUS);
            }
        } else {
            LinkedList<MappingData> sameData = new LinkedList<MappingData>();
            for (MappingData otherMData : this.getMappingDataList()) {
                if (otherMData.getDataMappingType() != ProcessConstants.DataMappingType.DATAELEMENT || otherMData.getDataElement().getID() != newDataElement.getID()) continue;
                sameData.add(otherMData);
            }
            if (sameData.size() == 1) {
                MappingData otherMData;
                otherMData = (MappingData)sameData.get(0);
                if (!(otherMData.getParameter().getIdentifierID().equals(mData.getParameter().getIdentifierID()) || otherMData.getParameter().getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || mData.getParameter().getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID))) {
                    status = "error_tsk.gif";
                    otherMData.setStatus(status);
                }
                this.mappingDataChanged(otherMData, MappingDataProperty.STATUS);
            } else if (sameData.size() > 1) {
                status = "error_tsk.gif";
            }
        }
        return status;
    }

    public List<MappingData> getMappingDataList() {
        return this.mappingDataList;
    }

    public void mappingDataChanged(MappingData newMData, MappingDataListChangedEvent.ChangeType changeType, MappingDataProperty ... properties) {
        MappingDataListChangedEvent event = new MappingDataListChangedEvent(newMData, changeType, properties);
        for (MappingDataListChangeListener listener : this.changeListeners) {
            listener.modelChanged(event);
        }
    }

    public void mappingDataChanged(MappingData newMData, MappingDataProperty ... properties) {
        this.mappingDataChanged(newMData, MappingDataListChangedEvent.ChangeType.MODIFIED, properties);
    }

    public void addChangeListener(MappingDataListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(MappingDataListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void addChangeEffectListener(MappingChangeEffectListener listener) {
        this.changeEffectListeners.add(listener);
    }

    public void removeChangeEffectListener(MappingChangeEffectListener listener) {
        this.changeEffectListeners.remove(listener);
    }

    protected String fireChangeEffectEvent(MappingData mData, DataElement newDataElement) {
        String status = null;
        for (MappingChangeEffectListener listeners : this.changeEffectListeners) {
            String tempStatus = listeners.checkEffectsOnOtherMappingDataLists(mData, newDataElement, this);
            if (tempStatus != "error_tsk.gif") continue;
            status = tempStatus;
        }
        return status;
    }

    public ActivityConstants.AccessType getType() {
        return this.type;
    }
}

