/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.model;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processediting.model.MappingData;
import de.aristaflow.adept2.ui.processediting.model.MappingDataList;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangeListener;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangedEvent;
import de.aristaflow.adept2.ui.processediting.model.MappingDataProperty;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParameterMappingTableInitialiser {
    private final ActivityConstants.AccessType type;
    private Table table;
    private TableViewer tableViewer;
    private static final int MINIMAL_COL_WIDTH = 150;

    public ParameterMappingTableInitialiser(Composite parent, int style, ActivityConstants.AccessType type) {
        this.table = new Table(parent, style);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, 16);
            }
        });
        if (!ActivityConstants.AccessType.isActivityRelatedValue((ActivityConstants.AccessType)type)) {
            throw new IllegalArgumentException("Only activity related access typesare supported.");
        }
        this.type = type;
        this.init();
    }

    private void init() {
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        final TableColumn parameterCol = new TableColumn(this.table, 16384);
        final TableColumn dataElementCol = new TableColumn(this.table, 16384);
        final TableColumn iconCol = new TableColumn(this.table, 0x1000000);
        switch (this.type) {
            case READ: {
                parameterCol.setText("Input-Parameter");
                break;
            }
            case WRITE: {
                parameterCol.setText("Output-Parameter");
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                assert (false);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        parameterCol.setWidth(150);
        dataElementCol.setWidth(150);
        dataElementCol.setText("Data Elements");
        iconCol.setText("Status");
        iconCol.pack();
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = this.createAndConfigureCellEditor();
        CellEditor[] editors = cellEditorArray;
        this.tableViewer = this.createAndConfigureTableViewer(editors);
        this.table.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableColumn[] inColumns = new TableColumn[]{parameterCol, dataElementCol, iconCol};
                ParameterMappingTableInitialiser.this.reactOnResizeEvent(inColumns);
            }
        });
    }

    private ComboBoxCellEditor createAndConfigureCellEditor() {
        ComboBoxCellEditor dataElementCellEditor = new ComboBoxCellEditor();
        dataElementCellEditor.setStyle(8);
        dataElementCellEditor.create((Composite)this.table);
        return dataElementCellEditor;
    }

    private TableViewer createAndConfigureTableViewer(CellEditor[] editors) {
        String[] columnNames = new String[3];
        switch (this.type) {
            case READ: {
                columnNames[0] = "IN_PARAMETER";
                break;
            }
            case WRITE: {
                columnNames[0] = "OUT_PARAMETER";
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                assert (false);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        columnNames[1] = "DATA_ELEMENT";
        columnNames[2] = "STATUS";
        TableViewer tableViewer = new TableViewer(this.table);
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)new MappingDataCellModifier(tableViewer));
        tableViewer.setContentProvider((IContentProvider)new MappingDataContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new MappingDataLabelProvider());
        tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                MappingData md1 = (MappingData)e1;
                MappingData md2 = (MappingData)e2;
                return md1.getParameter().getName().compareTo(md2.getParameter().getName());
            }
        });
        return tableViewer;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.table;
    }

    public void setInputData(MappingDataList data) {
        this.tableViewer.setInput((Object)data);
    }

    public ISelection getTableSelection() {
        return this.tableViewer.getSelection();
    }

    protected void reactOnResizeEvent(TableColumn[] tableColumns) {
        Composite parent = this.table.getParent();
        Rectangle area = parent.getClientArea();
        Point inPreferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth() - 2 * ((FillLayout)parent.getLayout()).marginWidth;
        if (inPreferredSize.y >= area.height + this.table.getHeaderHeight() - 2 * ((FillLayout)parent.getLayout()).marginHeight) {
            Point vBarSize = this.table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.table.getSize();
        if (oldSize.x > area.width) {
            if ((width - tableColumns[2].getWidth()) / 2 > 150) {
                tableColumns[0].setWidth((width - tableColumns[2].getWidth()) / 2);
                tableColumns[1].setWidth((width - tableColumns[2].getWidth()) / 2);
            } else {
                tableColumns[0].setWidth(150);
                tableColumns[1].setWidth(150);
            }
            this.table.setSize(area.width, area.height);
        } else {
            this.table.setSize(area.width, area.height);
            if ((width - tableColumns[2].getWidth()) / 2 > 150) {
                tableColumns[0].setWidth((width - tableColumns[2].getWidth()) / 2);
                tableColumns[1].setWidth((width - tableColumns[2].getWidth()) / 2);
            } else {
                tableColumns[0].setWidth(150);
                tableColumns[1].setWidth(150);
            }
        }
    }

    static class MappingDataCellModifier
    implements ICellModifier {
        TableViewer tableViewer = null;

        public MappingDataCellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = false;
            if (this.tableViewer.getColumnProperties()[1].equals(property)) {
                modifiable = true;
            }
            return modifiable;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(this.tableViewer.getColumnProperties()).indexOf(property);
            Object result = null;
            MappingData mData = (MappingData)element;
            switch (columnIndex) {
                case 0: {
                    System.out.println("Can't be changed");
                    break;
                }
                case 1: {
                    String stringValue = mData.getDataElementName();
                    ((ComboBoxCellEditor)this.tableViewer.getCellEditors()[columnIndex]).setItems(mData.getDataElementNames());
                    String[] choices = mData.getDataElementNames();
                    int i = choices.length - 1;
                    if (stringValue != null) {
                        while (!stringValue.equals(choices[i]) && i > 0) {
                            --i;
                        }
                    } else {
                        i = -1;
                    }
                    result = i;
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            MappingData mData;
            int columnIndex = Arrays.asList(this.tableViewer.getColumnProperties()).indexOf(property);
            if (element instanceof TableItem) {
                mData = (MappingData)((TableItem)element).getData();
            } else if (element instanceof MappingData) {
                mData = (MappingData)element;
            } else {
                throw new IllegalArgumentException("Don't know how to handle element!");
            }
            MappingDataList mDataList = null;
            if (!(this.tableViewer.getInput() instanceof MappingDataList)) {
                throw new IllegalArgumentException("Viewer does not have the right model");
            }
            mDataList = (MappingDataList)this.tableViewer.getInput();
            switch (columnIndex) {
                case 0: {
                    System.out.println("Can't be changed");
                    break;
                }
                case 1: {
                    String stringValue = value == null || !(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= mData.getDataElementNames().length ? "<CONNECT LATER>" : mData.getDataElementNames()[(Integer)value];
                    if (mData.getDataElementName().equals(stringValue)) break;
                    if (stringValue.equals("<CONNECT LATER>")) {
                        String status = mDataList.calculateStatus(mData, null, ProcessConstants.DataMappingType.CONNECT_LATER);
                        mData.setDataElement(null);
                        mData.setDataMappingType(ProcessConstants.DataMappingType.CONNECT_LATER);
                        mData.setChangeStatus(true);
                        mData.setStatus(status);
                        break;
                    }
                    if (stringValue.equals("<DISABLE>")) {
                        String status = mDataList.calculateStatus(mData, null, ProcessConstants.DataMappingType.DISABLE);
                        mData.setDataElement(null);
                        mData.setDataMappingType(ProcessConstants.DataMappingType.DISABLE);
                        mData.setChangeStatus(true);
                        mData.setStatus(status);
                        break;
                    }
                    if (stringValue.equals("<NEW DATAELEMENT>")) {
                        String status = mDataList.calculateStatus(mData, null, ProcessConstants.DataMappingType.NEW_DATAELEMENT);
                        mData.setDataElement(null);
                        mData.setDataMappingType(ProcessConstants.DataMappingType.NEW_DATAELEMENT);
                        mData.setChangeStatus(true);
                        mData.setStatus(status);
                        break;
                    }
                    DataElement dataElement = mData.getDataElementForName(stringValue);
                    String status = mDataList.calculateStatus(mData, dataElement, ProcessConstants.DataMappingType.DATAELEMENT);
                    mData.setDataElement(dataElement);
                    mData.setDataMappingType(ProcessConstants.DataMappingType.DATAELEMENT);
                    mData.setChangeStatus(true);
                    mData.setStatus(status);
                }
            }
            mDataList.mappingDataChanged(mData, MappingDataProperty.DATA_ELEMENT, MappingDataProperty.DATA_MAPPING_TYPE, MappingDataProperty.STATUS);
        }
    }

    class MappingDataContentProvider
    implements IStructuredContentProvider,
    MappingDataListChangeListener {
        MappingDataContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((MappingDataList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((MappingDataList)oldInput).removeChangeListener(this);
            }
        }

        public Object[] getElements(Object parent) {
            return ((MappingDataList)parent).getMappingDataList().toArray();
        }

        @Override
        public void modelChanged(MappingDataListChangedEvent mappingDataListChangedEvent) {
            switch (mappingDataListChangedEvent.getChangeType()) {
                case ADDED: {
                    ParameterMappingTableInitialiser.this.getTableViewer().add(mappingDataListChangedEvent.getSource());
                    break;
                }
                case MODIFIED: {
                    ParameterMappingTableInitialiser.this.getTableViewer().update(mappingDataListChangedEvent.getSource(), null);
                    break;
                }
                case REMOVED: {
                    ParameterMappingTableInitialiser.this.getTableViewer().remove(mappingDataListChangedEvent.getSource());
                }
            }
        }

        public void dispose() {
        }
    }

    static class MappingDataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image getImage(String imageName) {
            return MiscImages.getImage((String)imageName);
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            MappingData mData = (MappingData)element;
            switch (columnIndex) {
                case 0: {
                    result = mData.getParameterName();
                    break;
                }
                case 1: {
                    result = mData.getDataElementName();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 2 ? this.getImage(((MappingData)element).getStatus()) : null;
        }
    }
}

