/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.views;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ChangeOperationAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.CreateSurroundingAndBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.CreateSurroundingLoopBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.CreateSurroundingOrBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteBorderNodesAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteBranchAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteConstraintEdgeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteDataElementAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteNodeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ExtractSubprocessAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertAndBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertBranchAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertConstraintEdgeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertDataAccessAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertDataElementAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertLoopBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertNodeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.InsertOrBlockAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.MoveNodesAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.RemoveDataAccessAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.RemoveExecutableBusinessProcessAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ToggleDataEdgeOptionalAttributeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.ToggleSyncAction;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ChangeOperationsView
extends ViewPart
implements ChangeListener,
ISelectionChangedListener,
ISelectionListener,
ITabbedPropertySheetPageContributor {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".views.ChangeOperationsView";
    private static final boolean ENABLESECONDARYSELECTION = false;
    private static final SelectionDefinition primaryPreSelection = new SelectionDefinition("primaryPreSelection", "preselection", "Select the source start Element for a changeoperation", ColorConstants.lightGreen, SelectionDefinition.SelectionMode.MULTIPLE, new Class[]{Node.class, DataElement.class, Edge.class});
    private static final SelectionDefinition primaryPostSelection = new SelectionDefinition("primaryPostSelection", "postselection", "Select the source end Element for a changeoperation", ColorConstants.lightBlue, SelectionDefinition.SelectionMode.MULTIPLE, new Class[]{Node.class, DataElement.class});
    private static final SelectionDefinition secondaryPreSelection = new SelectionDefinition("secondaryPreSelection", "secondary preselection (opt)", "Select the target start Element for some changeoperation", ColorConstants.darkGreen, SelectionDefinition.SelectionMode.SINGLE, new Class[]{Node.class, DataElement.class, Edge.class});
    private static final SelectionDefinition secondaryPostSelection = new SelectionDefinition("secondaryPostSelection", "secondary postselection (opt)", "Select the target end Element for some changeoperation", ColorConstants.darkBlue, SelectionDefinition.SelectionMode.SINGLE, new Class[]{Node.class, DataElement.class});
    private static SelectionGroupDefinition changeOperationGroup = new SelectionGroupDefinition("changeOperationGroup", "Changeoperations", new SelectionDefinition[]{primaryPreSelection, primaryPostSelection});
    public static final String INSERT_ACTIONS = String.valueOf(ID) + "/InsertActions";
    public static final String BLOCK_ACTIONS = String.valueOf(ID) + "/BlockActions";
    public static final String DELETE_ACTIONS = String.valueOf(ID) + "/DeleteActions";
    public static final String DATA_ACTIONS = String.valueOf(ID) + "/DataActions";
    public static final String CONSTRAINT_ACTIONS = String.valueOf(ID) + "/ConstraintEdgeActions";
    public static final String MOVE_NODES_ACTIONS = String.valueOf(ID) + "/MoveNodesAction";
    public static final String MISC_ACTIONS = String.valueOf(ID) + "/Misc";
    protected final Logger logger;
    static CheckReport checkReport;
    private Map<String, ChangeOperationsGroup> groups = new LinkedHashMap<String, ChangeOperationsGroup>();
    private Editor currentEditor;
    protected UpdateManager updateManager;
    ScrolledForm scrollForm;

    public SelectionManager getSelectionManager() {
        return this.currentEditor != null ? this.currentEditor.getSelectionManager() : null;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    public ChangeOperationsView() {
        this.createDefaultChangeOperations();
        this.logger = LoggerTools.getLogger((Object)((Object)this));
        this.setUpdateManager(Activator.getService().getUpdateManager());
        this.updateManager.addListener(null, (ChangeListener)this);
    }

    private void createDefaultChangeOperations() {
        this.createActionsGroup(INSERT_ACTIONS, "Insert Elements");
        this.createActionsGroup(BLOCK_ACTIONS, "Insert Surrounding Block");
        this.createActionsGroup(DELETE_ACTIONS, "Delete Elements");
        this.createActionsGroup(MOVE_NODES_ACTIONS, "Move Nodes");
        this.createActionsGroup(CONSTRAINT_ACTIONS, "Constraint Edge");
        this.createActionsGroup(DATA_ACTIONS, "Data Manipulation");
        this.registerChangeOperationAction(INSERT_ACTIONS, InsertNodeAction.ID, new InsertNodeAction());
        this.registerChangeOperationAction(INSERT_ACTIONS, InsertBranchAction.ID, new InsertBranchAction());
        this.registerChangeOperationAction(INSERT_ACTIONS, InsertAndBlockAction.ID, new InsertAndBlockAction());
        this.registerChangeOperationAction(INSERT_ACTIONS, InsertOrBlockAction.ID, new InsertOrBlockAction());
        this.registerChangeOperationAction(INSERT_ACTIONS, InsertLoopBlockAction.ID, new InsertLoopBlockAction());
        this.registerChangeOperationAction(BLOCK_ACTIONS, CreateSurroundingAndBlockAction.ID, new CreateSurroundingAndBlockAction());
        this.registerChangeOperationAction(BLOCK_ACTIONS, CreateSurroundingOrBlockAction.ID, new CreateSurroundingOrBlockAction());
        this.registerChangeOperationAction(BLOCK_ACTIONS, CreateSurroundingLoopBlockAction.ID, new CreateSurroundingLoopBlockAction());
        this.registerChangeOperationAction(DELETE_ACTIONS, DeleteNodeAction.ID, new DeleteNodeAction());
        this.registerChangeOperationAction(DELETE_ACTIONS, DeleteBranchAction.ID, new DeleteBranchAction());
        this.registerChangeOperationAction(DELETE_ACTIONS, DeleteBorderNodesAction.ID, new DeleteBorderNodesAction());
        this.registerChangeOperationAction(CONSTRAINT_ACTIONS, InsertConstraintEdgeAction.ID, new InsertConstraintEdgeAction());
        this.registerChangeOperationAction(CONSTRAINT_ACTIONS, DeleteConstraintEdgeAction.ID, new DeleteConstraintEdgeAction());
        this.registerChangeOperationAction(MOVE_NODES_ACTIONS, MoveNodesAction.ID, new MoveNodesAction());
        this.registerChangeOperationAction(MOVE_NODES_ACTIONS, ExtractSubprocessAction.ID, new ExtractSubprocessAction());
        this.registerChangeOperationAction(DATA_ACTIONS, InsertDataElementAction.ID, new InsertDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, InsertDataAccessAction.ReadDataElementAction.ID, new InsertDataAccessAction.ReadDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, InsertDataAccessAction.WriteDataElementAction.ID, new InsertDataAccessAction.WriteDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, InsertDataAccessAction.SystemReadDataElementAction.ID, new InsertDataAccessAction.SystemReadDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, InsertDataAccessAction.SystemWriteDataElementAction.ID, new InsertDataAccessAction.SystemWriteDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, RemoveDataAccessAction.ID, new RemoveDataAccessAction());
        this.registerChangeOperationAction(DATA_ACTIONS, RemoveDataAccessAction.RemoveSystemDataAccessAction.ID, new RemoveDataAccessAction.RemoveSystemDataAccessAction());
        this.registerChangeOperationAction(DATA_ACTIONS, DeleteDataElementAction.ID, new DeleteDataElementAction());
        this.registerChangeOperationAction(DATA_ACTIONS, ToggleDataEdgeOptionalAttributeAction.ID, new ToggleDataEdgeOptionalAttributeAction());
        this.registerChangeOperationAction("No group", ToggleSyncAction.ID, new ToggleSyncAction());
        this.registerChangeOperationAction("No group", RemoveExecutableBusinessProcessAction.ID, new RemoveExecutableBusinessProcessAction());
    }

    public void registerChangeOperationAction(String groupID, String ID, ChangeOperationAction action) {
        if (this.groups.containsKey(groupID)) {
            ChangeOperationsGroup group = this.groups.get(groupID);
            group.addChangeOperationsAction(ID, action);
        } else {
            if (!this.groups.containsKey(MISC_ACTIONS)) {
                this.createActionsGroup(MISC_ACTIONS, "Miscellaneous");
            }
            ChangeOperationsGroup group = this.groups.get(MISC_ACTIONS);
            group.addChangeOperationsAction(ID, action);
        }
    }

    public void createActionsGroup(String groupID, String text) {
        if (!this.groups.containsKey(groupID)) {
            this.groups.put(groupID, new ChangeOperationsGroup(groupID, text));
        }
    }

    public void unregisterChangeOperationAction(String groupID, String ID) {
        if (this.groups.containsKey(groupID)) {
            this.groups.get(groupID).removeChangeOperationAction(ID);
        }
    }

    public void removeActionsGroup(String groupID) {
        if (this.groups.containsKey(groupID)) {
            this.groups.remove(groupID);
        }
    }

    public void createPartControl(Composite parent) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        formToolkit.setBackground(ColorConstants.button);
        this.scrollForm = formToolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.scrollForm.getBody().setLayout((Layout)layout);
        for (ChangeOperationsGroup group : this.groups.values()) {
            ExpandableComposite toolGroup = formToolkit.createExpandableComposite(this.scrollForm.getBody(), 66);
            toolGroup.setLayout((Layout)new GridLayout());
            toolGroup.setLayoutData((Object)new GridData(4, 128, true, false));
            toolGroup.setText(group.getText());
            toolGroup.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    ChangeOperationsView.this.scrollForm.reflow(true);
                }
            });
            Composite container = new Composite((Composite)toolGroup, 524288);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(4, 16384, true, true));
            toolGroup.setClient((Control)container);
            ToolBar hintToolBar = new ToolBar(container, 0x820200);
            ToolBar toolBar = new ToolBar(container, 0x820200);
            for (ChangeOperationAction action : group.getChangeOperationsActions()) {
                action.createToolItem(toolBar);
                action.createHintToolItem(hintToolBar);
            }
        }
        if (this.getSite().getPage() != null) {
            this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        }
        this.updateEditor();
    }

    private void updateEditor() {
        SelectionGroup grp;
        Editor oldEditor = this.currentEditor;
        boolean setActive = false;
        Editor editor = this.currentEditor = this.getSite().getPage().getActiveEditor() instanceof Editor ? (Editor)this.getSite().getPage().getActiveEditor() : null;
        if (oldEditor == this.currentEditor) {
            if (oldEditor != null) {
                return;
            }
            this.disableActions();
        }
        if (oldEditor != null && oldEditor.getSelectionManager() != null) {
            grp = oldEditor.getSelectionManager().getGroup(changeOperationGroup);
            SelectionGroup oldActiveGroup = oldEditor.getSelectionManager().getActiveGroup();
            this.removeSelectionChangedListeners(this.getSelectionManager());
            if (grp == oldActiveGroup) {
                setActive = true;
            }
        }
        if (this.currentEditor == null) {
            this.disableActions();
            this.setSelectionProvider(null);
            return;
        }
        if (this.getSelectionManager() != null) {
            grp = this.getSelectionManager().getGroup(changeOperationGroup);
            for (SelectionDefinition selDef : changeOperationGroup.getSelectionDefinitions()) {
                grp.getSelection(selDef).addSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (setActive || oldEditor == null) {
                this.getSelectionManager().setActiveGroup(changeOperationGroup);
            }
            this.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
        }
        this.updateActions();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateActions();
    }

    void updateActions() {
        if (this.getSelectionManager() == null) {
            this.disableActions();
            return;
        }
        Template model = null;
        Instance instance = null;
        if (this.currentEditor.getInstance() != null) {
            instance = this.currentEditor.getInstance();
        }
        if ((model = this.currentEditor.getTemplate()) instanceof ChangeableTemplate || instance instanceof ChangeableInstance) {
            SelectionGroup selGroup = this.getSelectionManager().getGroup(changeOperationGroup);
            Selection.SelectionList primStartList = (Selection.SelectionList)selGroup.getSelection(primaryPreSelection).getSelection();
            Selection.SelectionList primEndList = (Selection.SelectionList)selGroup.getSelection(primaryPostSelection).getSelection();
            URI base = ProcessElementIdentifierTools.getTemplateIdentifier((Template)model, (String)"localhost");
            checkReport = new CheckReport(base);
            Object graph = null;
            graph = instance != null ? (ChangeableInstance)instance : (ChangeableTemplate)model;
            for (ChangeOperationsGroup group : this.groups.values()) {
                for (ChangeOperationAction action : group.getChangeOperationsActions()) {
                    action.update((ChangePrimitives)graph, (List<IProcessEditPart>)primStartList, (List<IProcessEditPart>)primEndList, this.updateManager, checkReport);
                }
            }
        } else {
            this.disableActions();
            this.logger.info("Model is not an instance of ChangeableTemplate");
        }
    }

    private void disableActions() {
        if (this.groups != null) {
            for (ChangeOperationsGroup group : this.groups.values()) {
                for (ChangeOperationAction action : group.getChangeOperationsActions()) {
                    action.disable();
                }
            }
        }
    }

    public void setFocus() {
        if (this.getSelectionManager() != null) {
            this.getSelectionManager().setActiveGroup(changeOperationGroup);
        }
        this.scrollForm.setFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ChangeOperationsView.this.updateActions();
            }
        });
    }

    public static CheckReport getCheckReport() {
        return checkReport;
    }

    public void dispose() {
        this.updateManager.removeListener(null, (ChangeListener)this);
        for (ChangeOperationsGroup g : this.groups.values()) {
            g.dispose();
        }
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.removeSelectionChangedListeners(this.getSelectionManager());
        this.currentEditor = null;
        this.groups = null;
        super.dispose();
    }

    private void removeSelectionChangedListeners(SelectionManager selectionManager) {
        if (selectionManager == null) {
            return;
        }
        SelectionGroup grp = selectionManager.getGroup(changeOperationGroup);
        if (selectionManager.getActiveGroup() == grp) {
            selectionManager.setActiveGroup(null);
        }
        for (SelectionDefinition selDef : changeOperationGroup.getSelectionDefinitions()) {
            grp.getSelection(selDef).removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.getSelectionManager().removeGroup(changeOperationGroup);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateEditor();
    }

    protected void setSelectionProvider(ISelectionProvider provider) {
        this.getSite().setSelectionProvider(provider);
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    private class ChangeOperationsGroup {
        private String ID;
        private String text;
        private Map<String, ChangeOperationAction> actions = new LinkedHashMap<String, ChangeOperationAction>();

        public ChangeOperationsGroup(String ID, String text) {
            this.ID = ID;
            this.text = text;
        }

        public void addChangeOperationsAction(String ID, ChangeOperationAction action) {
            if (!this.actions.containsKey(ID)) {
                this.actions.put(ID, action);
            } else {
                ChangeOperationsView.this.logger.warning("Action ID already registered for this Group: " + ID);
            }
        }

        public Collection<ChangeOperationAction> getChangeOperationsActions() {
            return this.actions.values();
        }

        public void removeChangeOperationAction(String ID) {
            this.actions.remove(ID);
        }

        public String getText() {
            return this.text;
        }

        public String getID() {
            return this.ID;
        }

        public void dispose() {
            this.actions = null;
        }
    }
}

