/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class AddFileToProjectWizardPage
extends WizardPage {
    private Text containerText;
    private Text pathText;
    private ISelection selection;
    private static final String[] extensions = new String[]{"*.template", "*.instance", "*.*"};
    private String initialPath;

    public AddFileToProjectWizardPage(ISelection selection, String title, String description) {
        super("wizardPage");
        this.setTitle(title);
        this.setDescription(description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFileToProjectWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFileToProjectWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File:");
        this.pathText = new Text(container, 2052);
        gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFileToProjectWizardPage.this.dialogChanged();
            }
        });
        Button button2 = new Button(container, 8);
        button2.setText("Browse...");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFileToProjectWizardPage.this.openFile();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.pathText.setText("name");
        this.pathText.setFocus();
        this.pathText.selectAll();
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    void openFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Open file");
        if (this.initialPath != null) {
            dialog.setFilterPath(this.initialPath);
        }
        dialog.setFilterExtensions(extensions);
        if (dialog.open() != null) {
            String fileName = dialog.getFileName();
            this.initialPath = dialog.getFilterPath();
            if (fileName != null) {
                this.pathText.setText(String.valueOf(this.initialPath) + File.separator + fileName);
            }
        }
    }

    void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getPathValue();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        IContainer container2 = (IContainer)container;
        int index = fileName.replace('\\', '/').indexOf(47);
        String linkName = fileName.substring(index + 1);
        IFile iFile = container2.getFile((IPath)new Path(linkName));
        if (iFile.exists()) {
            this.updateStatus("File name already exists");
            return;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            this.updateStatus("File must exists");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    private String getPathValue() {
        return this.pathText.getText();
    }

    public String getFilePath() {
        return this.getPathValue();
    }

    public String getLinkName() {
        int index = this.getFilePath().replace('\\', '/').lastIndexOf(47);
        return this.getFilePath().substring(index + 1);
    }
}

