/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.client.ActivityManagerService;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataElementWizard
extends Wizard {
    private DataElementWizardPage page;
    protected final DataElement dataElement;
    protected DataElement newDataElement;
    protected final ChangeableTemplate template;
    protected final ChangeableInstance instance;
    private ProcessConstants.DataElementProperty[] changedProperties;

    public DataElementWizard(ChangeableInstance instance, DataElement dataElement) {
        this.instance = instance;
        this.template = null;
        this.dataElement = dataElement;
        this.setWindowTitle(this.getTitle());
    }

    public DataElementWizard(ChangeableTemplate template, DataElement dataElement) {
        this.template = template;
        this.instance = null;
        this.dataElement = dataElement;
        this.setWindowTitle(this.getTitle());
    }

    public DataElementWizard() {
        this((ChangeableTemplate)null, Activator.getAMService().getProcessModelFactory().createDataElement(Integer.MIN_VALUE, "", ProcessConstants.AdeptDataType.STRING, "", "", null, ProcessConstants.IDENTIFIER_NOT_SET, false, false, new HashMap(), new HashMap(), new HashMap()));
    }

    public void addPages() {
        super.addPages();
        this.page = new DataElementWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.newDataElement = Activator.getAMService().getProcessModelFactory().createDataElement(this.dataElement.getID(), this.page.txtName.getText(), ProcessConstants.AdeptDataType.valueOf((String)this.page.cmbType.getText()), this.page.txtDesc.getText(), this.page.txtUDT.getText(), null, this.page.currentIdentifierID, this.page.chkPublic.getSelection(), this.page.chkVirtual.getSelection(), this.dataElement.getSupportedPlugins(), this.dataElement.getPluginDatas(), this.dataElement.getUserAttributes());
        this.storeChangedProperties();
        return true;
    }

    public DataElement getDataElement() {
        if (this.page != null) {
            return this.newDataElement;
        }
        return null;
    }

    private void storeChangedProperties() {
        ProcessConstants.AdeptDataType newType;
        if (this.page == null) {
            this.changedProperties = new ProcessConstants.DataElementProperty[0];
        }
        HashSet<ProcessConstants.DataElementProperty> res = new HashSet<ProcessConstants.DataElementProperty>();
        if (!this.page.txtName.getText().equals(this.dataElement.getName())) {
            res.add(ProcessConstants.DataElementProperty.NAME);
        }
        if ((newType = ProcessConstants.AdeptDataType.valueOf((String)this.page.cmbType.getText())) != this.dataElement.getDataType()) {
            res.add(ProcessConstants.DataElementProperty.TYPE);
        }
        if (!this.page.txtDesc.getText().equals(this.dataElement.getDescription())) {
            res.add(ProcessConstants.DataElementProperty.DESCRIPTION);
        }
        if (this.page.txtUDT.getText().length() > 0 && !this.page.txtUDT.getText().equals(this.dataElement.getUDTName())) {
            res.add(ProcessConstants.DataElementProperty.USER_DEFINED_TYPE);
        }
        if (!this.page.currentIdentifierID.equals(this.dataElement.getIdentifierID())) {
            res.add(ProcessConstants.DataElementProperty.IDENTIFIER);
        }
        if (this.page.chkPublic.getSelection() != this.dataElement.isPublic()) {
            res.add(ProcessConstants.DataElementProperty.PUBLIC);
        }
        if (this.page.chkVirtual.getSelection() != this.dataElement.isVirtual()) {
            res.add(ProcessConstants.DataElementProperty.VIRTUAL);
        }
        this.changedProperties = res.toArray(new ProcessConstants.DataElementProperty[res.size()]);
    }

    public ProcessConstants.DataElementProperty[] getChangedProperties() {
        return this.changedProperties;
    }

    protected String getTitle() {
        if (this.dataElement.getID() == Integer.MIN_VALUE) {
            return "Create new Data Element";
        }
        return String.format("Change Data Element '%s'", this.dataElement.getName());
    }

    public static void openForChanging(Shell parentShell, ChangeableTemplate template, ChangeableInstance instance, UpdateManager updateManager, DataElement dataElement, SessionToken session) {
        if (instance == null && template == null || instance != null && template != null) {
            throw new IllegalArgumentException("Either an instance xor a template must be provided!");
        }
        DataElementWizard dataElementWizard = instance != null ? new DataElementWizard(instance, dataElement) : new DataElementWizard(template, dataElement);
        WizardDialog wizardDialog = new WizardDialog(parentShell, (IWizard)dataElementWizard);
        if (wizardDialog.open() == 0) {
            DataElement newDataElement = dataElementWizard.getDataElement();
            ProcessConstants.DataElementProperty[] changedProps = dataElementWizard.getChangedProperties();
            CheckReport checkReport = DataElementWizard.getCheckReport(template, instance);
            String transactionLabel = String.format("Change Data Element '%s'", newDataElement.getName());
            if (instance != null && UpdateDataElement.isPossible((ChangeableInstance)instance, (DataElement)newDataElement, (CheckReport)checkReport, (ProcessConstants.DataElementProperty[])changedProps)) {
                StartTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)updateManager);
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)instance, (DataElement)newDataElement, (UpdateManager)updateManager, (ProcessConstants.DataElementProperty[])changedProps);
                EndTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)updateManager, (String)transactionLabel);
            } else if (template != null && UpdateDataElement.isPossible((Template)template, (DataElement)newDataElement, (CheckReport)checkReport, (ProcessConstants.DataElementProperty[])changedProps)) {
                StartTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager);
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)template, (DataElement)newDataElement, (UpdateManager)updateManager, (ProcessConstants.DataElementProperty[])changedProps);
                EndTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager, (String)transactionLabel);
            }
        }
    }

    public static void openForNew(Shell parentShell, ChangeableTemplate template, ChangeableInstance instance, UpdateManager updateManager, SessionToken session) {
        if (instance == null && template == null || instance != null && template != null) {
            throw new IllegalArgumentException("Either an instance xor a template must be provided!");
        }
        DataElementWizard dataElementWizard = new DataElementWizard();
        WizardDialog wizardDialog = new WizardDialog(parentShell, (IWizard)dataElementWizard);
        if (wizardDialog.open() == 0) {
            DataElement newDataElement = dataElementWizard.getDataElement();
            CheckReport checkReport = DataElementWizard.getCheckReport(template, instance);
            String transactionLabel = String.format("Adding Data Element '%s'", newDataElement.getName());
            if (instance != null && InsertDataElement.isPossible((ChangeableInstance)instance, (DataElement)newDataElement, (CheckReport)checkReport)) {
                StartTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)updateManager);
                InsertDataElement.performOperation((SessionToken)session, (ChangeableInstance)instance, (DataElement)newDataElement, (UpdateManager)updateManager);
                EndTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)updateManager, (String)transactionLabel);
            } else if (template != null && InsertDataElement.isPossible((Template)template, (DataElement)newDataElement, (CheckReport)checkReport)) {
                StartTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager);
                InsertDataElement.performOperation((SessionToken)session, (ChangeableTemplate)template, (DataElement)newDataElement, (UpdateManager)updateManager);
                EndTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager, (String)transactionLabel);
            }
        }
    }

    private static CheckReport getCheckReport(ChangeableTemplate template, ChangeableInstance instance) {
        CheckReport checkReport = instance != null ? new CheckReport(ProcessElementIdentifierTools.getInstanceIdentifier((String)"localhost", (Instance)instance)) : new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost"));
        return checkReport;
    }

    protected class DataElementWizardPage
    extends WizardPage {
        protected Text txtName;
        protected Text txtDesc;
        protected Text txtUDT;
        protected Combo cmbType;
        protected Text txtIdentifier;
        protected UUID currentIdentifierID;
        protected Button chkVirtual;
        protected Button chkPublic;

        protected DataElementWizardPage() {
            super("DataElementWizardPage");
            String myTitle = DataElementWizard.this.getTitle();
            String myDescription = DataElementWizard.this.dataElement.getID() == Integer.MIN_VALUE ? "Create a new Data Element for the Process." : String.format("Change Data Element '%s' for the Process.", DataElementWizard.this.dataElement.getName());
            this.setTitle(myTitle);
            this.setDescription(myDescription);
            this.currentIdentifierID = DataElementWizard.this.dataElement.getIdentifierID();
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            Label lblName = new Label(container, 0);
            lblName.setText("Name");
            this.txtName = new Text(container, 2048);
            this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.txtName.setText(DataElementWizard.this.dataElement.getName());
            ModifyListener defaultModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DataElementWizardPage.this.updateComplete();
                }
            };
            this.txtName.addModifyListener(defaultModifyListener);
            this.txtName.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.NAME));
            Label lblDesc = new Label(container, 0);
            lblDesc.setLayoutData((Object)new GridData(-1, 128, false, false));
            lblDesc.setText("Description");
            this.txtDesc = new Text(container, 2112);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.heightHint = 100;
            this.txtDesc.setLayoutData((Object)gridData);
            this.txtDesc.setText(DataElementWizard.this.dataElement.getDescription());
            this.txtDesc.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.DESCRIPTION));
            Label lblType = new Label(container, 0);
            lblType.setText("Data Type");
            this.cmbType = new Combo(container, 8);
            ProcessConstants.AdeptDataType[] typeValues = ProcessConstants.AdeptDataType.values();
            String[] types = new String[typeValues.length];
            int selected = -1;
            int i = 0;
            while (i < types.length) {
                types[i] = typeValues[i].name();
                if (typeValues[i] == DataElementWizard.this.dataElement.getDataType()) {
                    selected = i;
                }
                ++i;
            }
            this.cmbType.setVisibleItemCount(typeValues.length);
            this.cmbType.setItems(types);
            this.cmbType.select(selected);
            this.cmbType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataElementWizardPage.this.updateComplete();
                }
            });
            this.cmbType.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.TYPE));
            Label lblUDT = new Label(container, 0);
            lblUDT.setText("UDT Name");
            this.txtUDT = new Text(container, 2048);
            if (DataElementWizard.this.dataElement.getUDTName() != null) {
                this.txtUDT.setText(DataElementWizard.this.dataElement.getUDTName());
            }
            this.txtUDT.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.txtUDT.addModifyListener(defaultModifyListener);
            this.txtUDT.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.USER_DEFINED_TYPE));
            Label lblIdentifier = new Label(container, 0);
            lblIdentifier.setText("Identifier");
            Composite identifierContainer = new Composite(container, 0);
            identifierContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            identifierContainer.setLayout((Layout)layout);
            this.txtIdentifier = new Text(identifierContainer, 2048);
            this.txtIdentifier.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.txtIdentifier.setText(this.getIdentifierName(this.currentIdentifierID));
            this.txtIdentifier.setEditable(false);
            Button btnIdentifier = new Button(identifierContainer, 8);
            btnIdentifier.setLayoutData((Object)new GridData(4, 4, false, false));
            btnIdentifier.setText("...");
            btnIdentifier.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ActivityManagerService service = Activator.getAMService();
                    Collection identifiers = service.getActivityRepository().getIdentifierManager().getLatestIdentifiers(service.getSessionToken(), true);
                    SelectIdentifierDialogue dialogue = new SelectIdentifierDialogue(service.getSessionToken(), DataElementWizardPage.this.txtIdentifier.getShell(), Activator.getPluginID(), identifiers, service.getFilterFactory(), DataElementWizardPage.this.currentIdentifierID, true, null);
                    if (dialogue.open() == 0) {
                        UUID newID = dialogue.getIdentifier().getID();
                        DataElementWizardPage.this.currentIdentifierID = newID != null ? newID : ProcessConstants.IDENTIFIER_NOT_SET;
                        DataElementWizardPage.this.txtIdentifier.setText(DataElementWizardPage.this.getIdentifierName(DataElementWizardPage.this.currentIdentifierID));
                    }
                }
            });
            btnIdentifier.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.IDENTIFIER));
            Label lblPublic = new Label(container, 0);
            lblPublic.setText("Public");
            this.chkPublic = new Button(container, 32);
            this.chkPublic.setSelection(DataElementWizard.this.dataElement.isPublic());
            this.chkPublic.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.PUBLIC));
            this.setControl((Control)container);
            Label lblVirtual = new Label(container, 0);
            lblVirtual.setText("Virtual");
            this.chkVirtual = new Button(container, 32);
            this.chkVirtual.setSelection(DataElementWizard.this.dataElement.isVirtual());
            this.chkVirtual.setEnabled(this.isPossible(ProcessConstants.DataElementProperty.VIRTUAL));
            this.updateComplete();
        }

        protected String getIdentifierName(UUID identifierID) {
            if (identifierID.equals(ProcessConstants.IDENTIFIER_NOT_SET)) {
                return "(not set)";
            }
            try {
                Identifier identifier = Activator.getAMService().getActivityRepository().getIdentifierManager().getLatestIdentifier(Activator.getAMService().getSessionToken(), identifierID);
                return identifier.getName();
            }
            catch (UnknownEntityException unknownEntityException) {
                return identifierID.toString();
            }
        }

        protected boolean isPossible(ProcessConstants.DataElementProperty prop) {
            if (DataElementWizard.this.instance != null) {
                return UpdateDataElement.isPossible((ChangeableInstance)DataElementWizard.this.instance, (DataElement)DataElementWizard.this.dataElement, (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{prop});
            }
            if (DataElementWizard.this.template != null) {
                return UpdateDataElement.isPossible((Template)DataElementWizard.this.template, (DataElement)DataElementWizard.this.dataElement, (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{prop});
            }
            return true;
        }

        protected void updateComplete() {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            if (this.txtName.getText().equals("")) {
                this.setErrorMessage("The name must not be empty.");
                this.setPageComplete(false);
                return;
            }
            if (this.cmbType.getText().equals(ProcessConstants.AdeptDataType.USERDEFINED.name())) {
                this.txtUDT.setEnabled(true);
                if (this.txtUDT.getText().equals("")) {
                    this.setErrorMessage("The UDT Name must be set.");
                    this.setPageComplete(false);
                    return;
                }
            } else {
                if (this.txtUDT.getText().length() > 0) {
                    this.txtUDT.setText("");
                }
                this.txtUDT.setEnabled(false);
            }
        }
    }
}

