/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards;

import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectWizard
extends Wizard
implements IExecutableExtension,
INewWizard {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".wizards.NewProjectWizard";
    private WizardNewProjectCreationPage mainPage;
    private IConfigurationElement configElement;
    private IProject newProject;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    protected static final Logger logger = LoggerTools.getLogger(NewProjectWizard.class);

    public NewProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Create new AristaFlow Project");
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("EclipseSpeedo.SpeedoNewProject");
        this.mainPage.setTitle("Create new AristaFlow Project");
        this.mainPage.setDescription("Create an AristaFlow project in the workspace or in an external location.");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.createNewProject();
        this.updatePerspective();
        return true;
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                ((CoreException)t).getStatus().getCode();
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configElement = config;
    }

    protected void updatePerspective() {
        NewProjectWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        IPerspectiveDescriptor currentPersp;
        IWorkbenchPage page;
        if (configElement == null) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp == null) {
            logger.warning("Unable to find perspective " + finalPerspId);
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (currentPersp = page.getPerspective()) != null && finalPerspId.equals(currentPersp.getId())) {
            return;
        }
        NewProjectWizard.replaceCurrentPerspective(finalPersp);
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

