/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.NewTemplateWizardPage;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewTemplateWizard
extends Wizard
implements INewWizard {
    private NewTemplateWizardPage page;
    private ISelection selection;
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".wizards.NewTemplateWizard";

    public NewTemplateWizard() {
        this.setWindowTitle("Create new AristaFlow Template");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewTemplateWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final String templateName = this.page.getTemplateName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewTemplateWizard.this.doFinish(containerName, fileName, templateName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getCause();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An Exception occurred while creating the File:\n" + realException.getMessage()));
            return false;
        }
        return true;
    }

    void doFinish(String containerName, String fileName, String templateName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Status status = new Status(4, Activator.getPluginID(), 0, "Container \"" + containerName + "\" does not exist.", null);
            throw new CoreException((IStatus)status);
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(templateName);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
        }
        catch (XMLFormatException xMLFormatException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(String name) throws XMLFormatException, IOException {
        ProcessModelFactory factory = Activator.getService().getProcessModelFactory();
        factory.setCreateChangeable(true);
        QualifiedAgent supervisorAgent = Activator.getService().getActiveAgent().getQualifiedAgent();
        Template template = factory.createNullTemplate(supervisorAgent);
        ((ChangeableTemplate)template).setName(name);
        ProcessModelXMLExport export = new ProcessModelXMLExport();
        return export.getInputStreamForTemplate(template);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

