/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.ui.i18n.DialogTextCellEditor;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.StringBasedComboBoxCellEditor;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ConfigurationEditingTable {
    protected Table table;
    protected TableViewer viewer;
    protected MapContentProvider contentProvider;
    protected Composite topLevelContainer;
    protected Button addButton;
    protected Button removeButton;
    protected ChangeableActivityConfiguration activityConfiguration;
    protected CellEditor keyEditor;
    protected StyledText descriptionText;
    protected ConfigurationDescription configurationDescription;

    public ConfigurationEditingTable(Composite parent, String keyTitle, String valueTitle, boolean useAddRemoveUI, boolean showDescription) {
        this.topLevelContainer = new Composite(parent, 0);
        this.topLevelContainer.setLayout((Layout)new GridLayout(2, true));
        this.table = new Table(this.topLevelContainer, 68096);
        this.table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).span(2, 1).hint(100, 125).create());
        this.table.setHeaderVisible(true);
        TableColumn col1 = new TableColumn(this.table, 16384);
        TableColumn col2 = new TableColumn(this.table, 16384);
        col1.setText(keyTitle);
        col2.setText(valueTitle);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        this.table.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(this.table);
        this.contentProvider = new MapContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new MapCellModifier());
        StringBasedComboBoxCellEditor comboCellEditor = new StringBasedComboBoxCellEditor((Composite)this.table, new String[0], 0x800000);
        comboCellEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CCombo combo = (CCombo)e.getSource();
                ConfigurationEditingTable.this.updateDescription(combo.getText());
            }
        });
        this.keyEditor = comboCellEditor;
        this.keyEditor.setValidator((ICellEditorValidator)new KeyCellEditorValidator(this.viewer));
        this.viewer.setCellEditors(new CellEditor[]{this.keyEditor, new DialogTextCellEditor((Composite)this.table)});
        this.viewer.setColumnProperties(new String[]{"key", "value"});
        this.viewer.setSorter((ViewerSorter)new MapViewerSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ConfigurationEditingTable.this.removeButton.setEnabled(true);
                } else {
                    ConfigurationEditingTable.this.removeButton.setEnabled(false);
                }
                ConfigurationEditingTable.this.updateDescription();
            }
        });
        if (showDescription) {
            this.descriptionText = new StyledText(this.topLevelContainer, 2634);
            this.descriptionText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).hint(150, 100).create());
            this.descriptionText.setEditable(false);
        }
        if (useAddRemoveUI) {
            this.addButton = new Button(this.topLevelContainer, 8);
            this.addButton.setText("Add");
            this.addButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationEditingTable.this.putEntry("", "");
                }
            });
            this.removeButton = new Button(this.topLevelContainer, 8);
            this.removeButton.setText("Remove");
            this.removeButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.removeButton.setEnabled(false);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationEditingTable.this.removeEntry(ConfigurationEditingTable.this.getSelectedEntry());
                }
            });
        }
    }

    public void reloadMap() {
        this.viewer.setInput((Object)this.activityConfiguration);
    }

    public Table getTable() {
        return this.table;
    }

    public Control getToplevelControl() {
        return this.topLevelContainer;
    }

    public ChangeableActivityConfiguration getConfiguration() {
        return this.activityConfiguration;
    }

    public void setConfiguration(ChangeableActivityConfiguration configuration) {
        this.activityConfiguration = configuration;
        this.reloadMap();
    }

    public void putEntry(String key, String value) {
        TableMapEntry entry = this.contentProvider.addMapping(key, value);
        if (entry == null) {
            MessageDialog.openWarning((Shell)this.table.getShell(), (String)"Add item", (String)"The given item cannot be added because another item with the same key already exists!");
            return;
        }
        this.viewer.editElement((Object)entry, 0);
    }

    public void removeEntry(TableMapEntry entry) {
        this.contentProvider.removeMapping(entry);
    }

    public TableMapEntry getSelectedEntry() {
        return (TableMapEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void commitEdits() {
    }

    public ConfigurationDescription getConfigurationDescription() {
        return this.configurationDescription;
    }

    public void setConfigurationDescription(ConfigurationDescription configurationDescription) {
        this.configurationDescription = configurationDescription;
        if (this.keyEditor instanceof ComboBoxCellEditor) {
            Object[] items = configurationDescription.getEntries().keySet().toArray(new String[0]);
            Arrays.sort(items);
            ((ComboBoxCellEditor)this.keyEditor).setItems((String[])items);
            ((CCombo)this.keyEditor.getControl()).setVisibleItemCount(Math.max(items.length, 1));
        }
        this.updateDescription();
    }

    public void updateDescription() {
        if (this.descriptionText != null) {
            TableMapEntry selItem = this.getSelectedEntry();
            if (selItem != null) {
                String key = selItem.getKey();
                this.updateDescription(key);
            } else {
                this.descriptionText.setText("");
            }
        }
    }

    protected void updateDescription(String description) {
        String desc = null;
        if (this.configurationDescription != null && this.configurationDescription.getEntries().containsKey(description)) {
            desc = ((ConfigurationDescription.ConfigurationEntry)this.configurationDescription.getEntries().get(description)).getDescription();
        }
        if (desc == null) {
            desc = "No description available.";
        }
        this.descriptionText.setText(description + ":\n" + desc);
        this.descriptionText.setStyleRanges(new StyleRange[]{new StyleRange(0, description.length(), null, null, 1)});
    }

    protected static class KeyCellEditorValidator
    implements ICellEditorValidator {
        protected TableViewer viewer;

        public KeyCellEditorValidator(TableViewer viewer) {
            this.viewer = viewer;
        }

        public String isValid(Object value) {
            if (value == null) {
                return "Invalid value: null";
            }
            TableMapEntry currentEntry = (TableMapEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            ActivityConfiguration map = (ActivityConfiguration)this.viewer.getInput();
            if (map.getAllEntries().contains(value) && !value.equals(currentEntry.getKey())) {
                return "The key already exists.";
            }
            return null;
        }
    }

    protected static class MapCellModifier
    implements ICellModifier {
        protected MapCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals("key") || property.equals("value");
        }

        public Object getValue(Object element, String property) {
            if (property.equals("key")) {
                return ((TableMapEntry)element).getKey();
            }
            if (property.equals("value")) {
                return ((TableMapEntry)element).getValue();
            }
            return null;
        }

        public void modify(Object origElement, String property, Object value) {
            Object element = origElement;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (value == null) {
                return;
            }
            if (property.equals("key")) {
                ((TableMapEntry)element).setKey((String)value);
            } else if (property.equals("value")) {
                ((TableMapEntry)element).setValue((String)value);
            }
        }
    }

    protected static class MapContentProvider
    implements IStructuredContentProvider {
        protected TableViewer parent;
        protected ChangeableActivityConfiguration configuration;

        public MapContentProvider(TableViewer parent) {
            this.parent = parent;
        }

        public Object[] getElements(Object inputElement) {
            this.configuration = (ChangeableActivityConfiguration)inputElement;
            Object[] rv = new Object[this.configuration.getAllEntries().size()];
            int idx = -1;
            for (String key : this.configuration.getAllEntries()) {
                TableMapEntry newEntry = new TableMapEntry(this.configuration, key, this.parent);
                rv[++idx] = newEntry;
            }
            return rv;
        }

        public void removeMapping(TableMapEntry entry) {
            this.parent.remove((Object)entry);
            this.configuration.remove(entry.getKey());
        }

        public TableMapEntry addMapping(String key, String value) {
            if (this.configuration.getAllEntries().contains(key)) {
                return null;
            }
            this.configuration.setString(key, value);
            TableMapEntry newEntry = new TableMapEntry(this.configuration, key, this.parent);
            this.parent.add((Object)newEntry);
            return newEntry;
        }

        public TableViewer getViewer() {
            return this.parent;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class MapLabelProvider
    implements ITableLabelProvider {
        protected MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text;
            TableMapEntry entry = (TableMapEntry)element;
            switch (columnIndex) {
                case 0: {
                    text = entry.getKey();
                    break;
                }
                case 1: {
                    text = entry.getValue();
                    break;
                }
                default: {
                    text = null;
                }
            }
            return text == null ? null : text.toString();
        }

        public boolean isLabelProperty(Object element, String property) {
            return property.equals("key") || property.equals("value");
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    protected static class MapViewerSorter
    extends ViewerSorter {
        protected MapViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((TableMapEntry)e1).getKey().compareTo(((TableMapEntry)e2).getKey());
        }
    }

    public static class TableMapEntry {
        protected ChangeableActivityConfiguration configuration;
        protected String key;
        protected TableViewer viewer;

        protected TableMapEntry(ChangeableActivityConfiguration configuration, String key, TableViewer viewer) {
            this.configuration = configuration;
            this.key = key;
            this.viewer = viewer;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String newKey) {
            if (!this.key.equals(newKey)) {
                String oldValue = this.configuration.getString(this.key);
                this.configuration.setString(newKey, oldValue);
                this.configuration.remove(this.key);
                this.key = newKey;
                this.viewer.update((Object)this, null);
            }
        }

        public String getValue() {
            return this.configuration.getString(this.key);
        }

        public void setValue(String newValue) {
            this.configuration.setString(this.key, newValue);
            this.viewer.update((Object)this, new String[]{"value"});
        }
    }
}

