/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DataElementSelectionDialogue
extends TitleAreaDialog {
    private Collection<DataElement> dataElements;
    private boolean multiSelection;
    ListUIComponent list;
    private DataElement[] selectedDataElements = null;

    public DataElementSelectionDialogue(Shell parentShell, Collection<DataElement> dataElements, boolean multiSelection) {
        super(parentShell);
        ArgChecks.checkForNulls(dataElements, (String)"dataElements");
        ArgChecks.checkSize(dataElements, (int)1, (String)"dataElements");
        this.dataElements = new ArrayList<DataElement>(dataElements);
        this.multiSelection = multiSelection;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Choose Data Element");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Choose Data Element(s)");
        this.setMessage("Choose the data element(s) to which the new process parameter(s) will be connected.");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite dialogArea = new Composite(container, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(200);
        dialogArea.setLayoutData((Object)layoutData);
        dialogArea.setLayout((Layout)new MigLayout("wrap, insets dialog", "[grow, fill]", "[grow, fill]"));
        this.list = new ListUIComponent(dialogArea, 0x10B00 | (this.multiSelection ? 2 : 0)){

            protected void registerColumns() {
                this.registerColumn("name", "Name", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((DataElement)element).getName();
                    }
                }, null);
                this.registerColumn("dataType", "Data Type", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        DataElement dataElement = (DataElement)element;
                        ProcessConstants.AdeptDataType dataType = dataElement.getDataType();
                        String dataTypeString = dataType == ProcessConstants.AdeptDataType.USERDEFINED ? "UDT: " + dataElement.getUDTName() : dataType.toString();
                        return dataTypeString;
                    }
                }, null);
                this.registerColumn("description", "Description", 0, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((DataElement)element).getDescription();
                    }
                }, null);
                this.initColumns(null, null, "name", true);
            }
        };
        this.list.getColumnControl().setLayoutData((Object)"w 100lp:200lp, h 100lp:300lp");
        this.list.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)DataElementSelectionDialogue.this.list.getColumnViewer().getSelection()).size() == 1) {
                    DataElementSelectionDialogue.this.okPressed();
                }
            }
        });
        this.list.setInput(this.dataElements);
        return container;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.list.getColumnViewer().getSelection();
        this.selectedDataElements = selection.toList().toArray(new DataElement[selection.size()]);
        super.okPressed();
    }

    public DataElement getSelectedDataElement() {
        if (this.selectedDataElements != null) {
            return this.selectedDataElements[0];
        }
        return null;
    }

    public DataElement[] getSelectedDataElements() {
        if (this.selectedDataElements != null) {
            return (DataElement[])this.selectedDataElements.clone();
        }
        return null;
    }
}

