/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ActivityManagerService;
import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfigurationDescription;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ConfigurationEditingTable;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ParameterConfigurationDialog;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DefaultParameterConfigurationDialog
extends ParameterConfigurationDialog {
    protected Text nameInput;
    protected Text descriptionInput;
    protected ComboViewer dataTypeInput;
    protected Text udtNameInput;
    protected Text identifierText;
    protected Button identifierInput;
    protected Button isOptionalInput;
    protected Button isVirtualInput;
    protected ConfigurationEditingTable activityConfigEditor;

    public DefaultParameterConfigurationDialog(Shell parent, EBPPnPWizardData data, ActivityConstants.AccessType accessType) {
        super(parent, data, accessType);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setLayout((Layout)new MigLayout("insets dialog, wrap", "[grow, fill, 10:300lp]", "[] 10lp"));
        Composite basicInputArea = this.createBasicInputArea(dialogArea);
        basicInputArea.setLayoutData((Object)"w 10:");
        Composite miscInputArea = this.createMiscInputArea(dialogArea);
        miscInputArea.setLayoutData((Object)"w 10:");
        Composite actTypeConfInputArea = this.createParameterConfigurationInputArea(dialogArea);
        actTypeConfInputArea.setLayoutData((Object)"w 10:, pushy, growy");
        return dialogArea;
    }

    protected Composite createBasicInputArea(Composite parent) {
        Composite basicInputArea = new Composite(parent, 0);
        basicInputArea.setLayout((Layout)new MigLayout("insets 0, wrap", "[]10lp[grow, fill]"));
        this.createNameInput(basicInputArea);
        this.createDescriptionInput(basicInputArea);
        this.createDataTypeInput(basicInputArea);
        return basicInputArea;
    }

    protected void createNameInput(Composite parent) {
        new Label(parent, 0).setText("Name:");
        this.nameInput = new Text(parent, 2048);
        this.nameInput.setLayoutData((Object)"w 10:");
        this.nameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (!text.getText().equals("")) {
                    DefaultParameterConfigurationDialog.this.getButton(0).setEnabled(true);
                } else {
                    DefaultParameterConfigurationDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
    }

    protected void createDescriptionInput(Composite parent) {
        new Label(parent, 0).setText("Description:");
        this.descriptionInput = new Text(parent, 2048);
        this.descriptionInput.setLayoutData((Object)"w 10:");
    }

    protected void createDataTypeInput(Composite parent) {
        new Label(parent, 0).setText("Data type:");
        this.dataTypeInput = new ComboViewer(parent, 2056);
        this.dataTypeInput.getCombo().setLayoutData((Object)"growx");
        this.dataTypeInput.add((Object[])ProcessConstants.AdeptDataType.values());
        this.dataTypeInput.getCombo().setVisibleItemCount(this.dataTypeInput.getCombo().getItemCount());
        final Label udtLabelInput = new Label(parent, 0);
        udtLabelInput.setText("User defined type:");
        this.udtNameInput = new Text(parent, 2048);
        this.udtNameInput.setLayoutData((Object)"growx, w 10:");
        this.udtNameInput.setEnabled(false);
        udtLabelInput.setEnabled(false);
        this.dataTypeInput.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                boolean enableUDT = selection != null && selection == ProcessConstants.AdeptDataType.USERDEFINED;
                udtLabelInput.setEnabled(enableUDT);
                DefaultParameterConfigurationDialog.this.udtNameInput.setEnabled(enableUDT);
            }
        });
        new Label(parent, 0).setText("Identifier:");
        this.identifierText = new Text(parent, 2056);
        this.identifierText.setLayoutData((Object)"split 2, growx, w 10:");
        this.identifierInput = new Button(parent, 0);
        this.identifierInput.setText("...");
        this.identifierInput.setLayoutData((Object)"growy");
        this.identifierInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityManagerService cs = Activator.getAMService();
                SessionToken session = cs.getSessionToken();
                Collection identifiers = cs.getActivityRepository().getIdentifierManager().getLatestIdentifiers(cs.getSessionToken(), true);
                SelectIdentifierDialogue dia = new SelectIdentifierDialogue(session, DefaultParameterConfigurationDialog.this.getShell(), Activator.getPluginID(), identifiers, cs.getFilterFactory(), DefaultParameterConfigurationDialog.this.identifierID, false, null);
                if (dia.open() == 0) {
                    DefaultParameterConfigurationDialog.this.identifierID = dia.getIdentifier().getID();
                    DefaultParameterConfigurationDialog.this.identifierText.setText(dia.getIdentifier().getName());
                }
            }
        });
    }

    protected Composite createMiscInputArea(Composite parent) {
        Composite miscInputArea = new Composite(parent, 0);
        miscInputArea.setLayout((Layout)new MigLayout("insets 0, wrap", "[fill]"));
        this.createOptionalInput(miscInputArea);
        this.createVirtualInput(miscInputArea);
        return miscInputArea;
    }

    protected void createOptionalInput(Composite parent) {
        this.isOptionalInput = new Button(parent, 32);
        this.isOptionalInput.setText("Optional");
        this.isOptionalInput.setToolTipText("If an input parameter is optional the process step uses the input data if it is available, but can also handle null values. An optional output parameter may be written by a process step, the step is not required to do.");
    }

    protected void createVirtualInput(Composite parent) {
        this.isVirtualInput = new Button(parent, 32);
        this.isVirtualInput.setText("Virtual");
        this.isVirtualInput.setToolTipText("If a parameter is virtual, the data of this parameter is not part of the data flow of the process, ie. the parameter does not read or write data from or to the process. Virtual parameters are used to model data flows which use e.g. data bases or other backends not controlled by the process management system but require process steps to be executedin a distinct order.");
    }

    protected Composite createParameterConfigurationInputArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new MigLayout("insets 0, wrap", "[grow, fill]"));
        Label atcLabel = new Label(area, 0);
        atcLabel.setText("Activity configuration:");
        this.activityConfigEditor = new ConfigurationEditingTable(area, "Name", "Value", true, true);
        this.activityConfigEditor.getToplevelControl().setLayoutData((Object)"w 10:, h 200lp:, pushy, growy");
        ConfigurationDescription confDesc = null;
        if (this.parameterTemplate != null) {
            confDesc = this.parameterTemplate.getConfigurationDescription();
        } else if (this.editedParameter != null && this.data.getActivityTemplate() != null) {
            List<String> templateNames = this.getDefaultParameterTemplateOrigins();
            String paramOrigin = this.editedParameter.getUserAttributeValue("fromParameter");
            if (paramOrigin != null) {
                ATParameter parameter = this.data.getActivityTemplate().getParameter(paramOrigin, this.accessType);
                if (parameter != null) {
                    confDesc = parameter.getConfigurationDescription();
                }
            } else {
                String paramTemplateOrigin = this.editedParameter.getUserAttributeValue("fromParameterTemplate");
                if (paramTemplateOrigin != null) {
                    templateNames.add(0, paramTemplateOrigin);
                }
                ATParameterTemplate template = null;
                for (String paramTemplateName : templateNames) {
                    template = (ATParameterTemplate)this.data.getActivityTemplate().getParameterTemplates().get(paramTemplateName);
                    if (template != null) break;
                }
                if (template != null) {
                    confDesc = template.getConfigurationDescription();
                }
            }
        }
        if (confDesc == null) {
            confDesc = new DefaultConfigurationDescription();
        }
        if (this.data.getActivityTemplate() != null) {
            this.activityConfigEditor.setConfigurationDescription(confDesc);
        }
        return area;
    }

    private List<String> getDefaultParameterTemplateOrigins() {
        ArrayList<String> result = new ArrayList<String>(4);
        String accessType = this.accessType == ActivityConstants.AccessType.READ ? "Input" : "Output";
        String dataType = this.dataType.toString();
        result.add(String.format("Default.%s.%s", accessType, dataType));
        result.add(String.format("Default.%s", accessType));
        result.add(String.format("Default.%s", dataType));
        result.add("Default");
        return result;
    }

    @Override
    protected void updateFromValues() {
        if (this.nameInput != null) {
            this.nameInput.setText(this.name);
        }
        if (this.descriptionInput != null) {
            this.descriptionInput.setText(this.description);
        }
        if (this.dataTypeInput != null) {
            String identifierName;
            this.dataTypeInput.setSelection((ISelection)new StructuredSelection((Object)this.dataType));
            this.udtNameInput.setText(this.udtName == null ? "" : this.udtName);
            try {
                identifierName = Activator.getAMService().getActivityRepository().getIdentifierManager().getLatestIdentifier(Activator.getAMService().getSessionToken(), this.identifierID).getName();
            }
            catch (UnknownEntityException unknownEntityException) {
                identifierName = this.identifierID.toString();
            }
            this.identifierText.setText(identifierName);
        }
        if (this.isOptionalInput != null) {
            this.isOptionalInput.setSelection(this.isOptional);
        }
        if (this.isVirtualInput != null) {
            this.isVirtualInput.setSelection(this.isVirtual);
        }
        if (this.activityConfigEditor != null) {
            this.activityConfigEditor.setConfiguration((ChangeableActivityConfiguration)this.parameterConfiguration);
        }
    }

    @Override
    protected void commitToValues() {
        if (this.nameInput != null) {
            this.name = this.nameInput.getText();
        }
        if (this.descriptionInput != null) {
            this.description = this.descriptionInput.getText();
        }
        if (this.dataTypeInput != null) {
            this.dataType = (ProcessConstants.AdeptDataType)((IStructuredSelection)this.dataTypeInput.getSelection()).getFirstElement();
            this.udtName = this.dataType == ProcessConstants.AdeptDataType.USERDEFINED ? this.udtNameInput.getText() : null;
        }
        if (this.isOptionalInput != null) {
            this.isOptional = this.isOptionalInput.getSelection();
        }
        if (this.isVirtualInput != null) {
            this.isVirtual = this.isVirtualInput.getSelection();
        }
        if (this.activityConfigEditor != null) {
            this.activityConfigEditor.commitEdits();
        }
    }
}

