/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class ExecutableComponentWizard
implements PnPWizardChangeListener {
    private ActivityPnPWizardData data;
    protected final List<IWizardPage> pages = new ArrayList<IWizardPage>();

    protected ExecutableComponentWizard() {
    }

    public void init(ActivityPnPWizardData data) {
        ArgChecks.checkForNull((Object)data, (String)"data");
        if (this.data != null) {
            this.data.removeChangeListener(this);
        }
        this.data = data;
        this.data.addChangeListener(this);
    }

    protected void addPage(IWizardPage page) {
        this.pages.add(page);
    }

    public ActivityPnPWizardData getData() {
        return this.data;
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    @Deprecated
    public void performFinish() {
    }

    @Override
    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
        if (type == PnPWizardChangeListener.PnPWizardChangeType.CONFIGURATION_CHANGED) {
            this.refreshAllPages();
        }
    }

    protected void refreshAllPages() {
        for (IWizardPage wizardPage : this.pages) {
            if (!(wizardPage instanceof ExecutableComponentWizardPage)) continue;
            ((ExecutableComponentWizardPage)wizardPage).refresh();
        }
    }

    protected ProcessModelParameter[] findParameters(ActivityConstants.AccessType accessType, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID) {
        ArrayList<ProcessModelParameter> found = new ArrayList<ProcessModelParameter>();
        this.findParameters(found, accessType, dataType, udtName, identifierID);
        return found.toArray(new ProcessModelParameter[found.size()]);
    }

    protected void findParameters(Collection<ProcessModelParameter> found, ActivityConstants.AccessType accessType, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID) {
        ArgChecks.checkForNull(found, (String)"found");
        ArgChecks.checkForNull((Object)accessType, (String)"accessType");
        Set<ProcessModelParameter> params = this.getData().getParameters(accessType);
        for (ProcessModelParameter param : params) {
            if (dataType != null && dataType != param.getDataType() || udtName != null && udtName != param.getUDTName() || identifierID != null & identifierID != param.getIdentifierID()) continue;
            found.add(param);
        }
    }
}

