/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.base.service.ADEPT2ServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.util.wizard.ExtendedWizardPage;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class ExecutableComponentWizardPage
extends ExtendedWizardPage {
    private ExecutableComponentWizard ecWizard;

    public ExecutableComponentWizardPage(ExecutableComponentWizard ecWizard, String pageName) {
        super(pageName);
        ArgChecks.checkForNull((Object)ecWizard, (String)"ecWizard");
        this.ecWizard = ecWizard;
    }

    public ExecutableComponentWizardPage(ExecutableComponentWizard ecWizard, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        ArgChecks.checkForNull((Object)ecWizard, (String)"ecWizard");
        this.ecWizard = ecWizard;
    }

    protected ExecutableComponentWizard getPageGroup() {
        return this.ecWizard;
    }

    protected final ActivityPnPWizardData getData() {
        return this.ecWizard.getData();
    }

    protected String confGet(String fieldName) {
        String value = this.getData().getConfiguration().getString(fieldName);
        return value == null ? "" : value;
    }

    protected ConfigurationDescription getConfigurationDescription() {
        ConfigurationDescription confDesc;
        if (this.getData().getActivityTemplate() != null) {
            confDesc = this.getData().getActivityTemplate().getConfigurationDescription();
        } else {
            String ecName = this.getData().getExecutableComponentName();
            String opName = this.getData().getOperationName();
            String atName = this.getData().getActivityName();
            try {
                ActivityRepository ar = Activator.getAMService().getActivityRepository();
                SessionToken session = Activator.getAMService().getSessionToken();
                InheritedConfigurationDescription inhConfDesc = null;
                try {
                    inhConfDesc = ar.getATDManager().getLatestATD(session, ecName, opName, atName).getConfigurationDescription();
                }
                catch (UnknownEntityException unknownEntityException) {}
                if (inhConfDesc == null) {
                    try {
                        inhConfDesc = ar.getOperationManager().getLatestOperation(session, ecName, opName).getConfigurationDescription();
                    }
                    catch (UnknownEntityException unknownEntityException) {}
                    if (inhConfDesc == null) {
                        try {
                            inhConfDesc = ar.getECDManager().getLatestECD(session, ecName).getConfigurationDescription();
                        }
                        catch (UnknownEntityException unknownEntityException) {}
                    }
                }
                if (inhConfDesc != null) {
                    Map entries = inhConfDesc.getEntries();
                    Iterator it = entries.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry mapEntry = it.next();
                        if (mapEntry.getValue() != null) continue;
                        it.remove();
                    }
                    confDesc = Activator.getAMService().getActivityModelFactory().createConfigurationDescription(entries);
                } else {
                    confDesc = null;
                }
            }
            catch (ADEPT2ServiceException aDEPT2ServiceException) {
                confDesc = null;
            }
        }
        return confDesc;
    }
}

