/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PnPOverviewWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OpenOfficeWizard
extends ExecutableComponentWizard {
    protected OpenOfficePage page;
    static final String[] documentTypes = new String[]{"Base Document", "Calc Document", "Draw Document", "Impress Document", "Math Document", "Web Document", "Text Document"};
    protected final Logger logger = LoggerTools.getLogger((Object)this);

    @Override
    public void init(ActivityPnPWizardData data) {
        super.init(data);
        this.page = new OpenOfficePage();
        this.addPage((IWizardPage)this.page);
    }

    @Deprecated
    public Map<String, String> getChangedActivityTypeconfiguration() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (this.page.combo != null) {
            newMap.put("OpenOffice.NewDocumentType", this.page.combo.getText());
        }
        if (this.page.templateURLText != null) {
            newMap.put("OpenOffice.NewDocumentTemplateURI", this.page.templateURLText.getText());
        }
        return newMap;
    }

    @Override
    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
    }

    protected class OpenOfficePage
    extends WizardPage {
        Combo combo;
        Text templateURLText;
        String operationName;

        public OpenOfficePage() {
            super("Configure OpenOfficeActivity");
            this.operationName = OpenOfficeWizard.this.getData().isExistingEBP() ? OpenOfficeWizard.this.getData().getOriginalEBP().getOperationName() : OpenOfficeWizard.this.getData().getActivityTemplate().getOperationName();
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout containerLayout = new GridLayout(2, false);
            containerLayout.marginRight = 20;
            containerLayout.marginLeft = 20;
            container.setLayout((Layout)containerLayout);
            Control titleLable = PnPOverviewWizardPage.createBoldLabel(container, String.format("Configure operation '%s'", this.operationName));
            GridData gridData = new GridData(256);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = -10;
            titleLable.setLayoutData((Object)gridData);
            if (this.operationName.equals("createDocument")) {
                Label documentTypelabel = new Label(container, 0);
                documentTypelabel.setText("Document type:");
                this.combo = new Combo(container, 4);
                this.combo.setItems(documentTypes);
                this.combo.select(0);
                String docType = OpenOfficeWizard.this.getData().getConfiguration().getString("NewDocumentType");
                if (docType != null && !docType.equals("")) {
                    int i = 0;
                    while (i < documentTypes.length) {
                        if (documentTypes[i].equals(docType)) {
                            this.combo.select(i);
                            break;
                        }
                        ++i;
                    }
                }
                this.combo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        OpenOfficeWizard.this.getData().getConfiguration().setString("NewDocumentType", OpenOfficePage.this.combo.getText());
                    }
                });
            } else if (this.operationName.equals("createDocumentFromTemplate")) {
                Label documentTypelabel = new Label(container, 0);
                documentTypelabel.setText("Template:");
                this.templateURLText = new Text(container, 2052);
                String defaultURI = OpenOfficeWizard.this.getData().getConfiguration().getString("NewDocumentTemplateURI");
                if (defaultURI == null) {
                    defaultURI = "file:///";
                }
                this.templateURLText.setText(defaultURI);
                gridData = new GridData(256);
                this.templateURLText.setLayoutData((Object)gridData);
                this.templateURLText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        OpenOfficeWizard.this.getData().getConfiguration().setString("NewDocumentTemplateURI", OpenOfficePage.this.templateURLText.getText());
                    }
                });
            } else if (!this.operationName.equals("editDocument") && !this.operationName.equals("showDocument")) {
                OpenOfficeWizard.this.logger.warning("unknown operation: " + this.operationName);
            }
            this.setControl((Control)container);
        }

        public boolean hasContent() {
            boolean templateURIParameterExists = false;
            if (OpenOfficeWizard.this.getData().getParameter("Template", ActivityConstants.AccessType.READ) != null) {
                templateURIParameterExists = true;
            }
            return this.operationName.equals("createDocumentFromTemplate") && !templateURIParameterExists || this.operationName.equals("createDocument");
        }
    }
}

