/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultChangeableActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class ParameterConfigurationDialog
extends Dialog {
    protected String name;
    protected String description;
    protected ProcessConstants.AdeptDataType dataType;
    protected String udtName;
    protected UUID identifierID;
    protected boolean isOptional;
    protected boolean isVirtual;
    protected boolean isFailure;
    protected String defaultValue;
    protected DefaultChangeableActivityConfiguration parameterConfiguration;
    protected EBPPnPWizardData data;
    protected ActivityConstants.AccessType accessType;
    protected ProcessModelParameter editedParameter;
    protected ATParameterTemplate parameterTemplate;
    protected ProcessModelParameter result;

    protected ParameterConfigurationDialog(Shell parentShell, EBPPnPWizardData data, ActivityConstants.AccessType accessType) {
        super(parentShell);
        this.data = data;
        this.accessType = accessType;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Add/Edit Parameter");
        super.configureShell(newShell);
    }

    protected void okPressed() {
        Map userAttributes;
        ProcessModelParameter pdc;
        this.commitToValues();
        this.result = null;
        if (this.name.equals("")) {
            String msg = "You have to enter a name for the parameter!";
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)msg);
            return;
        }
        if (!(this.editedParameter != null && this.name.equals(this.editedParameter.getName()) || this.data.getParameter(this.name, this.accessType) == null)) {
            String msg = "A parameter with the name '%s' already exists!";
            msg = String.format(msg, this.name);
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)msg);
            return;
        }
        if (this.dataType == ProcessConstants.AdeptDataType.USERDEFINED && (this.udtName == null || this.udtName.equals(""))) {
            String msg = "Please enter a type name for the userdefined type!";
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)msg);
            return;
        }
        if (this.parameterConfiguration.getAllEntries().contains("")) {
            String msg = "Please enter a key for the configuration or remove the entry!";
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)msg);
            return;
        }
        if (this.editedParameter != null) {
            pdc = this.editedParameter;
            userAttributes = this.editedParameter.getUserAttributes();
        } else if (this.parameterTemplate != null) {
            pdc = this.parameterTemplate;
            userAttributes = this.parameterTemplate.getUserAttributes();
            userAttributes.put("fromParameterTemplate", this.parameterTemplate.getTemplateName());
        } else {
            pdc = null;
            userAttributes = null;
        }
        this.result = Activator.getService().getProcessModelFactory().createProcessModelParameter(this.name, this.description, this.dataType, this.udtName, this.identifierID, this.isOptional, this.isVirtual, this.isFailure, this.defaultValue, (ActivityConfiguration)this.parameterConfiguration, (PluginDataContainer)pdc, userAttributes);
        super.okPressed();
    }

    public ProcessModelParameter createParameter(ATParameterTemplate template) {
        this.editedParameter = null;
        this.parameterTemplate = template;
        this.initDefaultValues();
        if (template != null) {
            if (template.getName() != null) {
                this.name = template.getName();
            }
            if (template.getDescription() != null) {
                this.description = template.getDescription();
            }
            if (template.getDataType() != null) {
                this.dataType = template.getDataType();
            }
            if (template.getUDTName() != null) {
                this.udtName = template.getUDTName();
            }
            if (template.getIdentifierID() != null) {
                this.identifierID = template.getIdentifierID();
            }
            if (template.isOptional() != null) {
                this.isOptional = template.isOptional();
            }
            if (template.isVirtual() != null) {
                this.isVirtual = template.isVirtual();
            }
            if (template.isFailure() != null) {
                this.isFailure = template.isFailure();
            }
            if (template.getDefaultValue() != null) {
                this.defaultValue = template.getDefaultValue();
            }
            this.parameterConfiguration = new DefaultChangeableActivityConfiguration(template.getConfiguration());
        }
        this.create();
        this.updateFromValues();
        this.open();
        return this.result;
    }

    public ProcessModelParameter editParameter(ProcessModelParameter param) {
        this.editedParameter = param;
        this.parameterTemplate = null;
        this.name = param.getName();
        this.description = param.getDescription();
        this.dataType = param.getDataType();
        this.udtName = param.getUDTName();
        this.identifierID = param.getIdentifierID();
        this.isOptional = param.isOptional();
        this.isVirtual = param.isVirtual();
        this.isFailure = param.isFailure();
        this.defaultValue = param.getDefaultValue();
        this.parameterConfiguration = new DefaultChangeableActivityConfiguration(param.getConfiguration());
        this.create();
        this.updateFromValues();
        this.open();
        return this.result;
    }

    protected void initDefaultValues() {
        this.name = "";
        this.description = "";
        this.dataType = ProcessConstants.AdeptDataType.STRING;
        this.udtName = "";
        this.identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
        this.isOptional = false;
        this.isVirtual = false;
        this.isFailure = false;
        this.defaultValue = null;
        this.parameterConfiguration = new DefaultChangeableActivityConfiguration();
    }

    protected abstract void updateFromValues();

    protected abstract void commitToValues();
}

