/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.DataElementSelectionDialogue;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.DefaultParameterConfigurationDialog;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ParameterTemplateSelectionDialogue;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ParameterMappingEntry;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParameterCreationWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "parameters";
    protected EBPPnPWizardData data;
    protected ParameterGroup inputParamGroup;
    protected ParameterGroup outputParamGroup;

    public ParameterCreationWizardPage(EBPPnPWizardData data) {
        super(PAGE_NAME, "Parameters", null);
        this.setDescription("On this page you can define the input and output parameters for the activity.");
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new MigLayout("wrap", "[grow, fill]", "[grow, fill]"));
        this.createInputParameterGroup(composite);
        this.createOutputParameterGroup(composite);
        if (!this.data.isExistingEBP()) {
            this.takeOverConnectedDataElementsAsParameters(ActivityConstants.AccessType.READ);
            this.takeOverConnectedDataElementsAsParameters(ActivityConstants.AccessType.WRITE);
        }
        this.setControl((Control)composite);
    }

    protected void createInputParameterGroup(Composite parent) {
        this.inputParamGroup = new ParameterGroup(ActivityConstants.AccessType.READ);
        this.createParameterGroup(this.inputParamGroup, parent, "Input Parameters");
    }

    protected void createOutputParameterGroup(Composite parent) {
        this.outputParamGroup = new ParameterGroup(ActivityConstants.AccessType.WRITE);
        this.createParameterGroup(this.outputParamGroup, parent, "Output Parameters");
    }

    protected final void createParameterGroup(final ParameterGroup group, Composite parent, String title) {
        group.container = new Group(parent, 0);
        group.title = title;
        group.container.setText(title);
        group.container.setLayout((Layout)new MigLayout("wrap", "[grow, fill][]"));
        group.table = new TableViewer((Composite)group.container, 68098);
        group.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        group.table.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ProcessModelParameter p1 = (ProcessModelParameter)e1;
                ProcessModelParameter p2 = (ProcessModelParameter)e2;
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        group.table.getTable().setLayoutData((Object)"pushy, grow, w 0:200, h 0:100");
        TableColumnLayout tableLayout = new TableColumnLayout();
        group.table.getTable().setLayout((Layout)tableLayout);
        group.nameColumn = new TableViewerColumn(group.table, 0);
        group.nameColumn.getColumn().setText("Name");
        group.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                return param.getName();
            }
        });
        group.descriptionColumn = new TableViewerColumn(group.table, 0);
        group.descriptionColumn.getColumn().setText("Description");
        group.descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                return param.getDescription();
            }
        });
        tableLayout.setColumnData((Item)group.descriptionColumn.getColumn(), new ColumnData(1, 1.0f));
        group.dataTypeColumn = new TableViewerColumn(group.table, 0x1000000);
        group.dataTypeColumn.getColumn().setText("Data Type");
        group.dataTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                ProcessConstants.AdeptDataType dataType = param.getDataType();
                String dataTypeString = dataType == ProcessConstants.AdeptDataType.USERDEFINED ? "UDT: " + param.getUDTName() : dataType.toString();
                return dataTypeString;
            }
        });
        group.optionalColumn = new TableViewerColumn(group.table, 0x1000000);
        group.optionalColumn.getColumn().setText("Optional");
        group.optionalColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                return param.isOptional() ? "yes" : "no";
            }
        });
        group.virtualColumn = new TableViewerColumn(group.table, 0x1000000);
        group.virtualColumn.getColumn().setText("Virtual");
        group.virtualColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                return param.isVirtual() ? "yes" : "no";
            }
        });
        group.table.getTable().setHeaderVisible(true);
        group.refreshParameterTable();
        this.data.addChangeListener(new PnPWizardChangeListener(){

            @Override
            public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
                if (group.accessType == ActivityConstants.AccessType.READ) {
                    switch (type) {
                        case READ_PARAMETER_ADDED: {
                            group.table.add(affectedObject);
                            group.table.setSelection((ISelection)new StructuredSelection(affectedObject), true);
                            group.table.getTable().layout();
                            group.updateTitle();
                            break;
                        }
                        case READ_PARAMETER_CHANGED: {
                            group.table.remove((Object)((ProcessModelParameter[])affectedObject)[0]);
                            group.table.add((Object)((ProcessModelParameter[])affectedObject)[1]);
                            group.table.setSelection((ISelection)new StructuredSelection(((Object[])affectedObject)[1]), true);
                            group.table.getTable().layout();
                            group.updateTitle();
                            break;
                        }
                        case READ_PARAMETER_REMOVED: {
                            group.table.remove(affectedObject);
                            group.table.getTable().layout();
                            group.updateTitle();
                        }
                    }
                } else if (group.accessType == ActivityConstants.AccessType.WRITE) {
                    switch (type) {
                        case WRITE_PARAMETER_ADDED: {
                            group.table.add(affectedObject);
                            group.table.setSelection((ISelection)new StructuredSelection(affectedObject), true);
                            group.table.getTable().layout();
                            group.updateTitle();
                            break;
                        }
                        case WRITE_PARAMETER_CHANGED: {
                            group.table.remove((Object)((ProcessModelParameter[])affectedObject)[0]);
                            group.table.add((Object)((ProcessModelParameter[])affectedObject)[1]);
                            group.table.setSelection((ISelection)new StructuredSelection(((Object[])affectedObject)[1]), true);
                            group.table.getTable().layout();
                            group.updateTitle();
                            break;
                        }
                        case WRITE_PARAMETER_REMOVED: {
                            group.table.remove(affectedObject);
                            group.table.getTable().layout();
                            group.updateTitle();
                        }
                    }
                }
            }
        });
        group.addButton = new Button((Composite)group.container, 0);
        group.addButton.setText("Add Parameter...");
        group.addButton.setLayoutData((Object)"split 4, flowy, aligny top, growx");
        group.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                group.addParameterClicked();
                ParameterCreationWizardPage.this.checkDecisionOutputParameter();
            }
        });
        group.addForDataElementButton = new Button((Composite)group.container, 0);
        group.addForDataElementButton.setText("Add Parameter for...");
        group.addForDataElementButton.setToolTipText("Add Parameter for Data Element...");
        group.addForDataElementButton.setLayoutData((Object)"growx");
        group.addForDataElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                group.addParameterForDataElementClicked();
                ParameterCreationWizardPage.this.checkDecisionOutputParameter();
            }
        });
        group.editButton = new Button((Composite)group.container, 0);
        group.editButton.setText("Edit Parameter...");
        group.editButton.setLayoutData((Object)"growx");
        group.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                group.editParameterClicked();
                ParameterCreationWizardPage.this.checkDecisionOutputParameter();
            }
        });
        group.removeButton = new Button((Composite)group.container, 0);
        group.removeButton.setText("Remove Parameter");
        group.removeButton.setLayoutData((Object)"growx");
        group.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                group.removeParameterClicked();
                ParameterCreationWizardPage.this.checkDecisionOutputParameter();
            }
        });
        group.table.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = e.item != null;
                group.editButton.setEnabled(enable);
                group.removeButton.setEnabled(enable);
            }
        });
        group.table.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (group.editButton.isEnabled()) {
                    group.editParameterClicked();
                }
            }
        });
        group.editButton.setEnabled(false);
        group.removeButton.setEnabled(false);
    }

    void checkDecisionOutputParameter() {
        String decisionUA = null;
        if (this.data.getActivityTemplate() != null) {
            decisionUA = this.data.getActivityTemplate().getUserAttributeValue("decision");
        }
        if (this.data.isExistingEBP() && this.data.getOriginalEBP() instanceof DecisionActivity || this.data.getActivityTemplate() != null && decisionUA != null && decisionUA.equals("true")) {
            boolean noDecisionParamLeft = this.data.getParameters(ActivityConstants.AccessType.WRITE).isEmpty();
            if (!noDecisionParamLeft) {
                noDecisionParamLeft = true;
                for (ProcessModelParameter param : this.data.getParameters(ActivityConstants.AccessType.WRITE)) {
                    if (!param.getDataType().equals((Object)ProcessConstants.AdeptDataType.INTEGER)) continue;
                    noDecisionParamLeft = false;
                    break;
                }
            }
            if (noDecisionParamLeft) {
                this.setMessage("The XOR-Activity needs an output parameter of type Integer", 3);
                this.setPageComplete(false);
            } else {
                this.setMessage(null);
                this.setPageComplete(true);
            }
        }
    }

    private void takeOverConnectedDataElementsAsParameters(ActivityConstants.AccessType accessType) {
        Template template;
        if (this.data.getNodeData().getProcessTemplate() != null) {
            template = this.data.getNodeData().getProcessTemplate();
        } else if (this.data.getNodeData().getProcessInstance() != null) {
            template = this.data.getNodeData().getProcessInstance().getTemplate();
        } else {
            throw new AssertionError((Object)"Unreachable code");
        }
        Node node = this.data.getNodeData().getNode();
        switch (accessType) {
            case READ: 
            case WRITE: {
                int[] nArray = template.getAccessedDataElementIDsForNode(node.getID(), accessType);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int dataElementID = nArray[n2];
                    DataElement dataElement = template.getDataElement(dataElementID);
                    String newParameterName = dataElement.getName();
                    if (this.data.getParameter(newParameterName, accessType) == null) {
                        String description = dataElement.getDescription();
                        ProcessConstants.AdeptDataType dataType = dataElement.getDataType();
                        String udtName = dataElement.getUDTName();
                        UUID identifierID = dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) ? ProcessConstants.UNIVERSAL_IDENTIFIER_ID : dataElement.getIdentifierID();
                        boolean isOptional = template.getDataEdge(node.getID(), dataElementID, accessType).isOptional();
                        boolean isVirtual = dataElement.isVirtual();
                        boolean isFailure = false;
                        String defaultValue = null;
                        DefaultActivityConfiguration configuration = null;
                        ATParameterTemplate pluginData = null;
                        HashMap<String, String> userAttributes = null;
                        if (this.data.getActivityTemplate() != null) {
                            Map paramTemplates = this.data.getActivityTemplate().getParameterTemplates();
                            List<String> templateOrigins = ParameterCreationWizardPage.getDefaultParameterTemplateOrigins(accessType, dataType);
                            for (String templateOrigin : templateOrigins) {
                                ATParameterTemplate paramTemplate = (ATParameterTemplate)paramTemplates.get(templateOrigin);
                                if (paramTemplate == null) continue;
                                if (paramTemplate.getDescription() != null) {
                                    description = paramTemplate.getDescription();
                                }
                                if (paramTemplate.getName() != null) {
                                    newParameterName = paramTemplate.getName();
                                }
                                if (paramTemplate.getDataType() != null && dataType != paramTemplate.getDataType() || paramTemplate.getUDTName() != null && !paramTemplate.getUDTName().equals(udtName) || paramTemplate.getIdentifierID() != null && !paramTemplate.getIdentifierID().equals(identifierID)) continue;
                                if (paramTemplate.isOptional() != null) {
                                    if (!paramTemplate.isOptional().booleanValue() && isOptional) continue;
                                    if (paramTemplate.isOptional().booleanValue()) {
                                        isOptional = true;
                                    }
                                }
                                if (paramTemplate.isVirtual() != null && paramTemplate.isVirtual() != isVirtual) continue;
                                if (paramTemplate.isFailure() != null) {
                                    isFailure = paramTemplate.isFailure();
                                }
                                if (paramTemplate.getDefaultValue() != null) {
                                    defaultValue = paramTemplate.getDefaultValue();
                                }
                                configuration = new DefaultActivityConfiguration(paramTemplate.getConfiguration());
                                pluginData = paramTemplate;
                                userAttributes = new HashMap<String, String>();
                                userAttributes.put("fromParameterTemplate", paramTemplate.getTemplateName());
                                break;
                            }
                        }
                        ProcessModelParameter param = Activator.getService().getProcessModelFactory().createProcessModelParameter(newParameterName, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configuration, pluginData, userAttributes);
                        this.data.addParameter(param, accessType);
                    }
                    ++n2;
                }
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    static List<String> getDefaultParameterTemplateOrigins(ActivityConstants.AccessType accessType, ProcessConstants.AdeptDataType dataType) {
        String accessTypeString;
        ArrayList<String> result = new ArrayList<String>(4);
        String string = accessTypeString = accessType == ActivityConstants.AccessType.READ ? "Input" : "Output";
        if (dataType != null) {
            result.add(String.format("Default.%s.%s", accessTypeString, dataType.toString()));
            result.add(String.format("Default.%s", accessTypeString));
            result.add(String.format("Default.%s", dataType.toString()));
        } else {
            ProcessConstants.AdeptDataType temp;
            ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
            int n = adeptDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                temp = adeptDataTypeArray[n2];
                result.add(String.format("Default.%s.%s", accessTypeString, temp.toString()));
                ++n2;
            }
            result.add(String.format("Default.%s", accessTypeString));
            adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
            n = adeptDataTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                temp = adeptDataTypeArray[n2];
                result.add(String.format("Default.%s", accessTypeString, temp.toString()));
                ++n2;
            }
        }
        result.add("Default");
        return result;
    }

    public boolean canFlipToNextPage() {
        return this.getMessage() == null;
    }

    protected class ParameterGroup {
        protected final ActivityConstants.AccessType accessType;
        protected String title;
        protected Button addButton;
        protected Button addForDataElementButton;
        protected Button editButton;
        protected Button removeButton;
        protected Group container;
        protected TableViewer table;
        protected TableViewerColumn nameColumn;
        protected TableViewerColumn descriptionColumn;
        protected TableViewerColumn dataTypeColumn;
        protected TableViewerColumn optionalColumn;
        protected TableViewerColumn virtualColumn;
        protected Map<String, Object> userData = new HashMap<String, Object>();

        public ParameterGroup(ActivityConstants.AccessType accessType) {
            ArgChecks.checkForNull((Object)accessType, (String)"accessType");
            this.accessType = accessType;
        }

        protected void updateTitle() {
            String title = "%s (%d)";
            title = String.format(title, this.title, this.table.getTable().getItemCount());
            this.container.setText(title);
        }

        protected final void refreshParameterTable() {
            this.table.setInput(ParameterCreationWizardPage.this.data.getParameters(this.accessType));
            this.table.getTable().layout();
            this.updateTitle();
        }

        protected final ProcessModelParameter getSelectedParameter() {
            return (ProcessModelParameter)((StructuredSelection)this.table.getSelection()).getFirstElement();
        }

        protected final void addParameter(ProcessModelParameter param) {
            ParameterCreationWizardPage.this.data.addParameter(param, this.accessType);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }

        protected final void editParameter(ProcessModelParameter paramOld, ProcessModelParameter paramNew) {
            ParameterCreationWizardPage.this.data.changeParameter(paramOld, paramNew, this.accessType);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }

        protected final void removeParameter(ProcessModelParameter param) {
            ParameterCreationWizardPage.this.data.removeParameter(param.getName(), this.accessType);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }

        protected void addParameterClicked() {
            try {
                ATParameterTemplate parameterTemplate = this.pickParameterTemplate();
                DefaultParameterConfigurationDialog pcd = new DefaultParameterConfigurationDialog(ParameterCreationWizardPage.this.getShell(), ParameterCreationWizardPage.this.data, this.accessType);
                ProcessModelParameter param = pcd.createParameter(parameterTemplate);
                if (param != null) {
                    this.addParameter(param);
                }
            }
            catch (CancellationException cancellationException) {}
        }

        protected void addParameterForDataElementClicked() {
            try {
                ATParameterTemplate template = this.pickParameterTemplate();
                ArrayList<DataElement> matchingDataElements = new ArrayList<DataElement>();
                for (DataElement dataElement : ParameterCreationWizardPage.this.data.getNodeData().getProcessTemplate().getDataElements()) {
                    if (this.isMapped(dataElement.getID(), this.accessType) || template != null && !this.match(template, dataElement)) continue;
                    matchingDataElements.add(dataElement);
                }
                if (matchingDataElements.size() == 0) {
                    String msg = "No data elements matching the parameter template could be found.";
                    MessageDialog.openWarning((Shell)ParameterCreationWizardPage.this.getShell(), (String)"No Data Elements found", (String)msg);
                    return;
                }
                DataElementSelectionDialogue dia = new DataElementSelectionDialogue(ParameterCreationWizardPage.this.getShell(), matchingDataElements, true);
                if (dia.open() == 0) {
                    DataElement[] dataElementArray = dia.getSelectedDataElements();
                    int n = dataElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataElement dataElement = dataElementArray[n2];
                        ProcessModelParameter param = this.merge(template, dataElement);
                        if (param != null) {
                            this.addParameter(param);
                            ParameterCreationWizardPage.this.data.changeMapping(param, dataElement, ProcessConstants.DataMappingType.DATAELEMENT, this.accessType);
                        }
                        ++n2;
                    }
                }
            }
            catch (CancellationException cancellationException) {}
        }

        private boolean match(ATParameterTemplate param, DataElement dataElement) {
            if (param.getDataType() != null) {
                if (param.getDataType() != dataElement.getDataType()) {
                    return false;
                }
                if (param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && StringTools.equal((String)param.getUDTName(), (Object)dataElement.getUDTName())) {
                    return false;
                }
            }
            if (param.isVirtual() != null && param.isVirtual().booleanValue() != dataElement.isVirtual()) {
                return false;
            }
            return param.getIdentifierID() == null || param.getIdentifierID().equals(dataElement.getIdentifierID()) || dataElement.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET);
        }

        private ProcessModelParameter merge(ATParameterTemplate template, DataElement dataElement) {
            String name = dataElement.getName();
            String description = "";
            boolean isOptional = false;
            boolean isFailure = false;
            String defaultValue = null;
            DefaultActivityConfiguration conf = null;
            ATParameterTemplate pluginData = null;
            Map userAttributes = null;
            if (template != null) {
                if (template.getName() != null) {
                    name = template.getName();
                }
                if (template.getDescription() != null) {
                    description = template.getDescription();
                }
                if (template.isOptional() != null) {
                    isOptional = template.isOptional();
                }
                if (template.isFailure() != null) {
                    isFailure = template.isFailure();
                }
                defaultValue = template.getDefaultValue();
                conf = new DefaultActivityConfiguration(template.getConfiguration());
                pluginData = template;
                userAttributes = template.getUserAttributes();
            }
            return Activator.getService().getProcessModelFactory().createProcessModelParameter(name, description, dataElement.getDataType(), dataElement.getUDTName(), dataElement.getIdentifierID(), isOptional, dataElement.isVirtual(), isFailure, defaultValue, conf, pluginData, userAttributes);
        }

        private boolean isMapped(int dataElementID, ActivityConstants.AccessType accessType) {
            for (ParameterMappingEntry entry : ParameterCreationWizardPage.this.data.getParameterMapping(accessType).values()) {
                if (entry.element == null || entry.element.getID() != dataElementID) continue;
                return true;
            }
            return false;
        }

        protected ATParameterTemplate pickParameterTemplate() {
            ATParameterTemplate parameterTemplate = null;
            if (ParameterCreationWizardPage.this.data.getActivityTemplate() != null) {
                ArrayList<ATParameterTemplate> templates = new ArrayList<ATParameterTemplate>(ParameterCreationWizardPage.this.data.getActivityTemplate().getParameterTemplates().values());
                Iterator it = templates.iterator();
                while (it.hasNext()) {
                    ATParameterTemplate template = (ATParameterTemplate)it.next();
                    if (template.getAccessType() == null || template.getAccessType() == this.accessType) continue;
                    it.remove();
                }
                if (templates.size() > 0) {
                    List<String> defaultParameterTemplateOrigins;
                    if (templates.size() == 1 && (defaultParameterTemplateOrigins = ParameterCreationWizardPage.getDefaultParameterTemplateOrigins(this.accessType, null)).contains(((ATParameterTemplate)templates.get(0)).getTemplateName())) {
                        parameterTemplate = (ATParameterTemplate)templates.get(0);
                    }
                    if (parameterTemplate == null) {
                        ParameterTemplateSelectionDialogue dia = new ParameterTemplateSelectionDialogue(ParameterCreationWizardPage.this.getShell(), templates, ParameterCreationWizardPage.this.data.getActivityTemplate().getIdentifiers());
                        if (dia.open() == 0) {
                            parameterTemplate = dia.getSelectedTemplate();
                        } else {
                            throw new CancellationException();
                        }
                    }
                }
            }
            return parameterTemplate;
        }

        protected void editParameterClicked() {
            DefaultParameterConfigurationDialog pcd;
            ProcessModelParameter edited;
            ProcessModelParameter selected = this.getSelectedParameter();
            if (selected != null && (edited = (pcd = new DefaultParameterConfigurationDialog(ParameterCreationWizardPage.this.getShell(), ParameterCreationWizardPage.this.data, this.accessType)).editParameter(selected)) != null) {
                this.editParameter(selected, edited);
            }
        }

        protected void removeParameterClicked() {
            StructuredSelection selection = (StructuredSelection)this.table.getSelection();
            if (selection.getFirstElement() != null) {
                if (selection.size() == 1) {
                    String msg = "Remove the parameter '%s'?";
                    ProcessModelParameter selected = this.getSelectedParameter();
                    msg = String.format(msg, selected.getName());
                    if (MessageDialog.openQuestion((Shell)ParameterCreationWizardPage.this.getShell(), (String)"Remove parameter", (String)msg)) {
                        this.removeParameter(selected);
                    }
                } else {
                    String msg = "Remove all selected parameters?";
                    if (MessageDialog.openQuestion((Shell)ParameterCreationWizardPage.this.getShell(), (String)"Remove parameters", (String)msg)) {
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object selectedObj = objectArray[n2];
                            ProcessModelParameter param = (ProcessModelParameter)selectedObj;
                            this.removeParameter(param);
                            ++n2;
                        }
                    }
                }
            }
        }
    }
}

