/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.model.MappingChangeEffectListener;
import de.aristaflow.adept2.ui.processediting.model.MappingData;
import de.aristaflow.adept2.ui.processediting.model.MappingDataList;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangeListener;
import de.aristaflow.adept2.ui.processediting.model.MappingDataListChangedEvent;
import de.aristaflow.adept2.ui.processediting.model.MappingDataProperty;
import de.aristaflow.adept2.ui.processediting.model.ParameterMappingTableInitialiser;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.LWPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultLWPPnPWizardData;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParameterMappingWizardPage
extends WizardPage
implements MappingDataListChangeListener,
MappingChangeEffectListener {
    public static final String PAGE_NAME = "parameterMapping";
    private EBPPnPWizardData data;
    private MappingDataList inMDataList;
    private MappingDataList outMDataList;
    private static final int GROUP_MARGIN_HEIGHT = 3;
    private static final int GROUP_MARGIN_WIDTH = 3;

    public ParameterMappingWizardPage(EBPPnPWizardData data) {
        super(PAGE_NAME);
        this.data = data;
    }

    public void createControl(Composite parent) {
        String description = "";
        description = this.data instanceof ActivityPnPWizardData ? "This wizard page helps mapping activity parameters to data elements." : "This wizard page helps the user connecting the input and output data of a subprocess to the data elements of the parent process";
        this.setTitle("Parameter Mapping");
        this.setDescription(description);
        Composite container = new Composite(parent, 0);
        this.createPageContent(container);
        this.setControl((Control)container);
        for (MappingData data : this.inMDataList.getMappingDataList()) {
            this.inMDataList.calculateStatus(data, data.getDataElement(), data.getDataMappingType());
        }
        for (MappingData data : this.outMDataList.getMappingDataList()) {
            this.outMDataList.calculateStatus(data, data.getDataElement(), data.getDataMappingType());
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void createPageContent(final Composite container) {
        GridLayout gridLayout = new GridLayout(3, false);
        container.setLayout((Layout)gridLayout);
        Group inputParamGroup = this.createGroup(container, "Input Parameters");
        final Label label = new Label(container, 0);
        label.setForeground(container.getDisplay().getSystemColor(3));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        boolean isFork = false;
        if (this.data instanceof LWPPnPWizardData && ((LWPPnPWizardData)this.data).getTemplateUsage().equals((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.FORKED)) {
            gd.exclude = false;
            label.setText("The subprocess is used in fork mode. All output parameters will be disabled by default.");
            isFork = true;
        } else {
            gd.exclude = true;
            label.setText("");
        }
        label.setLayoutData((Object)gd);
        Group outputParamGroup = this.createGroup(container, "Output Parameters");
        ParameterMappingTableInitialiser inputTable = new ParameterMappingTableInitialiser((Composite)inputParamGroup, 100356, ActivityConstants.AccessType.READ);
        this.inMDataList = new MappingDataList(this.data, ActivityConstants.AccessType.READ);
        this.inMDataList.addChangeEffectListener(this);
        this.inMDataList.addChangeListener(this);
        inputTable.setInputData(this.inMDataList);
        final ParameterMappingTableInitialiser outputTable = new ParameterMappingTableInitialiser((Composite)outputParamGroup, 100356, ActivityConstants.AccessType.WRITE);
        this.outMDataList = new MappingDataList(this.data, ActivityConstants.AccessType.WRITE);
        this.outMDataList.addChangeEffectListener(this);
        this.outMDataList.addChangeListener(this);
        outputTable.setInputData(this.outMDataList);
        outputTable.getTable().setEnabled(!isFork);
        this.data.addChangeListener(new PnPWizardChangeListener(){

            @Override
            public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
                if (type == PnPWizardChangeListener.PnPWizardChangeType.FORK_CHANGED) {
                    boolean isFork = (Boolean)affectedObject;
                    outputTable.getTable().setEnabled(!isFork);
                    if (isFork) {
                        label.setText("The subprocess is used in fork mode. All output parameters will be disabled by default.");
                        GridData gd = new GridData();
                        gd.horizontalSpan = 3;
                        gd.exclude = false;
                        label.setLayoutData((Object)gd);
                        label.setVisible(true);
                        container.layout();
                    } else {
                        label.setText("");
                        GridData gd = new GridData();
                        gd.horizontalSpan = 3;
                        gd.exclude = true;
                        label.setLayoutData((Object)gd);
                        label.setVisible(false);
                        container.layout();
                    }
                }
            }
        });
    }

    private Group createGroup(Composite parent, String title) {
        Group group = new Group(parent, 32);
        group.setText(title);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        group.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 3;
        fillLayout.marginWidth = 3;
        group.setLayout((Layout)fillLayout);
        return group;
    }

    public void updatePageStatus(String status) {
        String message = null;
        if (status != null && status.equals("error_tsk.gif")) {
            message = "Two or more Parameters are mapped to the same data element";
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String checkEffectsOnOtherMappingTable(MappingData mData, DataElement newDataElement, ProcessConstants.DataMappingType newType, ActivityConstants.AccessType type) {
        MappingDataList otherMDataList;
        String status = null;
        switch (type) {
            case READ: {
                otherMDataList = this.outMDataList;
                break;
            }
            case WRITE: {
                otherMDataList = this.inMDataList;
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                throw new IllegalArgumentException("This wizard only supports mapping activity related access types.");
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        status = otherMDataList.calculateStatus(mData, newDataElement, newType);
        return status;
    }

    public boolean affectsOtherMappingList(DataElement data, ProcessModelParameter param, ActivityConstants.AccessType type) {
        MappingDataList otherMDataList;
        switch (type) {
            case READ: {
                otherMDataList = this.outMDataList;
                break;
            }
            case WRITE: {
                otherMDataList = this.inMDataList;
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                throw new IllegalArgumentException("This wizard only supports mapping activity related access types.");
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        if (otherMDataList == null) {
            return false;
        }
        List<MappingData> mappingDataList = otherMDataList.getMappingDataList();
        for (MappingData otherMData : mappingDataList) {
            if (otherMData.getDataMappingType() != ProcessConstants.DataMappingType.DATAELEMENT || !otherMData.getDataElement().equals(data) || otherMData.getParameter().getIdentifierID().equals(param.getIdentifierID()) || otherMData.getParameter().getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || param.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) continue;
            return true;
        }
        return false;
    }

    public boolean commit() {
        if (this.inMDataList != null) {
            this.commitChangesToWizardData(this.inMDataList, ActivityConstants.AccessType.READ);
            this.commitChangesToWizardData(this.outMDataList, ActivityConstants.AccessType.WRITE);
        }
        return true;
    }

    private void commitChangesToWizardData(MappingDataList mappingList, ActivityConstants.AccessType accessType) {
        for (MappingData mData : mappingList.getMappingDataList()) {
            if (!mData.hasChanged()) continue;
            this.data.changeMapping(mData.getParameter(), mData.getDataElement(), mData.getDataMappingType(), accessType);
            mData.setChangeStatus(false);
        }
    }

    @Override
    public String checkEffectsOnOtherMappingDataLists(MappingData mData, DataElement newDataElement, MappingDataList list) {
        String status = null;
        status = this.inMDataList == list ? this.outMDataList.checkEffectsOfDataMappingChange(mData, newDataElement) : this.inMDataList.checkEffectsOfDataMappingChange(mData, newDataElement);
        return status;
    }

    @Override
    public void modelChanged(MappingDataListChangedEvent mappingDataListChangedEvent) {
        List<MappingDataProperty> propertyList = Arrays.asList(mappingDataListChangedEvent.getChangedProperties());
        if (propertyList.contains((Object)MappingDataProperty.STATUS)) {
            MappingData changedData = (MappingData)mappingDataListChangedEvent.getSource();
            String status = changedData.getStatus();
            if (status == null) {
                for (MappingData data : this.inMDataList.getMappingDataList()) {
                    if (data.getStatus() == null) continue;
                    status = data.getStatus();
                    break;
                }
            }
            this.updatePageStatus(status);
        }
    }

    public IWizardPage getNextPage() {
        this.commit();
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        this.commit();
        return super.getPreviousPage();
    }
}

