/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParameterTable {
    protected Table table;
    protected EBPPnPWizardData data;
    protected ActivityConstants.AccessType accessType;

    public ParameterTable(Composite parent, EBPPnPWizardData data, ActivityConstants.AccessType accessType) {
        this.data = data;
        this.accessType = accessType;
        this.table = new Table(parent, 68100);
        TableColumn name = new TableColumn(this.table, 16384);
        name.setText("Name");
        name.setWidth(100);
        TableColumn description = new TableColumn(this.table, 16384);
        description.setText("Description");
        description.setWidth(200);
        TableColumn type = new TableColumn(this.table, 16384);
        type.setText("Type");
        type.setWidth(100);
        this.table.setHeaderVisible(true);
        this.refreshParameters();
    }

    public void refreshParameters() {
        Set<ProcessModelParameter> set = this.data.getParameters(this.accessType);
        this.table.removeAll();
        for (ProcessModelParameter param : set) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)param);
            item.setText(0, param.getName());
            item.setText(1, param.getDescription());
            item.setText(2, param.getDataType().toString());
        }
    }

    public Table getTable() {
        return this.table;
    }

    public ProcessModelParameter getSelectedParameter() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length > 0) {
            return (ProcessModelParameter)selection[0].getData();
        }
        return null;
    }
}

