/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.ui.util.FontTools;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterTemplateSelectionDialogue
extends TitleAreaDialog {
    private Collection<ATParameterTemplate> parameterTemplates;
    private Map<UUID, Identifier> identifiers;
    private ATParameterTemplate selectedTemplate = null;
    private ComboViewer cmTemplates;

    public ParameterTemplateSelectionDialogue(Shell parentShell, Collection<ATParameterTemplate> parameterTemplates, Map<UUID, Identifier> identifiers) {
        super(parentShell);
        ArgChecks.checkForNulls(parameterTemplates, (String)"parameterTemplates");
        ArgChecks.checkSize(parameterTemplates, (int)1, (String)"parameterTemplates");
        ArgChecks.checkForNulls(identifiers, (String)"identifiers");
        this.parameterTemplates = new ArrayList<ATParameterTemplate>(parameterTemplates);
        this.identifiers = new HashMap<UUID, Identifier>(identifiers);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Choose Parameter Template");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Choose a Parameter Template");
        this.setMessage("Choose the parameter template which will be the base for the new process parameter.");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite dialogArea = new Composite(container, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(200);
        dialogArea.setLayoutData((Object)layoutData);
        dialogArea.setLayout((Layout)new MigLayout("wrap, insets dialog", "[grow, fill]"));
        Label lbTemplates = new Label(dialogArea, 0);
        lbTemplates.setText("Parameter Template:");
        lbTemplates.setLayoutData((Object)"spanx, split 2");
        this.cmTemplates = new ComboViewer(dialogArea);
        this.cmTemplates.getCombo().setLayoutData((Object)"growx");
        this.cmTemplates.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmTemplates.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ATParameterTemplate tpl1 = (ATParameterTemplate)e1;
                ATParameterTemplate tpl2 = (ATParameterTemplate)e2;
                return tpl1.getTemplateName().compareToIgnoreCase(tpl2.getTemplateName());
            }
        });
        this.cmTemplates.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ATParameterTemplate tpl = (ATParameterTemplate)element;
                return tpl.getTemplateName();
            }
        });
        this.cmTemplates.setInput(this.parameterTemplates);
        new Label(dialogArea, 258).setLayoutData((Object)"gapy 7lp 10lp");
        Composite details = new Composite(dialogArea, 0);
        details.setLayout((Layout)new MigLayout("wrap, insets 0", "[fill] rel [grow, fill]", "[fill, align baseline]"));
        Label lbBla = new Label(details, 0);
        lbBla.setLayoutData((Object)"spanx, gapbottom 10lp");
        lbBla.setText("Template Details");
        FontTools.changeFont((Control)lbBla, (int)0, (int)1);
        Label lbTemplateName = new Label(details, 0);
        lbTemplateName.setText("Template Name:");
        final Text txTemplateName = new Text(details, 2056);
        txTemplateName.setLayoutData((Object)"w 0:0");
        Label lbTemplateDescription = new Label(details, 0);
        lbTemplateDescription.setText("Template Description:");
        final Text txTemplateDescription = new Text(details, 2890);
        txTemplateDescription.setLayoutData((Object)"w 0:0, h 50lp!");
        Label lbAccessType = new Label(details, 0);
        lbAccessType.setLayoutData((Object)"newline para");
        lbAccessType.setText("Access Type:");
        final Text txAccessType = new Text(details, 2056);
        txAccessType.setLayoutData((Object)"w 0:0");
        Label lbName = new Label(details, 0);
        lbName.setText("Name:");
        final Text txName = new Text(details, 2056);
        txName.setLayoutData((Object)"w 0:0");
        Label lbDescription = new Label(details, 0);
        lbDescription.setText("Description:");
        final Text txDescription = new Text(details, 2890);
        txDescription.setLayoutData((Object)"w 0:0, h 50lp!");
        Label lbDataType = new Label(details, 0);
        lbDataType.setLayoutData((Object)"newline para");
        lbDataType.setText("Data Type:");
        final Text txDataType = new Text(details, 2056);
        txDataType.setLayoutData((Object)"w 0:0");
        Label lbUDTName = new Label(details, 0);
        lbUDTName.setText("UDT Name:");
        final Text txUDTName = new Text(details, 2056);
        txUDTName.setLayoutData((Object)"w 0:0");
        Label lbIdentifier = new Label(details, 0);
        lbIdentifier.setText("Identifier:");
        final Text txIdentifier = new Text(details, 2056);
        txIdentifier.setLayoutData((Object)"w 0:0");
        Label lbDefaultValue = new Label(details, 0);
        lbDefaultValue.setLayoutData((Object)"newline para");
        lbDefaultValue.setText("Default Value:");
        final Text txDefaultValue = new Text(details, 2056);
        txDefaultValue.setLayoutData((Object)"w 0:0");
        Label lbOptional = new Label(details, 0);
        lbOptional.setLayoutData((Object)"newline para");
        lbOptional.setText("Is Optional:");
        final Text txOptional = new Text(details, 2056);
        txOptional.setLayoutData((Object)"w 0:0");
        Label lbVirtual = new Label(details, 0);
        lbVirtual.setText("Is Virtual:");
        final Text txVirtual = new Text(details, 2056);
        txVirtual.setLayoutData((Object)"w 0:0");
        Label lbFailure = new Label(details, 0);
        lbFailure.setText("Is Failure:");
        final Text txFailure = new Text(details, 2056);
        txFailure.setLayoutData((Object)"w 0:0");
        this.cmTemplates.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ATParameterTemplate template = (ATParameterTemplate)((IStructuredSelection)event.getSelection()).getFirstElement();
                txTemplateName.setText(template.getTemplateName());
                txTemplateDescription.setText(template.getTemplateDescription());
                if (template.getName() != null) {
                    txName.setEnabled(true);
                    txName.setText(template.getName());
                } else {
                    txName.setEnabled(false);
                    txName.setText("<not specified>");
                }
                if (template.getAccessType() != null) {
                    txAccessType.setEnabled(true);
                    if (template.getAccessType() == ActivityConstants.AccessType.READ) {
                        txAccessType.setText("Input (READ)");
                    } else {
                        txAccessType.setText("Output (WRITE)");
                    }
                } else {
                    txAccessType.setEnabled(false);
                    txAccessType.setText("<not specified>");
                }
                if (template.getDescription() != null) {
                    txDescription.setEnabled(true);
                    txDescription.setText(template.getDescription());
                } else {
                    txDescription.setEnabled(false);
                    txDescription.setText("<not specified>");
                }
                if (template.getDataType() != null) {
                    txDataType.setEnabled(true);
                    txDataType.setText(template.getDataType().toString());
                } else {
                    txDataType.setEnabled(false);
                    txDataType.setText("<not specified>");
                }
                if (template.getUDTName() != null) {
                    txUDTName.setEnabled(true);
                    txUDTName.setText(template.getUDTName());
                } else {
                    txUDTName.setEnabled(false);
                    txUDTName.setText("<not specified>");
                }
                if (template.getIdentifierID() != null) {
                    txIdentifier.setEnabled(true);
                    UUID id = template.getIdentifierID();
                    if (ParameterTemplateSelectionDialogue.this.identifiers.containsKey(id)) {
                        String identifierText = "%s (%s)";
                        identifierText = String.format(identifierText, ((Identifier)ParameterTemplateSelectionDialogue.this.identifiers.get(id)).getName(), id);
                        txIdentifier.setText(identifierText);
                    } else {
                        txIdentifier.setText(id.toString());
                    }
                } else {
                    txIdentifier.setEnabled(false);
                    txIdentifier.setText("<not specified>");
                }
                if (template.getDefaultValue() != null) {
                    txDefaultValue.setEnabled(true);
                    txDefaultValue.setText(template.getDefaultValue());
                } else {
                    txDefaultValue.setEnabled(false);
                    txDefaultValue.setText("<not specified>");
                }
                if (template.isOptional() != null) {
                    txOptional.setEnabled(true);
                    if (template.isOptional().booleanValue()) {
                        txOptional.setText("yes");
                    } else {
                        txOptional.setText("no");
                    }
                } else {
                    txOptional.setEnabled(false);
                    txOptional.setText("<not specified>");
                }
                if (template.isVirtual() != null) {
                    txVirtual.setEnabled(true);
                    if (template.isVirtual().booleanValue()) {
                        txVirtual.setText("yes");
                    } else {
                        txVirtual.setText("no");
                    }
                } else {
                    txVirtual.setEnabled(false);
                    txVirtual.setText("<not specified>");
                }
                if (template.isFailure() != null) {
                    txFailure.setEnabled(true);
                    if (template.isFailure().booleanValue()) {
                        txFailure.setText("yes");
                    } else {
                        txFailure.setText("no");
                    }
                } else {
                    txFailure.setEnabled(false);
                    txFailure.setText("<not specified>");
                }
            }
        });
        this.cmTemplates.setSelection((ISelection)new StructuredSelection((Object)this.parameterTemplates.iterator().next()));
        return container;
    }

    protected void okPressed() {
        this.selectedTemplate = (ATParameterTemplate)((IStructuredSelection)this.cmTemplates.getSelection()).getFirstElement();
        super.okPressed();
    }

    public ATParameterTemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

