/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.changeoperations.VolatileNodeDependencyProvider;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.NodePnPWizardData;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.SystemDataConsumerDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PnPOverviewWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "general";
    final String nodeName;
    final String nodeDescription;
    final String nodeSAR;
    private final NodeKind nodeKind;
    NodePnPWizardData data;
    private static final Image arrowImage = ImageDescriptor.createFromFile(PnPOverviewWizardPage.class, (String)"arrow.png").createImage();
    Text newNodeName;
    Text newNodeDescription;
    Text newNodeSAR;
    Button newNodeAutoStart;
    private static Font boldFont;

    public PnPOverviewWizardPage(NodePnPWizardData data, String defaultName, String defaultDescription, String defaultSAR, NodeKind nodeKind) {
        super(PAGE_NAME);
        this.nodeName = defaultName;
        this.nodeDescription = defaultDescription;
        this.nodeKind = nodeKind;
        this.nodeSAR = defaultSAR;
        this.data = data;
        String title = "General Properties";
        String description = "This step helps you to reconfirm your choice of activity and allows you to adjust the most important node properties.";
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        ProcessConstants.NodeType nodeType;
        String displayedNodeName;
        Control titleLabel;
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(4, false);
        containerLayout.marginRight = 20;
        containerLayout.marginLeft = 20;
        container.setLayout((Layout)containerLayout);
        switch (this.nodeKind) {
            case ACTIVITY: {
                titleLabel = PnPOverviewWizardPage.createBoldLabel(container, String.format("Activity template '%s'", this.nodeName));
                displayedNodeName = this.nodeName;
                break;
            }
            case LWP: {
                titleLabel = PnPOverviewWizardPage.createBoldLabel(container, String.format("Sub-process template '%s'", this.nodeName));
                displayedNodeName = this.nodeName;
                break;
            }
            case NULL: {
                String nodeString = this.data.getNode().getName();
                if (nodeString.equals("")) {
                    nodeString = this.data.getNode().getID() == Integer.MIN_VALUE ? "new Node" : "#" + this.data.getNode().getID();
                }
                titleLabel = PnPOverviewWizardPage.createBoldLabel(container, String.format("Node '%s'", nodeString));
                displayedNodeName = nodeString;
                break;
            }
            default: {
                titleLabel = null;
                displayedNodeName = "";
            }
        }
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = -10;
        if (titleLabel != null) {
            titleLabel.setLayoutData((Object)gridData);
        }
        boolean isStartOrEndNode = false;
        int nodeID = this.data.getNode().getID();
        if (nodeID != Integer.MIN_VALUE && ((nodeType = this.data.getProcessTemplate().getNodeType(nodeID)) == ProcessConstants.NodeType.NT_STARTFLOW || nodeType == ProcessConstants.NodeType.NT_ENDFLOW)) {
            isStartOrEndNode = true;
        }
        Label activityNameLabel1 = new Label(container, 0);
        activityNameLabel1.setText("Name:");
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        activityNameLabel1.setLayoutData((Object)gridData);
        Label activityNameLabel2 = new Label(container, 0);
        activityNameLabel2.setText(displayedNodeName);
        gridData = new GridData(400, -1);
        gridData.horizontalSpan = 2;
        activityNameLabel2.setLayoutData((Object)gridData);
        Label activityDescriptionLabel1 = new Label(container, 0);
        activityDescriptionLabel1.setText("Description:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        activityDescriptionLabel1.setLayoutData((Object)gridData);
        Label activityDescriptionLabel2 = new Label(container, 64);
        activityDescriptionLabel2.setText(this.nodeDescription);
        gridData = new GridData(400, -1);
        gridData.horizontalSpan = 2;
        activityDescriptionLabel2.setLayoutData((Object)gridData);
        Control nodeTitleLabel = PnPOverviewWizardPage.createBoldLabel(container, "Adjust the Node properties");
        gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        gridData.horizontalIndent = -10;
        gridData.verticalIndent = 5;
        nodeTitleLabel.setLayoutData((Object)gridData);
        Label nodeNameLabel = new Label(container, 0);
        nodeNameLabel.setText("Node Name:");
        Button copyActivityName = new Button(container, 0);
        if (!this.nodeKind.equals((Object)NodeKind.NULL)) {
            copyActivityName.setImage(arrowImage);
            copyActivityName.setToolTipText("Click to use the name of the activity.");
            copyActivityName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PnPOverviewWizardPage.this.newNodeName.setText(PnPOverviewWizardPage.this.nodeName);
                    PnPOverviewWizardPage.this.newNodeName.setFocus();
                }
            });
        } else {
            copyActivityName.setVisible(false);
        }
        this.newNodeName = new Text(container, 2052);
        this.newNodeName.setText(this.data.getName());
        gridData = new GridData(4, 4, false, false);
        this.newNodeName.setLayoutData((Object)gridData);
        this.newNodeName.setFocus();
        Button editNodeName = new Button(container, 0);
        editNodeName.setText("Edit...");
        gridData = new GridData(4, 128, false, false);
        editNodeName.setLayoutData((Object)gridData);
        this.newNodeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PnPOverviewWizardPage.this.data.setName(PnPOverviewWizardPage.this.newNodeName.getText());
            }
        });
        editNodeName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                SystemDataConsumerDialogue dlg = new SystemDataConsumerDialogue(PnPOverviewWizardPage.this.getShell());
                dlg.setTitleAndMessage("Node Name", "Node Name", null);
                if (PnPOverviewWizardPage.this.data.getNode().getID() == Integer.MIN_VALUE) {
                    if (PnPOverviewWizardPage.this.data.getSelection().isEmpty() || !(PnPOverviewWizardPage.this.data.getSelection().getFirstElement() instanceof EdgeEditPart)) throw new RuntimeException("Inconsistent data: The node is not already contained in the template and the selection does not contain an edge.");
                    int destNodeID = ((EdgeEditPart)PnPOverviewWizardPage.this.data.getSelection().getFirstElement()).getDestNodeID();
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeName.getText(), (DependencyProvider)new VolatileNodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), destNodeID))) return;
                    PnPOverviewWizardPage.this.newNodeName.setText(dlg.getConsumerString());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeName.setFocus();
                    return;
                } else {
                    NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), PnPOverviewWizardPage.this.data.getNode().getID());
                    if (PnPOverviewWizardPage.this.data.getBindings() != null) {
                        for (Map.Entry<String, Dependency> binding : PnPOverviewWizardPage.this.data.getBindings().entrySet()) {
                            if (binding.getValue() == null) continue;
                            dependencyProvider.injectDependency(binding.getKey(), binding.getValue());
                        }
                    }
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeName.getText(), (DependencyProvider)dependencyProvider)) return;
                    PnPOverviewWizardPage.this.newNodeName.setText(dlg.getConsumerString());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeName.setFocus();
                }
            }
        });
        if (isStartOrEndNode) {
            this.newNodeName.setEditable(false);
            editNodeName.setEnabled(false);
        }
        Label nodeDescription = new Label(container, 0);
        nodeDescription.setText("Node Description:");
        gridData = new GridData(258);
        nodeDescription.setLayoutData((Object)gridData);
        Button copyActivityDescription = new Button(container, 0);
        if (!this.nodeKind.equals((Object)NodeKind.NULL)) {
            gridData = new GridData(258);
            copyActivityDescription.setLayoutData((Object)gridData);
            copyActivityDescription.setImage(arrowImage);
            copyActivityDescription.setToolTipText("Click to use the description of the activity.");
            copyActivityDescription.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PnPOverviewWizardPage.this.newNodeDescription.setText(PnPOverviewWizardPage.this.nodeDescription);
                    PnPOverviewWizardPage.this.newNodeDescription.setFocus();
                }
            });
        } else {
            copyActivityDescription.setVisible(false);
        }
        this.newNodeDescription = new Text(container, 2114);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 200;
        this.newNodeDescription.setLayoutData((Object)gridData);
        this.newNodeDescription.setText(this.data.getNode().getDescription());
        Button editNodeDescription = new Button(container, 0);
        editNodeDescription.setText("Edit...");
        gridData = new GridData(4, 128, false, false);
        editNodeDescription.setLayoutData((Object)gridData);
        this.newNodeDescription.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PnPOverviewWizardPage.this.data.setDescription(PnPOverviewWizardPage.this.newNodeDescription.getText());
            }
        });
        editNodeDescription.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                SystemDataConsumerDialogue dlg = new SystemDataConsumerDialogue(PnPOverviewWizardPage.this.getShell());
                dlg.setTitleAndMessage("Node Description", "Node Description", null);
                if (PnPOverviewWizardPage.this.data.getNode().getID() == Integer.MIN_VALUE) {
                    if (PnPOverviewWizardPage.this.data.getSelection().isEmpty() || !(PnPOverviewWizardPage.this.data.getSelection().getFirstElement() instanceof EdgeEditPart)) throw new RuntimeException("Inconsistent data: The node is not already contained in the template and the selection does not contain an edge.");
                    int destNodeID = ((EdgeEditPart)PnPOverviewWizardPage.this.data.getSelection().getFirstElement()).getDestNodeID();
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeDescription.getText(), true, (DependencyProvider)new VolatileNodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), destNodeID))) return;
                    PnPOverviewWizardPage.this.newNodeDescription.setText(dlg.getConsumerString());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeDescription.setFocus();
                    return;
                } else {
                    NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), PnPOverviewWizardPage.this.data.getNode().getID());
                    if (PnPOverviewWizardPage.this.data.getBindings() != null) {
                        for (Map.Entry<String, Dependency> binding : PnPOverviewWizardPage.this.data.getBindings().entrySet()) {
                            if (binding.getValue() == null) continue;
                            dependencyProvider.injectDependency(binding.getKey(), binding.getValue());
                        }
                    }
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeDescription.getText(), true, (DependencyProvider)dependencyProvider)) return;
                    PnPOverviewWizardPage.this.newNodeDescription.setText(dlg.getConsumerString());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeDescription.setFocus();
                }
            }
        });
        if (isStartOrEndNode) {
            this.newNodeDescription.setEditable(false);
            editNodeDescription.setEnabled(false);
        }
        Label nodeSARLabel = new Label(container, 0);
        nodeSARLabel.setText("Staff Assignment Rule:");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        nodeSARLabel.setLayoutData((Object)gridData);
        Button copySAR = new Button(container, 0);
        if (!this.nodeKind.equals((Object)NodeKind.NULL)) {
            copySAR.setImage(arrowImage);
            copySAR.setToolTipText("Click to use the Staff Assignment Rule of the activity.");
            gridData = new GridData();
            gridData.verticalAlignment = 128;
            copySAR.setLayoutData((Object)gridData);
            if (this.nodeSAR == null) {
                copySAR.setEnabled(false);
            }
            copySAR.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PnPOverviewWizardPage.this.newNodeSAR.setText(PnPOverviewWizardPage.this.nodeSAR);
                    PnPOverviewWizardPage.this.newNodeSAR.setFocus();
                }
            });
        } else {
            copySAR.setVisible(false);
        }
        this.newNodeSAR = new Text(container, 2050);
        gridData = new GridData(4, 4, true, true);
        this.newNodeSAR.setLayoutData((Object)gridData);
        this.newNodeSAR.setText(this.data.getStaffAssignmentRule());
        Button editSAR = new Button(container, 0);
        editSAR.setText("Edit...");
        gridData = new GridData(4, 128, false, false);
        editSAR.setLayoutData((Object)gridData);
        this.newNodeSAR.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PnPOverviewWizardPage.this.saveSAR(PnPOverviewWizardPage.this.newNodeSAR.getText())) {
                    PnPOverviewWizardPage.this.newNodeSAR.setForeground(Display.getCurrent().getSystemColor(21));
                } else {
                    PnPOverviewWizardPage.this.newNodeSAR.setForeground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        editSAR.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                StaffAssignmentRuleDialogue dlg = StaffAssignmentRuleDialogueRegistry.getProviders()[0].createDialogue(PnPOverviewWizardPage.this.getShell(), Activator.getAMService().getOrgModelManager());
                if (PnPOverviewWizardPage.this.data.getNode().getID() == Integer.MIN_VALUE) {
                    if (PnPOverviewWizardPage.this.data.getSelection().isEmpty() || !(PnPOverviewWizardPage.this.data.getSelection().getFirstElement() instanceof EdgeEditPart)) throw new RuntimeException("Inconsistent data: The node is not already contained in the template and the selection does not contain an edge.");
                    int destNodeID = ((EdgeEditPart)PnPOverviewWizardPage.this.data.getSelection().getFirstElement()).getDestNodeID();
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeSAR.getText(), (DependencyProvider)new VolatileNodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), destNodeID))) return;
                    PnPOverviewWizardPage.this.newNodeSAR.setText(dlg.getStaffAssignmentRule());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeSAR.setFocus();
                    if (UpdateNode.btnAutoStartEnabled((Template)PnPOverviewWizardPage.this.data.getProcessTemplate(), (Node)PnPOverviewWizardPage.this.data.getNode(), (String)dlg.getStaffAssignmentRule(), (Map)dlg.getParameterBindings())) {
                        PnPOverviewWizardPage.this.newNodeAutoStart.setEnabled(true);
                        return;
                    } else {
                        PnPOverviewWizardPage.this.newNodeAutoStart.setSelection(false);
                        PnPOverviewWizardPage.this.data.setAutoStart(false);
                        PnPOverviewWizardPage.this.newNodeAutoStart.setEnabled(false);
                    }
                    return;
                } else {
                    NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(PnPOverviewWizardPage.this.data.getProcessTemplate(), PnPOverviewWizardPage.this.data.getNode().getID());
                    if (PnPOverviewWizardPage.this.data.getBindings() != null) {
                        for (Map.Entry<String, Dependency> binding : PnPOverviewWizardPage.this.data.getBindings().entrySet()) {
                            if (binding.getValue() == null) continue;
                            dependencyProvider.injectDependency(binding.getKey(), binding.getValue());
                        }
                    }
                    if (!dlg.open(PnPOverviewWizardPage.this.newNodeSAR.getText(), (DependencyProvider)dependencyProvider)) return;
                    PnPOverviewWizardPage.this.newNodeSAR.setText(dlg.getStaffAssignmentRule());
                    PnPOverviewWizardPage.this.data.setBindings(dlg.getParameterBindings());
                    PnPOverviewWizardPage.this.newNodeSAR.setFocus();
                    if (UpdateNode.btnAutoStartEnabled((Template)PnPOverviewWizardPage.this.data.getProcessTemplate(), (Node)PnPOverviewWizardPage.this.data.getNode(), (String)dlg.getStaffAssignmentRule(), (Map)dlg.getParameterBindings())) {
                        PnPOverviewWizardPage.this.newNodeAutoStart.setEnabled(true);
                        return;
                    } else {
                        PnPOverviewWizardPage.this.newNodeAutoStart.setSelection(false);
                        PnPOverviewWizardPage.this.data.setAutoStart(false);
                        PnPOverviewWizardPage.this.newNodeAutoStart.setEnabled(false);
                    }
                }
            }
        });
        if (isStartOrEndNode) {
            this.newNodeSAR.setEditable(false);
            editSAR.setEnabled(false);
        }
        Label nodeAutoStartLabel = new Label(container, 0);
        nodeAutoStartLabel.setText("Auto start enabled:");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        nodeAutoStartLabel.setLayoutData((Object)gridData);
        String autoStartTooltip = "To set this option a dependent staff assignment rule is required. \nFor the node succeeding the start node the instance initiator must be assigned, \nfor every other node the performing agent of the preceding node must be assigned!";
        nodeAutoStartLabel.setToolTipText(autoStartTooltip);
        new Label(container, 0);
        this.newNodeAutoStart = new Button(container, 32);
        if (UpdateNode.btnAutoStartEnabled((Template)this.data.getProcessTemplate(), (Node)this.data.getNode(), (String)this.newNodeSAR.getText(), this.data.getBindings())) {
            this.newNodeAutoStart.setSelection(this.data.getNode().isAutoStartEnabled());
            this.newNodeAutoStart.setEnabled(true);
        } else {
            this.newNodeAutoStart.setSelection(false);
            this.newNodeAutoStart.setEnabled(false);
            this.data.setAutoStart(false);
        }
        this.newNodeAutoStart.setToolTipText(autoStartTooltip);
        this.newNodeAutoStart.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button btn = (Button)e.getSource();
                    PnPOverviewWizardPage.this.data.setAutoStart(btn.getSelection());
                }
            }
        });
        this.setControl((Control)container);
    }

    protected boolean saveSAR(String newSAR) {
        SessionToken session = Activator.getAMService().getSessionToken();
        if (newSAR.length() > 0) {
            try {
                OrgPolicyReport opr = Activator.getAMService().getOrgModelManager().getPolicyResolution().checkResolvability(session, newSAR, false, false);
                switch (opr.getOverallResult()) {
                    case ERROR: {
                        this.setErrorMessage("The staff assignment rule is invalid (click on \"Edit\" to see details).");
                        this.setPageComplete(false);
                        return false;
                    }
                }
            }
            catch (DataSourceException e) {
                this.setErrorMessage("An exception occured while checking the staff assignment rule: " + e.toString());
                this.setPageComplete(false);
                return false;
            }
        }
        this.data.setStaffAssignmentRule(newSAR);
        this.setPageComplete(true);
        this.setErrorMessage(null);
        return true;
    }

    public static Control createBoldLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        if (boldFont == null) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = label.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(1);
                ++n2;
            }
            boldFont = new Font((Device)label.getDisplay(), fontData);
        }
        label.setFont(boldFont);
        return label;
    }

    public static enum NodeKind {
        NULL,
        ACTIVITY,
        LWP;

    }
}

