/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.changeoperations.AssignExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.InsertNode;
import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.core.changeoperations.RemoveExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.changeoperations.UpdateNodeSystemDependency;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ActivityConfigurationPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ParameterCreationWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ParameterMappingWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PluginDataWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PnPOverviewWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.SubprocessTypeWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.VarParallelismWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.LWPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.NodePnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ParameterMappingEntry;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.VarParWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultLWPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultNodePnPWizardData;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.ui.util.wizard.ExtendedWizard;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PnPWizard
extends ExtendedWizard {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private final EBPPnPWizardData data;
    private final NodePnPWizardData nodeData;
    private final IStructuredSelection selection;
    private final IWorkbench workbench;
    private ExecutableComponentWizard executableComponentWizard = null;
    private PluginDataWizardPage pluginDataPage;

    public PnPWizard(IWorkbench workbench, IStructuredSelection selection, ActivityTemplate activityTemplate, Node node) {
        this.setHelpAvailable(false);
        this.workbench = workbench;
        this.selection = selection;
        String nodeString = node.getName();
        if (nodeString.equals("")) {
            nodeString = node.getID() == Integer.MIN_VALUE ? "new Node" : "#" + node.getID();
        }
        String devSuffix = "(in development)";
        if (node.getID() != Integer.MIN_VALUE) {
            if (activityTemplate.getState() == State.IN_DEVELOPMENT && !node.getName().endsWith(devSuffix)) {
                nodeString = String.valueOf(nodeString) + " " + devSuffix;
            } else if (activityTemplate.getState() != State.IN_DEVELOPMENT && node.getName().endsWith(devSuffix)) {
                nodeString = node.getName().substring(0, node.getName().length() - devSuffix.length()).trim();
            }
        } else {
            nodeString = activityTemplate.getState() == State.IN_DEVELOPMENT ? String.valueOf(activityTemplate.getActivityName()) + " " + devSuffix : activityTemplate.getActivityName();
        }
        String ebpName = activityTemplate.getActivityName();
        String title = String.format("Plugging in activity '%s' into node '%s'", ebpName, nodeString);
        this.setWindowTitle(title);
        this.nodeData = this.createNodeDataObject(node, nodeString);
        this.data = new DefaultActivityPnPWizardData(activityTemplate, null, this.nodeData);
    }

    public PnPWizard(IWorkbench workbench, IStructuredSelection selection, Template template, TemplateStatus status, Node node) {
        this.setHelpAvailable(false);
        this.selection = selection;
        this.workbench = workbench;
        String nodeString = node.getName();
        if (nodeString.equals("")) {
            nodeString = node.getID() == Integer.MIN_VALUE ? "new Node" : "#" + node.getID();
        }
        String ebpName = template.getName();
        String title = String.format("Plugging in template '%s' into node '%s' as subprocess", ebpName, nodeString);
        this.setWindowTitle(title);
        this.nodeData = this.createNodeDataObject(node, nodeString);
        this.data = new DefaultLWPPnPWizardData(null, template, status, this.nodeData);
    }

    public PnPWizard(IWorkbench workbench, IStructuredSelection selection, Node node) {
        this.setHelpAvailable(false);
        this.workbench = workbench;
        this.selection = selection;
        String nodeString = node.getName();
        if (nodeString.equals("")) {
            nodeString = node.getID() == Integer.MIN_VALUE ? "new Node" : "#" + node.getID();
        }
        String title = String.format("Adjust properties of node '%s'", nodeString);
        this.setWindowTitle(title);
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        SessionToken session = Activator.getAMService().getSessionToken();
        if (ebp instanceof Activity) {
            String branchString;
            String msg;
            Activity activity = (Activity)ebp;
            ActivityRepository ar = Activator.getAMService().getActivityRepository();
            ActivityTemplate activityTemplate = null;
            try {
                activityTemplate = ar.getActivityTemplate(session, activity.getID());
            }
            catch (UnknownEntityException unknownEntityException) {
                msg = "The activity template with ID '%s' was not found in the activity repository.";
                msg = String.format(msg, activity.getID(), activity.getExecutableComponentName(), activity.getOperationName(), activity.getActivityName());
                this.logger.warning(msg);
            }
            if (activityTemplate == null && (branchString = activity.getUserAttributeValue("fromDevelopmentBranch")) != null) {
                try {
                    long branch = Long.parseLong(branchString);
                    try {
                        activityTemplate = ar.getDevelopmentActivityTemplate(session, activity.getExecutableComponentName(), activity.getOperationName(), activity.getActivityName(), branch);
                    }
                    catch (UnknownEntityException unknownEntityException) {
                        String msg2 = "No activity template '%s' of ECD '%s' and Operation '%s' found in branch %d.";
                        msg2 = String.format(msg2, activity.getActivityName(), activity.getExecutableComponentName(), activity.getOperationName(), branch);
                        this.logger.warning(msg2);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (activityTemplate == null) {
                try {
                    activityTemplate = ar.getLatestActivityTemplate(session, activity.getExecutableComponentName(), activity.getOperationName(), activity.getActivityName());
                }
                catch (UnknownEntityException unknownEntityException) {
                    msg = "No released activity template '%s' of ECD '%s' and Operation '%s' found.";
                    msg = String.format(msg, activity.getActivityName(), activity.getExecutableComponentName(), activity.getOperationName());
                    this.logger.warning(msg);
                }
            }
            this.nodeData = this.createNodeDataObject(node, nodeString);
            this.data = new DefaultActivityPnPWizardData(activityTemplate, activity, this.nodeData);
        } else if (ebp instanceof VariableParallelismEBP || ebp instanceof LightWeightProcess) {
            boolean isVarPar = ebp instanceof VariableParallelismEBP;
            VariableParallelismEBP varPar = null;
            if (isVarPar) {
                varPar = (VariableParallelismEBP)ebp;
                ebp = varPar.getLightWeightProcess();
            }
            Template template = null;
            TemplateStatus status = null;
            if (ebp instanceof EmbeddedProcess) {
                EmbeddedProcess ep = (EmbeddedProcess)ebp;
                template = ep.getTemplate();
            } else if (ebp instanceof ReferencedProcess) {
                ReferencedProcess rp = (ReferencedProcess)ebp;
                TemplateManager templateManager = Activator.getService().getProcessManager().getTemplateManager();
                template = templateManager.getTemplate(session, rp.getTemplateID());
                status = templateManager.getTemplateStatus(session, rp.getTemplateID());
                ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
                pmf.setCreateChangeable(true);
                template = pmf.cloneTemplate(template);
            } else {
                throw new IllegalArgumentException("ebp type unkown");
            }
            this.nodeData = this.createNodeDataObject(node, nodeString);
            this.data = isVarPar ? new DefaultLWPPnPWizardData(varPar, template, status, this.nodeData) : new DefaultLWPPnPWizardData((LightWeightProcess)ebp, template, status, this.nodeData);
        } else {
            this.nodeData = this.createNodeDataObject(node, nodeString);
            this.data = null;
        }
    }

    private NodePnPWizardData createNodeDataObject(Node node, String nodeName) {
        IEditorPart editorPart = this.workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Instance instance = null;
        Template template = null;
        if (!(editorPart instanceof Editor)) {
            throw new RuntimeException("Error: Drop area is not an ADEPT2-Editor");
        }
        Editor editor = (Editor)editorPart;
        if (!(editor.getTemplate() instanceof ChangeableTemplate) && !(editor.getInstance() instanceof ChangeableInstance)) {
            throw new IllegalArgumentException("The wizard may only be used with changeable objects.");
        }
        instance = editor.getInstance();
        template = instance != null ? instance.getTemplate() : editor.getTemplate();
        HashMap<String, Dependency> bindings = new HashMap<String, Dependency>();
        if (node.getID() != Integer.MIN_VALUE) {
            NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(template, node.getID());
            ParameterRef[] parameterRefArray = dependencyProvider.getParameters();
            int n = parameterRefArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterRef param = parameterRefArray[n2];
                Dependency dependency = dependencyProvider.getDependencyOf(param.getName());
                bindings.put(param.getName(), dependency);
                ++n2;
            }
        }
        return new DefaultNodePnPWizardData(template, instance, nodeName, node.getDescription(), node, node.isAutoStartEnabled(), bindings, this.selection);
    }

    public void addPages() {
        String nodeSAR;
        String nodeDescription;
        String nodeName;
        if (this.data instanceof ActivityPnPWizardData && this.data.getActivityTemplate() != null) {
            nodeName = this.data.getActivityTemplate().getActivityName();
            String devSuffix = "(in development)";
            if (this.data.getActivityTemplate().getState() == State.IN_DEVELOPMENT && !nodeName.endsWith(devSuffix)) {
                nodeName = String.valueOf(nodeName) + " " + devSuffix;
            }
            nodeDescription = this.data.getActivityTemplate().getDescription();
            nodeSAR = this.data.getActivityTemplate().getStaffAssignmentRule();
        } else if (this.data instanceof LWPPnPWizardData) {
            LWPPnPWizardData lwpData = (LWPPnPWizardData)this.data;
            Template template = lwpData.getTemplate();
            nodeName = "";
            if (template != null) {
                nodeName = template.getName();
                nodeDescription = template.getDescription();
            } else if (lwpData.getOriginalEBP() instanceof EmbeddedProcess) {
                EmbeddedProcess ep = (EmbeddedProcess)lwpData.getOriginalEBP();
                nodeName = ep.getTemplate().getName();
                nodeDescription = ep.getTemplate().getDescription();
            } else if (lwpData.getOriginalEBP() instanceof ReferencedProcess) {
                ReferencedProcess rp = (ReferencedProcess)lwpData.getOriginalEBP();
                nodeName = "#" + String.valueOf(rp.getTemplateID());
            }
            nodeDescription = "The process template " + nodeName + " used as sub-process.";
            nodeSAR = null;
        } else {
            nodeName = this.nodeData.getNode().getName();
            if (nodeName.equals("")) {
                nodeName = "#" + Integer.toString(this.nodeData.getNode().getID());
            }
            nodeDescription = this.nodeData.getNode().getDescription();
            nodeSAR = null;
        }
        PnPOverviewWizardPage.NodeKind nodeKind = this.data instanceof ActivityPnPWizardData ? PnPOverviewWizardPage.NodeKind.ACTIVITY : (this.data instanceof LWPPnPWizardData ? PnPOverviewWizardPage.NodeKind.LWP : PnPOverviewWizardPage.NodeKind.NULL);
        PnPOverviewWizardPage pnpOverviewWizardPage = new PnPOverviewWizardPage(this.nodeData, nodeName, nodeDescription, nodeSAR, nodeKind);
        this.addPage((IWizardPage)pnpOverviewWizardPage);
        if (this.data instanceof LWPPnPWizardData) {
            this.addSection("subprocess", "Subprocess", null);
            SubprocessTypeWizardPage subProcessPage = new SubprocessTypeWizardPage((LWPPnPWizardData)this.data);
            this.addPage((IWizardPage)subProcessPage, "subprocess");
            VarParallelismWizardPage varParPage = new VarParallelismWizardPage((VarParWizardData)this.data);
            this.addPage((IWizardPage)varParPage, "subprocess");
        }
        this.pluginDataPage = new PluginDataWizardPage(this.nodeData);
        if (this.data instanceof ActivityPnPWizardData) {
            String value;
            ActivityPnPWizardData actData = (ActivityPnPWizardData)this.data;
            String ecName = actData.getExecutableComponentName();
            int index = ecName.lastIndexOf(46);
            String simpleECName = index == -1 ? ecName : ecName.substring(index + 1);
            String sectionTitle = String.format("Activity (%s)", simpleECName);
            String sectionTooltip22 = String.format("Activity: %s", ecName);
            this.addSection("activity", sectionTitle, sectionTooltip22);
            IConfigurationElement[] activityTypeWizardPageSets = Platform.getExtensionRegistry().getConfigurationElementsFor("de.aristaflow.adept2.adept2plugin.executableComponentWizard");
            IConfigurationElement matchingWizard = null;
            IConfigurationElement[] iConfigurationElementArray = activityTypeWizardPageSets;
            int n = activityTypeWizardPageSets.length;
            int sectionTooltip22 = 0;
            while (sectionTooltip22 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[sectionTooltip22];
                if (ecName.equals(configurationElement.getAttribute("executableComponentName"))) {
                    matchingWizard = configurationElement;
                    break;
                }
                ++sectionTooltip22;
            }
            boolean showParameterPage = true;
            if (matchingWizard != null && (value = matchingWizard.getAttribute("showParameterPage")) != null) {
                showParameterPage = Boolean.parseBoolean(value);
            }
            if (actData.getActivityTemplate() != null && actData.getActivityTemplate().getParameterChangePolicy() != ParameterChangePolicy.FIXED && actData.getActivityTemplate().getParameterChangePolicy() != ParameterChangePolicy.ADD_VIRTUAL && showParameterPage || actData.getActivityTemplate() == null && showParameterPage) {
                this.addPage((IWizardPage)new ParameterCreationWizardPage(actData));
            }
            if (matchingWizard != null) {
                try {
                    this.executableComponentWizard = (ExecutableComponentWizard)matchingWizard.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    String message = String.format("Caught a core exception while instantiating a new type specific wizard page (class: %s). ", matchingWizard.getAttribute("class"));
                    this.logger.log(Level.SEVERE, message, ex);
                }
            }
            if (this.executableComponentWizard != null) {
                this.executableComponentWizard.init(actData);
                IWizardPage[] iWizardPageArray = this.executableComponentWizard.getPages();
                int n2 = iWizardPageArray.length;
                int message = 0;
                while (message < n2) {
                    IWizardPage page = iWizardPageArray[message];
                    this.addPage(page, "activity");
                    ++message;
                }
            } else {
                boolean hasConfiguration = false;
                ConfigurationDescription confDesc = null;
                if (actData.getActivityTemplate() != null) {
                    confDesc = actData.getActivityTemplate().getConfigurationDescription();
                    hasConfiguration = actData.getActivityTemplate().getConfigurationDescription().getEntries().size() > 0;
                }
                boolean bl = hasConfiguration = hasConfiguration || actData.getOriginalEBP() != null && actData.getOriginalEBP().getConfiguration().getAllEntries().size() > 0;
                if (hasConfiguration) {
                    this.addPage((IWizardPage)new ActivityConfigurationPage(actData, confDesc), "activity");
                }
            }
        }
        if (this.data != null) {
            this.addPage((IWizardPage)new ParameterMappingWizardPage(this.data));
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        if (this.executableComponentWizard != null) {
            this.executableComponentWizard.performFinish();
        }
        SessionToken session = Activator.getService().getSessionToken();
        UpdateManager updateManager = Activator.getService().getUpdateManager();
        Template template = this.nodeData.getProcessTemplate();
        Node node = this.nodeData.getNode();
        ChangeableInstance instance = (ChangeableInstance)this.nodeData.getProcessInstance();
        URI base = instance != null ? ProcessElementIdentifierTools.getInstanceIdentifier((String)"localhost", (Instance)instance) : ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost");
        CheckReport checkReport = new CheckReport(base);
        if (node.getID() == Integer.MIN_VALUE) {
            this.startChangeTransaction();
            if (!this.selection.isEmpty() && this.selection.getFirstElement() instanceof EdgeEditPart) {
                EdgeEditPart edge = (EdgeEditPart)this.selection.getFirstElement();
                int srcNodeID = edge.getSourceNodeID();
                int destNodeID = edge.getDestNodeID();
                Node pred = template.getNode(srcNodeID);
                Node succ = template.getNode(destNodeID);
                if (instance != null) {
                    if (InsertNode.isPossible((Instance)instance, (Node)pred, (Node)succ, (CheckReport)checkReport)) {
                        node = InsertNode.performOperation((SessionToken)session, (ChangeableInstance)instance, (Node)pred, (Node)succ, (UpdateManager)updateManager);
                    }
                } else if (InsertNode.isPossible((Template)template, (Node)pred, (Node)succ, (CheckReport)checkReport)) {
                    node = InsertNode.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)pred, (Node)succ, (UpdateManager)updateManager);
                }
            } else {
                String message = "Programming error: The edit part of the selection is not of type edge edit part.";
                this.logger.severe(message);
                throw new RuntimeException(message);
            }
            this.endChangeTransaction();
        } else if (node.getExecutableBusinessProcess() != null) {
            this.startChangeTransaction();
            if (instance != null) {
                if (RemoveExecutableBusinessProcess.isPossible((ChangeableInstance)instance, (Node)node, (CheckReport)checkReport)) {
                    RemoveExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableInstance)instance, (Node)node, (UpdateManager)updateManager);
                }
            } else if (RemoveExecutableBusinessProcess.isPossible((Template)template, (Node)node, (CheckReport)checkReport)) {
                RemoveExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)node, (UpdateManager)updateManager);
            }
            this.endChangeTransaction();
        }
        this.startChangeTransaction();
        Node tempNode = Activator.getService().getProcessModelFactory().createNode(node.getID(), this.nodeData.getName(), this.nodeData.getDescription(), this.nodeData.getStaffAssignmentRule(), null, this.nodeData.getAutoStart(), null, null, null, null, null, null);
        this.updateProperties(session, tempNode, tempNode.getName(), this.nodeData.getBindings(), ProcessConstants.NodeProperty.NAME, updateManager);
        this.updateProperties(session, tempNode, tempNode.getDescription(), this.nodeData.getBindings(), ProcessConstants.NodeProperty.DESCRIPTION, updateManager);
        this.updateProperties(session, tempNode, tempNode.getStaffAssignmentRule(), this.nodeData.getBindings(), ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE, updateManager);
        if (instance != null) {
            if (UpdateNode.isPossible((ChangeableInstance)instance, (Node)node, (CheckReport)checkReport, (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START})) {
                UpdateNode.performOperation((ChangeableInstance)instance, (Node)tempNode, (UpdateManager)updateManager, (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START});
            }
        } else if (UpdateNode.isPossible((Template)template, (Node)node, (CheckReport)checkReport, (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START})) {
            UpdateNode.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (Node)tempNode, (UpdateManager)updateManager, (ProcessConstants.NodeProperty[])new ProcessConstants.NodeProperty[]{ProcessConstants.NodeProperty.AUTO_START});
        }
        this.endChangeTransaction();
        if (this.data != null) {
            HashMap paramsWithoutExistingDataElements = new HashMap();
            HashMap paramsWithExistingDataElements = new HashMap();
            HashMap paramsWithExistingDataElementsIP = new HashMap();
            boolean fork = false;
            if (this.data instanceof LWPPnPWizardData) {
                fork = ((LWPPnPWizardData)this.data).getTemplateUsage().equals((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.FORKED);
            }
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                Map<ProcessModelParameter, ParameterMappingEntry> parameterMapping = this.data.getParameterMapping(accessType);
                HashMap<ProcessModelParameter, ProcessConstants.DataMappingType> paramTypeMap = new HashMap<ProcessModelParameter, ProcessConstants.DataMappingType>();
                paramsWithoutExistingDataElements.put(accessType, paramTypeMap);
                HashMap<ProcessModelParameter, Integer> paramElementMap = new HashMap<ProcessModelParameter, Integer>();
                HashMap<ProcessModelParameter, DataElement> paramElementMapIP = new HashMap<ProcessModelParameter, DataElement>();
                paramsWithExistingDataElements.put(accessType, paramElementMap);
                paramsWithExistingDataElementsIP.put(accessType, paramElementMapIP);
                for (Map.Entry<ProcessModelParameter, ParameterMappingEntry> entry : parameterMapping.entrySet()) {
                    ProcessConstants.DataMappingType dataMappingType = fork && accessType == ActivityConstants.AccessType.WRITE ? ProcessConstants.DataMappingType.DISABLE : entry.getValue().type;
                    if (dataMappingType != ProcessConstants.DataMappingType.DATAELEMENT) {
                        paramTypeMap.put(entry.getKey(), dataMappingType);
                        continue;
                    }
                    paramElementMap.put(entry.getKey(), entry.getValue().element.getID());
                    paramElementMapIP.put(entry.getKey(), entry.getValue().element);
                }
                ++n2;
            }
            this.startChangeTransaction();
            this.logger.fine("PnP Wizard: EBP data has been changed, EBP will be replaced.");
            ExecutableBusinessProcess ebp = this.data.createChangedEBP();
            if (instance != null) {
                if (AssignExecutableBusinessProcess.isPossible((ChangeableInstance)instance, (Node)node, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElementsIP, (CheckReport)checkReport)) {
                    AssignExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableInstance)instance, (Node)node, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, (UpdateManager)updateManager);
                }
            } else if (AssignExecutableBusinessProcess.isPossible((Template)template, (Node)node, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElementsIP, (CheckReport)checkReport)) {
                AssignExecutableBusinessProcess.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)node, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, (UpdateManager)updateManager);
            }
            this.endChangeTransaction();
        }
        if (checkReport.getCheckResult().ordinal() > CheckReport.ResultType.INFO.ordinal()) {
            String message = "One or more change operations of the wizard did not succeed! Report:\n" + checkReport.getReportSummary();
            this.logger.severe(message);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error changing the template!", (String)message);
        }
        if (this.getViewer().getEditPartRegistry().containsKey(node)) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            SelectionManager selectionManager = null;
            if (editor instanceof Editor) {
                selectionManager = ((Editor)editor).getSelectionManager();
            }
            if (selectionManager != null) {
                IProcessEditPart partToSelect = (IProcessEditPart)this.getViewer().getEditPartRegistry().get(node);
                selectionManager.editPartClicked(partToSelect, false);
            }
        }
        return true;
    }

    private void updateProperties(SessionToken session, Node tempNode, String propertyString, Map<String, Dependency> paramBinding, ProcessConstants.NodeProperty property, UpdateManager updateManager) {
        Template template = this.nodeData.getProcessTemplate();
        Instance instance = this.nodeData.getProcessInstance();
        if (paramBinding == null) {
            ParameterRef[] refs = SystemDataTools.findParameterReferences((String)propertyString);
            paramBinding = new HashMap<String, Dependency>();
            ParameterRef[] parameterRefArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterRef ref = parameterRefArray[n2];
                paramBinding.put(ref.getName(), null);
                ++n2;
            }
        }
        if (instance != null) {
            if (UpdateNodeSystemDependency.isPossible((ChangeableInstance)((ChangeableInstance)instance), (Node)tempNode, paramBinding, (ProcessConstants.NodeProperty)property)) {
                UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableInstance)((ChangeableInstance)instance), (Node)tempNode, paramBinding, (ProcessConstants.NodeProperty)property, (UpdateManager)updateManager);
            } else {
                this.logger.severe("Updating the property '" + property.toString() + "' is not possible!");
            }
        } else if (UpdateNodeSystemDependency.isPossible((Template)template, (Node)tempNode, paramBinding, (ProcessConstants.NodeProperty)property)) {
            UpdateNodeSystemDependency.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)tempNode, paramBinding, (ProcessConstants.NodeProperty)property, (UpdateManager)updateManager);
        } else {
            this.logger.severe("Updating the property '" + property.toString() + "' is not possible!");
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void startChangeTransaction() {
        ChangeableInstance instance = (ChangeableInstance)this.nodeData.getProcessInstance();
        if (instance != null) {
            Template oldTemplate = instance.getTemplate();
            StartTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)Activator.getService().getUpdateManager());
            Template newTemplate = instance.getTemplate();
            if (oldTemplate != newTemplate) {
                this.getViewer().setContents((Object)newTemplate);
                this.updateSelectionManager(newTemplate);
            }
        } else {
            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.nodeData.getProcessTemplate()), (UpdateManager)Activator.getService().getUpdateManager());
        }
    }

    protected void endChangeTransaction() {
        String transactionLabel = "Activity / node data of node " + this.nodeData.getName();
        if (this.nodeData.getProcessInstance() != null) {
            EndTransaction.performOperation((ChangeableInstance)((ChangeableInstance)this.nodeData.getProcessInstance()), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        } else {
            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.nodeData.getProcessTemplate()), (UpdateManager)Activator.getService().getUpdateManager(), (String)transactionLabel);
        }
    }

    protected GraphicalViewer getViewer() {
        GraphicalViewer viewer = null;
        IEditorPart ed = this.workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (ed instanceof Editor) {
            viewer = (GraphicalViewer)((Editor)ed).getAdapter(GraphicalViewer.class);
        }
        return viewer;
    }

    private void updateSelectionManager(Template newTemplate) {
        SelectionManager manager = this.getSelectionManager();
        if (manager != null) {
            SelectionGroupDefinition definition = manager.getActiveGroup().getDefinition();
            manager.updateSelectionReferencesForGroup(newTemplate, definition);
        }
    }

    protected SelectionManager getSelectionManager() {
        IEditorPart ed = this.workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SelectionManager manager = null;
        if (ed instanceof Editor) {
            manager = ((Editor)ed).getSelectionManager();
        }
        return manager;
    }
}

