/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.LWPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultLWPPnPWizardData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SubprocessTypeWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "subprocessType";
    protected LWPPnPWizardData data;

    public SubprocessTypeWizardPage(LWPPnPWizardData data) {
        super(PAGE_NAME, "Subprocess Type", null);
        this.setDescription("Define the way the process template should be inserted in the parent process.");
        this.data = data;
    }

    public void createControl(Composite parent) {
        Label separator;
        GridData layoutData;
        String msg;
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite container = toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginRight = 20;
        containerLayout.marginLeft = 20;
        container.setLayout((Layout)containerLayout);
        boolean disabled = false;
        if (this.data.noUsage()) {
            msg = "The template status does not allow to use this template as subprocess any more, \nin none of the possible forms. The usage could not be changed and will remain \nas before. During runtime this could lead to an exception!";
            Text noUsageText = toolkit.createText(container, msg, 66);
            layoutData = new GridData(0, 0x1000000, true, false);
            layoutData.horizontalSpan = 2;
            noUsageText.setLayoutData((Object)layoutData);
            noUsageText.setEditable(false);
            noUsageText.setForeground(container.getDisplay().getSystemColor(3));
            separator = toolkit.createSeparator(container, 256);
            layoutData = new GridData(4, 0x1000000, true, false);
            layoutData.horizontalSpan = 2;
            separator.setLayoutData((Object)layoutData);
        }
        final Button embeddedBtn = toolkit.createButton(container, "embedded", 16);
        layoutData = new GridData(0, 128, false, false);
        embeddedBtn.setLayoutData((Object)layoutData);
        embeddedBtn.setEnabled(this.data.getPossibleTemplateUsageValues().contains((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.EMBEDDED));
        embeddedBtn.setSelection(this.data.getTemplateUsage().equals((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.EMBEDDED));
        embeddedBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (embeddedBtn.getSelection()) {
                    SubprocessTypeWizardPage.this.data.setTemplateUsage(DefaultLWPPnPWizardData.PossibleTemplateUsage.EMBEDDED);
                }
            }
        });
        Label embeddedLbl = toolkit.createLabel(container, "", 0);
        layoutData = new GridData(0, 0x1000000, true, false);
        embeddedLbl.setLayoutData((Object)layoutData);
        if (!embeddedBtn.getEnabled()) {
            disabled = true;
            embeddedLbl.setText("The template could not be used as embedded subprocess, \nsince the template status does not allow the usage as copy.");
            embeddedLbl.setForeground(parent.getDisplay().getSystemColor(9));
        }
        msg = "To be used as embedded process, the subprocess usage in the template status \nmust be set to 'AS_COPY' or 'COPY_OR_REFERENCE'. A local template that has \nno template status is only allowed to be inserted as embedded copy.";
        Text embeddedText = toolkit.createText(container, msg, 66);
        layoutData = new GridData(0, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        embeddedText.setLayoutData((Object)layoutData);
        embeddedText.setEditable(false);
        separator = toolkit.createSeparator(container, 256);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        separator.setLayoutData((Object)layoutData);
        final Button referencedBtn = toolkit.createButton(container, "referenced", 16);
        layoutData = new GridData(0, 128, false, false);
        referencedBtn.setLayoutData((Object)layoutData);
        referencedBtn.setEnabled(this.data.getPossibleTemplateUsageValues().contains((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.REFERENCED));
        referencedBtn.setSelection(this.data.getTemplateUsage().equals((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.REFERENCED));
        referencedBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (referencedBtn.getSelection()) {
                    SubprocessTypeWizardPage.this.data.setTemplateUsage(DefaultLWPPnPWizardData.PossibleTemplateUsage.REFERENCED);
                }
            }
        });
        Label referencedLbl = toolkit.createLabel(container, "", 0);
        layoutData = new GridData(0, 0x1000000, true, false);
        referencedLbl.setLayoutData((Object)layoutData);
        if (!referencedBtn.getEnabled()) {
            disabled = true;
            referencedLbl.setText("The template could not be used as referenced subprocess, \nsince the template status does not allow the usage as reference.");
            referencedLbl.setForeground(parent.getDisplay().getSystemColor(9));
        }
        msg = "To be used as referenced process, the subprocess usage in the template status \nmust be set to 'AS_REFERENCE' or 'COPY_OR_REFERENCE'.";
        Text referencedText = toolkit.createText(container, msg, 66);
        layoutData = new GridData(0, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        referencedText.setLayoutData((Object)layoutData);
        referencedText.setEditable(false);
        separator = toolkit.createSeparator(container, 256);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        separator.setLayoutData((Object)layoutData);
        final Button forkedBtn = toolkit.createButton(container, "forked", 16);
        layoutData = new GridData(0, 128, false, false);
        forkedBtn.setLayoutData((Object)layoutData);
        forkedBtn.setEnabled(this.data.getPossibleTemplateUsageValues().contains((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.FORKED));
        forkedBtn.setSelection(this.data.getTemplateUsage().equals((Object)DefaultLWPPnPWizardData.PossibleTemplateUsage.FORKED));
        forkedBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (forkedBtn.getSelection()) {
                    SubprocessTypeWizardPage.this.data.setTemplateUsage(DefaultLWPPnPWizardData.PossibleTemplateUsage.FORKED);
                    SubprocessTypeWizardPage.this.data.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.FORK_CHANGED, Boolean.TRUE);
                } else {
                    SubprocessTypeWizardPage.this.data.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.FORK_CHANGED, Boolean.FALSE);
                }
            }
        });
        Label forkedLbl = toolkit.createLabel(container, "", 0);
        layoutData = new GridData(0, 0x1000000, true, false);
        forkedLbl.setLayoutData((Object)layoutData);
        if (!forkedBtn.getEnabled()) {
            disabled = true;
            forkedLbl.setText("The template could not be used as forked subprocess, \nsince the template status does not allow the usage as fork.");
            forkedLbl.setForeground(parent.getDisplay().getSystemColor(9));
        }
        msg = "To be used as forked process, the subprocess usage in the template status \nis not relevant, but the template has to be usable as 'TOP-LEVEL-PROCESS'. \nExisting template output parameters will be disabled!";
        Text forkedText = toolkit.createText(container, msg, 66);
        layoutData = new GridData(0, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        forkedText.setLayoutData((Object)layoutData);
        forkedText.setEditable(false);
        if (disabled) {
            separator = toolkit.createSeparator(container, 256);
            layoutData = new GridData(4, 0x1000000, true, false);
            layoutData.horizontalSpan = 2;
            separator.setLayoutData((Object)layoutData);
            msg = "If the subprocess template is on the server, you can try to change the possible way \nof subprocess usage in the template status to get more options. \nIf it is a local template, you can only insert it as copy. If the template was \ninserted as embedded process, the relation to the original template (status) is lost, \nso you have to drop the template again to change the usage.";
            Label disabledLbL = toolkit.createLabel(container, msg, 0);
            layoutData = new GridData(0, 0x1000000, true, false);
            layoutData.horizontalSpan = 2;
            disabledLbL.setLayoutData((Object)layoutData);
            disabledLbL.setForeground(parent.getDisplay().getSystemColor(9));
        }
        this.setControl((Control)container);
    }
}

