/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.VarParWizardData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VarParallelismWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "varpar";
    private static final String INFO = "At least one input parameter must be selected";
    private static final int MINIMAL_COL_WIDTH = 150;
    protected VarParWizardData data;
    Table table;
    Map<String, ProcessModelParameter> paramNameToOriginalOutputParam = new HashMap<String, ProcessModelParameter>();
    Map<String, ProcessModelParameter> paramNameToOriginalInputParam = new HashMap<String, ProcessModelParameter>();

    public VarParallelismWizardPage(VarParWizardData data) {
        super(PAGE_NAME, "Variable Parallelism", null);
        this.setDescription("Define if the subprocess should be started multiple times using the data contained in a list (variable paralellism)");
        this.data = data;
    }

    public void createControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite container = toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginRight = 20;
        containerLayout.marginLeft = 20;
        container.setLayout((Layout)containerLayout);
        Button varParButton = toolkit.createButton(container, "Enable variable paralellism", 32);
        GridData layoutData = new GridData(0, 128, false, false);
        varParButton.setLayoutData((Object)layoutData);
        Label separator = toolkit.createSeparator(container, 256);
        layoutData = new GridData(4, 4, true, false);
        separator.setLayoutData((Object)layoutData);
        final Label varParLabel = toolkit.createLabel(container, "Choose the input parameters which should get their value from a list entry of the top-level process.", 64);
        layoutData = new GridData(0, 128, false, false);
        varParLabel.setLayoutData((Object)layoutData);
        this.table = toolkit.createTable(container, 67616);
        layoutData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)layoutData);
        final ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        String[] stringArray = new String[]{"Name", "Data Type"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnName);
            column.setWidth(150);
            columns.add(column);
            ++n2;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(this.table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new InputParamLabelProvider());
        viewer.setInput(this.data.getParameters(ActivityConstants.AccessType.READ));
        varParButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ((Button)e.getSource()).getSelection();
                varParLabel.setEnabled(selection);
                VarParallelismWizardPage.this.table.setEnabled(selection);
                VarParallelismWizardPage.this.data.setVariableParallelism(true);
                if (selection) {
                    for (ProcessModelParameter param : VarParallelismWizardPage.this.data.getIndexedInputParameters()) {
                        VarParallelismWizardPage.this.data.changeParameter(VarParallelismWizardPage.this.paramNameToOriginalInputParam.get(param.getName()), param, ActivityConstants.AccessType.READ);
                    }
                    for (ProcessModelParameter param : VarParallelismWizardPage.this.data.getOutputParameters()) {
                        VarParallelismWizardPage.this.data.changeParameter(VarParallelismWizardPage.this.paramNameToOriginalOutputParam.get(param.getName()), param, ActivityConstants.AccessType.WRITE);
                    }
                    if (VarParallelismWizardPage.this.data.getIndexedInputParameters().isEmpty()) {
                        VarParallelismWizardPage.this.setMessage(VarParallelismWizardPage.INFO, 1);
                        VarParallelismWizardPage.this.setPageComplete(false);
                    }
                } else {
                    VarParallelismWizardPage.this.setMessage(null);
                    VarParallelismWizardPage.this.setPageComplete(true);
                    if (!selection) {
                        VarParallelismWizardPage.this.data.setVariableParallelism(false);
                        for (ProcessModelParameter param : VarParallelismWizardPage.this.data.getOutputParameters()) {
                            VarParallelismWizardPage.this.data.changeParameter(param, VarParallelismWizardPage.this.paramNameToOriginalOutputParam.get(param.getName()), ActivityConstants.AccessType.WRITE);
                        }
                        for (ProcessModelParameter param : VarParallelismWizardPage.this.data.getIndexedInputParameters()) {
                            VarParallelismWizardPage.this.data.changeParameter(param, VarParallelismWizardPage.this.paramNameToOriginalInputParam.get(param.getName()), ActivityConstants.AccessType.READ);
                        }
                    }
                }
            }
        });
        this.table.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                VarParallelismWizardPage.this.reactOnResizeEvent(columns.toArray(new TableColumn[0]));
            }
        });
        final Map<String, ProcessModelParameter> paramNameToParam = this.createListInputParameters();
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem item = (TableItem)event.item;
                    ProcessModelParameter param = (ProcessModelParameter)item.getData();
                    if (item.getChecked()) {
                        if (!VarParallelismWizardPage.this.data.getInputParameters().contains(param)) {
                            for (ProcessModelParameter tempParam : VarParallelismWizardPage.this.data.getInputParameters()) {
                                if (!tempParam.getName().equals(param.getName())) continue;
                                param = tempParam;
                                break;
                            }
                        }
                        ProcessModelParameter listParam = (ProcessModelParameter)paramNameToParam.get(param.getName());
                        VarParallelismWizardPage.this.data.getIndexedInputParameters().add(listParam);
                        VarParallelismWizardPage.this.data.getInputParameters().remove(param);
                        VarParallelismWizardPage.this.data.getInputParameters().add(listParam);
                        VarParallelismWizardPage.this.data.changeParameter(param, listParam, ActivityConstants.AccessType.READ);
                        if (VarParallelismWizardPage.this.getMessage() != null) {
                            VarParallelismWizardPage.this.setMessage(null);
                            VarParallelismWizardPage.this.setPageComplete(true);
                        }
                    } else {
                        ProcessModelParameter listParam = (ProcessModelParameter)paramNameToParam.get(param.getName());
                        VarParallelismWizardPage.this.data.getIndexedInputParameters().remove(listParam);
                        VarParallelismWizardPage.this.data.getInputParameters().remove(listParam);
                        VarParallelismWizardPage.this.data.getInputParameters().add(param);
                        VarParallelismWizardPage.this.data.changeParameter(listParam, param, ActivityConstants.AccessType.READ);
                        if (VarParallelismWizardPage.this.getMessage() == null && VarParallelismWizardPage.this.data.getIndexedInputParameters().isEmpty()) {
                            VarParallelismWizardPage.this.setMessage(VarParallelismWizardPage.INFO, 1);
                            VarParallelismWizardPage.this.setPageComplete(false);
                        }
                    }
                }
            }
        });
        boolean varPar = this.data.isVariableParallelism();
        varParButton.setSelection(varPar);
        varParLabel.setEnabled(varPar);
        this.table.setEnabled(varPar);
        if (varPar) {
            TableItem[] tableItemArray = this.table.getItems();
            int n3 = tableItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray[n4];
                String name = ((ProcessModelParameter)item.getData()).getName();
                for (ProcessModelParameter param : this.data.getIndexedInputParameters()) {
                    if (!param.getName().equals(name)) continue;
                    item.setChecked(true);
                    break;
                }
                ++n4;
            }
            if (this.getMessage() == null && this.data.getIndexedInputParameters().isEmpty()) {
                this.setMessage(INFO, 1);
                this.setPageComplete(false);
            }
        } else {
            this.initVarParParameters();
        }
        this.storeOriginalParams();
        this.setControl((Control)container);
    }

    private Map<String, ProcessModelParameter> createListInputParameters() {
        HashMap<String, ProcessModelParameter> paramNameToParam = new HashMap<String, ProcessModelParameter>();
        Set<ProcessModelParameter> parameters = this.data.getInputParameters().size() > 0 ? this.data.getInputParameters() : this.data.getParameters(ActivityConstants.AccessType.READ);
        for (ProcessModelParameter param : parameters) {
            String udtName = param.getUDTName() == null ? "" : "," + param.getUDTName();
            ProcessModelParameter indexedParam = null;
            if (this.data.getIndexedInputParameters().contains(param)) {
                indexedParam = param;
            } else {
                ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
                indexedParam = pmf.createProcessModelParameter(param.getName(), param.getDescription(), ProcessConstants.AdeptDataType.USERDEFINED, "java.util.List<" + param.getDataType().name() + udtName + ">", param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
            }
            paramNameToParam.put(param.getName(), indexedParam);
        }
        return paramNameToParam;
    }

    private void initVarParParameters() {
        this.data.setInputParameters(new HashSet<ProcessModelParameter>(this.data.getTemplate().getParameters(ActivityConstants.AccessType.READ)));
        HashSet<ProcessModelParameter> outputParameterLists = new HashSet<ProcessModelParameter>();
        ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
        for (ProcessModelParameter param : this.data.getParameters(ActivityConstants.AccessType.WRITE)) {
            String udtName = param.getUDTName() == null ? "" : "," + param.getUDTName();
            outputParameterLists.add(pmf.createProcessModelParameter(param.getName(), param.getDescription(), ProcessConstants.AdeptDataType.USERDEFINED, "java.util.List<" + param.getDataType().name() + udtName + ">", param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes()));
        }
        this.data.setOutputParameters(outputParameterLists);
    }

    private void storeOriginalParams() {
        Set<ProcessModelParameter> inParams = this.data.getParameters(ActivityConstants.AccessType.READ);
        for (ProcessModelParameter param : inParams) {
            this.paramNameToOriginalInputParam.put(param.getName(), param);
        }
        Set<ProcessModelParameter> outParams = this.data.getParameters(ActivityConstants.AccessType.WRITE);
        for (ProcessModelParameter param : outParams) {
            this.paramNameToOriginalOutputParam.put(param.getName(), param);
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getMessage() != null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    protected void reactOnResizeEvent(TableColumn[] tableColumns) {
        Composite parent = this.table.getParent();
        Rectangle area = parent.getClientArea();
        Point inPreferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth() - (((GridLayout)parent.getLayout()).marginLeft + ((GridLayout)parent.getLayout()).marginRight + 2 * ((GridLayout)parent.getLayout()).marginWidth);
        if (inPreferredSize.y >= area.height + this.table.getHeaderHeight() - 2 * ((GridLayout)parent.getLayout()).marginHeight) {
            Point vBarSize = this.table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.table.getSize();
        if (oldSize.x > area.width) {
            if (width / 2 > 150) {
                tableColumns[0].setWidth(width / 2);
                tableColumns[1].setWidth(width / 2);
            } else {
                tableColumns[0].setWidth(150);
                tableColumns[1].setWidth(150);
            }
            this.table.setSize(area.width, area.height);
        } else {
            this.table.setSize(area.width, area.height);
            if (width / 2 > 150) {
                tableColumns[0].setWidth(width / 2);
                tableColumns[1].setWidth(width / 2);
            } else {
                tableColumns[0].setWidth(150);
                tableColumns[1].setWidth(150);
            }
        }
    }

    class InputParamLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        InputParamLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            ProcessModelParameter param = (ProcessModelParameter)element;
            switch (columnIndex) {
                case 0: {
                    text = param.getName();
                    break;
                }
                case 1: {
                    text = param.getDataType().toString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("columnIndex " + columnIndex + " not handled.");
                }
            }
            return text;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

